/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.erps;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSBindSubRingReq;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSBindSubRingRsp;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSBinding;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginIF;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsUtil;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EErpsBindSubRingHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private QAsnErrInfoList errList = new QAsnErrInfoList();
    private QAsnErrInfoList errInfo = new QAsnErrInfoList();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        e2eLogger.info("handleRequestImpl: handle QAsnERPSBindSubRingReq begin.");
        QAsnERPSBindSubRingReq req = (QAsnERPSBindSubRingReq)qReq;
        QAsnERPSBindSubRingRsp rsp = (QAsnERPSBindSubRingRsp)qRsp;
        rsp.erpsBindingList.clear();
        rsp.result.result = 0;
        if (req == null || req.erpsBindingList.isEmpty()) {
            e2eLogger.info("handleRequestImpl: QAsnERPSBindSubRingReq.erpsBindingList is empty!");
            return 0;
        }
        int size = req.erpsBindingList.size();
        for (int i = 0; i < size; ++i) {
            QAsnERPSBinding binding = (QAsnERPSBinding)req.erpsBindingList.get(i);
            binding.poResult = new QAsnErrInfoReturn();
            binding.poResult.errList = new QAsnErrInfoList();
            int neID = binding.erpsSubIndex.neID;
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                binding.poResult.result = 1090596385;
                QAsnErrInfo errResult = new QAsnErrInfo();
                errResult.objID.add((Object)neID);
                errResult.errCode = 1090596385;
                binding.poResult.errList.add((Object)errResult);
                rsp.erpsBindingList.add((Object)binding);
                continue;
            }
            int colresult = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
            if (colresult != 0) {
                binding.poResult.result = colresult;
                QAsnErrInfo errResult = new QAsnErrInfo();
                errResult.objID.add((Object)neID);
                errResult.errCode = colresult;
                binding.poResult.errList.add((Object)errResult);
                rsp.erpsBindingList.add((Object)binding);
                continue;
            }
            int erpsid = TEE2EErpsUtil.getErpsID(new String(binding.erpsSubIndex.erpsKey.strFDN));
            int mastererpsid = TEE2EErpsUtil.getErpsID(new String(binding.erpsMainIndex.erpsKey.strFDN));
            int result = this.bindSubRing(null, neID, erpsid, mastererpsid);
            binding.poResult.result = 0;
            if (result != 0) {
                binding.poResult.result = 1090650122;
                binding.poResult.errList.addAll((Collection)this.errInfo);
            }
            rsp.erpsBindingList.add((Object)binding);
        }
        if (this.errList.size() > 0) {
            rsp.result.errList = this.errList;
            rsp.result.result = 1090650122;
        }
        e2eLogger.info("handleRequestImpl: handle QAsnERPSBindSubRingReq end.");
        return 0;
    }

    private int bindSubRing(String userID, int neID, int erpsID, int mastererpsid) {
        int err = 0;
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam = new RowParams();
        bus.addRowParams(rowParam);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rowParam.addParam(p);
        p = new Param("erpsid", String.valueOf(erpsID));
        rowParam.addParam(p);
        p = new Param("mastererpsid", String.valueOf(mastererpsid));
        rowParam.addParam(p);
        int sfid = 2180618;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            TELogFactory.getE2ELogger().info(e1.getMessage());
        }
        if (null == subFunc) {
            return 1090650122;
        }
        subFunc.setBeanPlugin(null);
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = null == subFunc.getClassMapping() ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(subFunc.getClassMapping()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean) {
            TEE2EErpsBindSubRingHandler.setBeanPlugin(neMgrBean, subFunc);
            allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, userID, null);
            this.errInfo.clear();
            err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 != err && null != allData.getBussinessParams() && allData.getBussinessParams().getRowParamsCount() > 0) {
                int len = allData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowParams vRowParams = allData.getBussinessParams().getRowParams(i);
                    int jLen = vRowParams.getRowErrorsCount();
                    for (int j = 0; j < jLen; ++j) {
                        RowErrors vRowError = vRowParams.getRowErrors(j);
                        ErrorMessage errorMessage = vRowError.getErrorMessage();
                        if (null == errorMessage.getErrorcode() || "".equals(errorMessage.getErrorcode())) continue;
                        QAsnErrInfo errResult = new QAsnErrInfo();
                        errResult.objID.add((Object)neID);
                        errResult.errCode = Integer.parseInt(errorMessage.getErrorcode());
                        errResult.strOperDesc = errorMessage.getErrorinfo().getBytes();
                        this.errInfo.add((Object)errResult);
                        this.errList.add((Object)errResult);
                    }
                }
            }
        }
        return err;
    }

    private static void setBeanPlugin(TENEMgrInterface neMgrBean, SubFunc subFunc) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        String beanPluginStr = subFunc.getBeanPlugin();
        if (null == beanPluginStr || beanPluginStr.isEmpty()) {
            return;
        }
        try {
            if (neMgrBean instanceof TENEExplorerBean) {
                TENEExplorerBean bean = (TENEExplorerBean)neMgrBean;
                TEBeanPluginIF beanPlugin = TEE2EErpsBindSubRingHandler.praseBeanPlugin(beanPluginStr);
                bean.setBeanPluginIF(beanPlugin);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Bean Plugin init fail: " + beanPluginStr, (Throwable)e);
        }
    }

    private static TEBeanPluginIF praseBeanPlugin(String beanPluginStr) {
        TEBeanPluginIF beanPlugin = null;
        try {
            beanPlugin = (TEBeanPluginIF)Class.forName(beanPluginStr.trim()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Bean Plugin init fail: " + beanPluginStr, (Throwable)e);
        }
        return beanPlugin;
    }
}

