/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.erps;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSAddVChnlVlansReq;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSAddVChnlVlansRsp;
import com.huawei.network.qasn.m_q_nml_erps.QAsnErpsVlans;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginIF;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsUtil;
import com.huawei.nglct.nemgr.ip.ptn.erps.beanplugin.TENEERPSBeanPluginUtil;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnERPSInfo;
import com.huawei.nglct.po.embeddednemgrmo.ptn.TEPTNERPSMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEStringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EErpsAddVChnlVlansHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final int MAX_VLANS = 255;
    private QAsnErrInfoList errList = new QAsnErrInfoList();
    private QAsnErrInfoList errInfo = new QAsnErrInfoList();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        e2eLogger.info("handleRequestImpl: handle QAsnERPSAddVChnlVlansReq begin.");
        QAsnERPSAddVChnlVlansReq req = (QAsnERPSAddVChnlVlansReq)qReq;
        QAsnERPSAddVChnlVlansRsp rsp = (QAsnERPSAddVChnlVlansRsp)qRsp;
        rsp.erpsVlanInfo.clear();
        rsp.result.result = 0;
        if (req == null || req.erpsVlanInfo.isEmpty()) {
            e2eLogger.info("handleRequestImpl: QAsnERPSAddVChnlVlansReq.erpsVlanInfo is empty!");
            return 0;
        }
        int size = req.erpsVlanInfo.size();
        for (int i = 0; i < size; ++i) {
            QAsnErpsVlans erpsVlan = (QAsnErpsVlans)req.erpsVlanInfo.get(i);
            erpsVlan.poResult = new QAsnErrInfoReturn();
            erpsVlan.poResult.errList = new QAsnErrInfoList();
            int neID = erpsVlan.erpskey.neID;
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                erpsVlan.poResult.result = 1090596385;
                QAsnErrInfo errResult = new QAsnErrInfo();
                errResult.objID.add((Object)neID);
                errResult.errCode = 1090596385;
                erpsVlan.poResult.errList.add((Object)errResult);
                rsp.erpsVlanInfo.add((Object)erpsVlan);
                continue;
            }
            int colresult = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
            if (colresult != 0) {
                erpsVlan.poResult.result = colresult;
                QAsnErrInfo errResult = new QAsnErrInfo();
                errResult.objID.add((Object)neID);
                errResult.errCode = colresult;
                erpsVlan.poResult.errList.add((Object)errResult);
                rsp.erpsVlanInfo.add((Object)erpsVlan);
                continue;
            }
            int erpsid = TEE2EErpsUtil.getErpsID(new String(erpsVlan.erpskey.erpsKey.strFDN));
            ArrayList<Integer> vlans = new ArrayList<Integer>();
            int kSize = erpsVlan.vlanlist.size();
            for (int k = 0; k < kSize; ++k) {
                vlans.add(((BigInteger)erpsVlan.vlanlist.get(k)).intValue());
            }
            int result = this.addVChnlVlans(neID, erpsid, vlans);
            erpsVlan.poResult.result = 0;
            if (result != 0) {
                erpsVlan.poResult.result = 1090650122;
                erpsVlan.poResult.errList.addAll((Collection)this.errInfo);
            }
            rsp.erpsVlanInfo.add((Object)erpsVlan);
        }
        if (this.errList.size() > 0) {
            rsp.result.errList = this.errList;
            rsp.result.result = 1090650122;
        }
        e2eLogger.info("handleRequestImpl: handle QAsnERPSAddVChnlVlansReq end.");
        return 0;
    }

    private int addVChnlVlans(int neID, int erpsID, List<Integer> vlanList) {
        int err = 0;
        List<Integer> vlanIdList = this.getVChnlVlans(neID, erpsID, vlanList);
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam = new RowParams();
        bus.addRowParams(rowParam);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rowParam.addParam(p);
        p = new Param("erpsid", String.valueOf(erpsID));
        rowParam.addParam(p);
        int vlanid_num = vlanIdList.size();
        if (vlanid_num >= 1) {
            StringBuffer vlanIdbuffer = new StringBuffer();
            String tempIDStr = "";
            if (vlanid_num <= 255) {
                for (int j = 0; j < vlanIdList.size(); ++j) {
                    tempIDStr = Integer.toHexString(vlanIdList.get(j));
                    vlanIdbuffer.append(TEStringUtils.convertStringToProtolType((String)tempIDStr, (int)4));
                }
                p = new Param("vlanidcount", String.valueOf(vlanid_num));
                rowParam.addParam(p);
                p = new Param("vlanidlist", vlanIdbuffer.toString());
                rowParam.addParam(p);
            }
        } else {
            p = new Param("vlanidcount", "0");
            rowParam.addParam(p);
            p = new Param("vlanidlist", "");
            rowParam.addParam(p);
        }
        int sfid = 2180619;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            TELogFactory.getE2ELogger().info(e1.getMessage());
        }
        if (null == subFunc) {
            return 1090650122;
        }
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = null == subFunc.getClassMapping() ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(subFunc.getClassMapping()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean) {
            TEE2EErpsAddVChnlVlansHandler.setBeanPlugin(neMgrBean, subFunc);
            allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, null, null);
            this.errInfo.clear();
            err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 != err && null != allData.getBussinessParams() && allData.getBussinessParams().getRowParamsCount() > 0) {
                int len = allData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowParams vRowParams = allData.getBussinessParams().getRowParams(i);
                    int jLen = vRowParams.getRowErrorsCount();
                    for (int j = 0; j < jLen; ++j) {
                        RowErrors vRowError = vRowParams.getRowErrors(j);
                        ErrorMessage errorMessage = vRowError.getErrorMessage();
                        if (null == errorMessage.getErrorcode() || "".equals(errorMessage.getErrorcode())) continue;
                        QAsnErrInfo errResult = new QAsnErrInfo();
                        errResult.objID.add((Object)neID);
                        errResult.errCode = Integer.parseInt(errorMessage.getErrorcode());
                        errResult.strOperDesc = errorMessage.getErrorinfo().getBytes();
                        this.errInfo.add((Object)errResult);
                        this.errList.add((Object)errResult);
                    }
                }
            }
        }
        return err;
    }

    private List<Integer> getVChnlVlans(int neID, int erpsID, List<Integer> vlanList) {
        ArrayList<Integer> vlans = new ArrayList<Integer>();
        TEDaoOperationResult dbResult = null;
        dbResult = TENEERPSBeanPluginUtil.findNEERpsFromDB(neID);
        if (dbResult != null && dbResult.getResult() == 0) {
            List dbDataList = dbResult.getData();
            int count = dbDataList.size();
            for (int j = 0; j < count; ++j) {
                TEPTNERPSMOPO dataMO = (TEPTNERPSMOPO)dbDataList.get(j);
                if (erpsID != dataMO.getErpsID()) continue;
                QAsnERPSInfo erpsInfo = TEE2EErpsUtil.convertPTNERPSMopotoQAsnErpsInfo(dataMO, neID);
                String virChannelVlans = new String(erpsInfo.virChannelVlans);
                vlans.addAll(TEE2EErpsUtil.parseValidValue(virChannelVlans));
            }
        }
        int kSize = vlanList.size();
        for (int k = 0; k < kSize; ++k) {
            Integer vlan = vlanList.get(k);
            if (vlans.contains(vlan)) continue;
            vlans.add(vlan);
        }
        return vlans;
    }

    private static void setBeanPlugin(TENEMgrInterface neMgrBean, SubFunc subFunc) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        String beanPluginStr = subFunc.getBeanPlugin();
        if (null == beanPluginStr || beanPluginStr.isEmpty()) {
            return;
        }
        try {
            if (neMgrBean instanceof TENEExplorerBean) {
                TENEExplorerBean bean = (TENEExplorerBean)neMgrBean;
                TEBeanPluginIF beanPlugin = TEE2EErpsAddVChnlVlansHandler.praseBeanPlugin(beanPluginStr);
                bean.setBeanPluginIF(beanPlugin);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Bean Plugin init fail: " + beanPluginStr, (Throwable)e);
        }
    }

    private static TEBeanPluginIF praseBeanPlugin(String beanPluginStr) {
        TEBeanPluginIF beanPlugin = null;
        try {
            beanPlugin = (TEBeanPluginIF)Class.forName(beanPluginStr.trim()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Bean Plugin init fail: " + beanPluginStr, (Throwable)e);
        }
        return beanPlugin;
    }
}

