/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e1clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;

public class TEQueryE1ClockBean
extends TENEExplorerBean {
    private static final String E1_CLOCK = "E1_CLOCK";

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_E1_CLK");
        ArrayList<Object> operationList = new ArrayList<Object>();
        if (TEQueryE1ClockBean.isSupportAllF(neid)) {
            operation.getInput().setPartValue("e1clkslot", String.valueOf(65535));
            operation.getInput().setPartValue("e1clkid", "0");
            operationList.add(operation.clone());
        } else {
            TIntArrayList slotes = TEQueryE1ClockBean.getAcrClockSlot(neid);
            int m = slotes.size();
            for (int i = 0; i < m; ++i) {
                operation.getInput().setPartValue("e1clkslot", String.valueOf(slotes.get(i)));
                operation.getInput().setPartValue("e1clkid", "0");
                operationList.add(operation.clone());
            }
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        int size = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < size; ++i) {
            RowParams rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getRowErrorsCount() != 0) continue;
            int slotid = Integer.parseInt(rowParams.getParam("slotid").getValue());
            int boardType = TENEListMgr.getInstance().getNE(neid).getBoard(slotid).getBoardType();
            int portid = Integer.parseInt(rowParams.getParam("portid").getValue());
            String portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, boardType, portid, 16);
            rowParams.addParam("portname", portname);
        }
    }

    public static TIntArrayList getAcrClockSlot(int neid) {
        TIntArrayList slotes = new TIntArrayList();
        List boardList = TEGenCfgCommon.getAttrSupportCPs((int)neid, (String)E1_CLOCK);
        TEBoard board = null;
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            board = (TEBoard)boardList.get(i);
            if (board == null) continue;
            int slotid = board.getSlotID();
            slotes.add(slotid);
        }
        return slotes;
    }

    public static boolean isSupportAllF(int neid) {
        TENE neObjMgr = TENEListMgr.getInstance().getNE(neid);
        if (null == neObjMgr) {
            TELogFactory.getNormalLogger().info("The NE Not Fount in NEList:" + neid);
            return false;
        }
        int shelfType = neObjMgr.getShelfType();
        if (!TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CES_CLK", "TE_ATTR_RTN_SUPPORT_E1_CES_CLOCK")) {
            return false;
        }
        List supportShelfList = TESpecialAttrMgr.getInstance().getNEAttrListValue(neid, "TE_FUNC_CES_CLK", "TE_ATTR_RTN_SUPPORT_E1_CES_CLOCK");
        if (supportShelfList == null || supportShelfList.size() == 0) {
            return false;
        }
        for (int i = 0; i < supportShelfList.size(); ++i) {
            if (Integer.parseInt((String)supportShelfList.get(i)) != shelfType) continue;
            return true;
        }
        return false;
    }
}

