/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.diffserv;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TESetDiffservBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        int len = businessparams.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = businessparams.getRowParams(i);
            String operateFlag = rowparams.getParam("operateFlag").getValue();
            if ("modifyName".equals(operateFlag)) {
                this.getModifyNameOper(rowparams);
            }
            if ("deleteMap".equals(operateFlag)) {
                this.getDeleteMapOper(rowparams);
            }
            if (!"modifyMap".equals(operateFlag)) continue;
            this.getModifyMapOper(rowparams);
        }
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void getModifyNameOper(RowParams rowparams) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_SET_COSPRIMAPNAME");
        Input input = oper.getInput();
        input.setPartValue("cosID", rowparams.getParam("cosID").getValue());
        input.setPartValue("cosName", rowparams.getParam("cosName").getValue());
        this.operationList.add(oper);
    }

    private void getDeleteMapOper(RowParams rowparams) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_DEL_INCOSPRIMAP");
        Input input = oper.getInput();
        input.setPartValue("cosID", rowparams.getParam("cosID").getValue());
        input.setPartValue("cosMapType", rowparams.getParam("cosMapType").getValue());
        input.setPartValue("encapsValue", rowparams.getParam("encapsValue").getValue());
        this.operationList.add(0, oper);
    }

    private void getModifyMapOper(RowParams rowparams) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_SET_INCOSPRIMAP");
        Input input = oper.getInput();
        input.setPartValue("cosID", rowparams.getParam("cosID").getValue());
        input.setPartValue("cosMapType", rowparams.getParam("cosMapType").getValue());
        input.setPartValue("encapsValue", rowparams.getParam("encapsValue").getValue());
        input.setPartValue("cos", rowparams.getParam("cos").getValue());
        this.operationList.add(oper);
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            int errorCodeTemp = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfoTemp = null;
            int userIDParam = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userIDParam = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userIDParam = TESecurityVerify.getSuperUserID();
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObjStr = "";
            operObjStr = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            RowParams rowparams = null;
            RowParams errorRowParams = null;
            int tmpErrorCodeInt = 0;
            int len = inputData.getBussinessParams().getRowParamsCount();
            for (i = 1; i < len; ++i) {
                loginfoTemp = new TELogInfo();
                rowparams = inputData.getBussinessParams().getRowParams(i);
                loginfoTemp.setOperateDesc(this.getDetailStr(rowparams));
                if (errorCodeTemp != 0 && errorCodeTemp != 2 && errorCodeTemp != 1) {
                    loginfoTemp.setResult(2);
                    loginfoTemp.setErrCode(errorCodeTemp);
                    loginfoTemp.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCodeTemp));
                } else if (errorCodeTemp == 0) {
                    loginfoTemp.setResult(0);
                    loginfoTemp.setErrCode(errorCodeTemp);
                    loginfoTemp.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCodeTemp));
                } else {
                    int outputRowCount = outputData.getBussinessParams().getRowParamsCount();
                    errorRowParams = outputData.getBussinessParams().getRowParams(outputRowCount - 1);
                    tmpErrorCodeInt = this.getOperResult(rowparams, errorRowParams);
                    if (tmpErrorCodeInt != 0) {
                        loginfoTemp.setResult(2);
                    } else {
                        loginfoTemp.setResult(0);
                    }
                    loginfoTemp.setErrCode(tmpErrorCodeInt);
                    loginfoTemp.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)tmpErrorCodeInt));
                }
                loginfoList.add(loginfoTemp);
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                loginfoTemp = (TELogInfo)loginfoList.get(i);
                loginfoTemp.setCmdID(subfunc.getCode());
                loginfoTemp.setLocation(ipAddress);
                loginfoTemp.setUserID(userIDParam);
                loginfoTemp.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfoTemp.setOperateName(subfunc.getSubFuncDes(neid));
                loginfoTemp.setOperateObject(operObjStr);
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public String getDetailStr(RowParams rowparams) {
        String cosMapType;
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String DIFFSERV_RES = "ip" + File.separator + "ptn" + File.separator + "res" + File.separator + "diffserv" + File.separator + "diffserv_" + LANGUAGE + ".ini";
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)DIFFSERV_RES);
        StringBuffer operDesc = new StringBuffer();
        String operateFlag = rowparams.getParam("operateFlag").getValue();
        if ("modifyName".equals(operateFlag)) {
            operDesc.append(resourceUtil.getString("modifyName")).append(" ").append(resourceUtil.getString("cosID")).append(":").append(rowparams.getParam("cosID").getValue()).append(",").append(resourceUtil.getString("cosName")).append(":").append(rowparams.getParam("cosName").getValue());
        }
        if ("deleteMap".equals(operateFlag)) {
            cosMapType = rowparams.getParam("cosMapType").getValue();
            operDesc.append(resourceUtil.getString("deleteMap")).append(" ").append(resourceUtil.getString("cosID")).append(":").append(rowparams.getParam("cosID").getValue()).append(",").append(resourceUtil.getString("cosMapType")).append(":").append(resourceUtil.getString("cosMapType" + cosMapType)).append(",").append(resourceUtil.getString("encapsValue")).append(":").append(rowparams.getParam("encapsValue").getValue());
        }
        if ("modifyMap".equals(operateFlag)) {
            cosMapType = rowparams.getParam("cosMapType").getValue();
            String cos = rowparams.getParam("cos").getValue();
            operDesc.append(resourceUtil.getString("modifyMap")).append(" ").append(resourceUtil.getString("cosID")).append(":").append(rowparams.getParam("cosID").getValue()).append(",").append(resourceUtil.getString("cosMapType")).append(":").append(resourceUtil.getString("cosMapType" + cosMapType)).append(",").append(resourceUtil.getString("encapsValue")).append(":").append(rowparams.getParam("encapsValue").getValue()).append(",").append(resourceUtil.getString("cos")).append(":").append(resourceUtil.getString("cos" + cos));
        }
        return operDesc.toString();
    }
}

