/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.diffserv;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class TEQueryIngressBean
extends TENEExplorerBean {
    private static final int SERVICE_LEVEL_COUNT = 16;
    private static final int CVLAN = 1;
    private static final int SVLAN = 2;
    private static final int DEI_SVLAN = 3;
    private static final int IP_DSCP = 4;
    private static final int MPLS_EXP = 5;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int i;
        this.outputData.setBussinessParams(new BussinessParams());
        Operation operation = null;
        Output output = null;
        RowParams rowparams = null;
        Param param = null;
        boolean allSuccess = true;
        boolean allFault = true;
        ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
        String tempStr = "";
        for (i = 1; i <= 16; ++i) {
            rowparams = new RowParams();
            param = new Param("cvlan", "");
            rowparams.addParam(param);
            param = new Param("svlan", "");
            rowparams.addParam(param);
            param = new Param("deisvlan", "");
            rowparams.addParam(param);
            param = new Param("ipdscp", "");
            rowparams.addParam(param);
            param = new Param("mplsexp", "");
            rowparams.addParam(param);
            param = new Param("cos", "" + i);
            rowparams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(i - 1, rowparams);
        }
        int len = operationList.size();
        for (i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                Fault[] faultArr = output.getFault();
                int code = 0;
                for (Fault fault : faultArr) {
                    code = Integer.parseInt(fault.getCode());
                    if (0 == code) continue;
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)neid, (int)code));
                    allSuccess = false;
                    RowErrors rowError = new RowErrors();
                    Param errorParam = new Param("errorBbj", neid + "Query Ingress Mapping Relation");
                    rowError.addParam(errorParam);
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)code));
                    rowErrorList.add(rowError);
                    break;
                }
                if (false != code) continue;
                allFault = false;
                int cos = Integer.parseInt(output.getPartValue("cos"));
                int cosMapType = Integer.parseInt(output.getPartValue("cosMapType"));
                rowparams = this.outputData.getBussinessParams().getRowParams(cos - 1);
                switch (cosMapType) {
                    case 1: {
                        param = rowparams.getParam("cvlan");
                        break;
                    }
                    case 2: {
                        param = rowparams.getParam("svlan");
                        break;
                    }
                    case 3: {
                        param = rowparams.getParam("deisvlan");
                        break;
                    }
                    case 4: {
                        param = rowparams.getParam("ipdscp");
                        break;
                    }
                    case 5: {
                        param = rowparams.getParam("mplsexp");
                        break;
                    }
                    default: {
                        TELogFactory.getNormalLogger().info("TEQueryIngressBean.handleMessage() cosMapType:" + cosMapType + " not in case!");
                    }
                }
                tempStr = param.getValue();
                param.setValue(tempStr + output.getPartValue("encapsValue") + ",");
            }
        }
        for (i = 0; i < 16; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            param = rowparams.getParam("cvlan");
            param.setValue(this.parseEncapsValueList(param));
            param = rowparams.getParam("svlan");
            param.setValue(this.parseEncapsValueList(param));
            param = rowparams.getParam("deisvlan");
            param.setValue(this.parseEncapsValueList(param));
            param = rowparams.getParam("ipdscp");
            param.setValue(this.parseEncapsValueList(param));
            param = rowparams.getParam("mplsexp");
            param.setValue(this.parseEncapsValueList(param));
        }
        int size = rowErrorList.size();
        for (i = 0; i < size; ++i) {
            RowParams rParam = new RowParams();
            RowErrors rError = (RowErrors)rowErrorList.get(i);
            rParam.addRowErrors(rError);
            this.outputData.getBussinessParams().addRowParams(rParam);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (allSuccess && !allFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!allSuccess && allFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
    }

    private String parseEncapsValueList(Param param) {
        if (param.getValue().equals("")) {
            return "";
        }
        String[] stringArray = param.getValue().split(",");
        int[] intArray = new int[stringArray.length];
        int len = stringArray.length;
        for (int j = 0; j < len; ++j) {
            intArray[j] = Integer.parseInt(stringArray[j]);
        }
        Arrays.sort(intArray);
        ArrayList<String> encapsValue = new ArrayList<String>();
        int len2 = stringArray.length;
        for (int j = 0; j < len2; ++j) {
            encapsValue.add(intArray[j] + "");
        }
        String result = "";
        if (encapsValue.size() >= 2) {
            Iterator it = encapsValue.iterator();
            int curNum = new Integer((String)it.next());
            int offset = 0;
            StringBuffer temp = new StringBuffer(String.valueOf(curNum));
            int tmpnum = -1;
            while (it.hasNext()) {
                int nextNum = new Integer((String)it.next());
                if (nextNum != curNum + offset + 1) {
                    if (offset != 0) {
                        tmpnum = curNum + offset;
                        temp.append("-").append(tmpnum);
                        temp.append(",").append(nextNum);
                    } else {
                        temp.append(",").append(nextNum);
                    }
                    offset = 0;
                    curNum = nextNum;
                    continue;
                }
                ++offset;
            }
            if (offset > 0) {
                tmpnum = curNum + offset;
                temp.append("-").append(tmpnum);
            }
            result = temp.toString();
        } else if (encapsValue.size() == 1) {
            result = encapsValue.get(0).toString();
        }
        return result;
    }
}

