/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.diffserv;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryEgressBean
extends TENEExplorerBean {
    private static final int SERVICE_LEVEL_COUNT = 16;
    private static final int CVLAN = 1;
    private static final int SVLAN = 2;
    private static final int DEI_SVLAN = 3;
    private static final int IP_DSCP = 4;
    private static final int MPLS_EXP = 5;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int i;
        this.outputData.setBussinessParams(new BussinessParams());
        Operation oper = null;
        Output opt = null;
        RowParams rowparams = null;
        Param params = null;
        boolean allSuccessful = true;
        boolean allFault = true;
        ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
        for (i = 1; i <= 16; ++i) {
            rowparams = new RowParams();
            params = new Param("cvlan", "");
            rowparams.addParam(params);
            params = new Param("svlan", "");
            rowparams.addParam(params);
            params = new Param("deisvlan", "");
            rowparams.addParam(params);
            params = new Param("ipdscp", "");
            rowparams.addParam(params);
            params = new Param("mplsexp", "");
            rowparams.addParam(params);
            params = new Param("cos", "" + i);
            rowparams.addParam(params);
            this.outputData.getBussinessParams().addRowParams(i - 1, rowparams);
        }
        int len = operationList.size();
        for (i = 0; i < len; ++i) {
            oper = (Operation)operationList.get(i);
            int size = oper.getOutputCount();
            for (int row = 0; row < size; ++row) {
                opt = oper.getOutput(row);
                Fault[] faultArr = opt.getFault();
                int code = 0;
                for (Fault fault : faultArr) {
                    code = Integer.parseInt(fault.getCode());
                    if (0 == code) continue;
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)neid, (int)code));
                    allSuccessful = false;
                    RowErrors rowErr = new RowErrors();
                    Param errorParam = new Param("errorBbj", neid + "Query Ingress Mapping Relation");
                    rowErr.addParam(errorParam);
                    rowErr.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)code));
                    rowErrorList.add(rowErr);
                    break;
                }
                if (false != code) continue;
                allFault = false;
                int cos = Integer.parseInt(opt.getPartValue("cos"));
                int cosMapType = Integer.parseInt(opt.getPartValue("cosMapType"));
                rowparams = this.outputData.getBussinessParams().getRowParams(cos - 1);
                switch (cosMapType) {
                    case 1: {
                        params = rowparams.getParam("cvlan");
                        break;
                    }
                    case 2: {
                        params = rowparams.getParam("svlan");
                        break;
                    }
                    case 3: {
                        params = rowparams.getParam("deisvlan");
                        break;
                    }
                    case 4: {
                        params = rowparams.getParam("ipdscp");
                        break;
                    }
                    case 5: {
                        params = rowparams.getParam("mplsexp");
                        break;
                    }
                    default: {
                        TELogFactory.getNormalLogger().info("TEQueryEgressBean.handleMessage() cosMapType:" + cosMapType + " not in case!");
                    }
                }
                params.setValue(opt.getPartValue("encapsValue"));
            }
        }
        int size = rowErrorList.size();
        for (i = 0; i < size; ++i) {
            RowParams rParams = new RowParams();
            RowErrors rError = (RowErrors)rowErrorList.get(i);
            rParams.addRowErrors(rError);
            this.outputData.getBussinessParams().addRowParams(rParams);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (allSuccessful && !allFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!allSuccessful && allFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
    }
}

