/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.diffserv;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.diffserv.TEUsableResource;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class TEGetPortsBean
implements TENEMgrInterface {
    private Datainterface datainterface = new Datainterface();
    private BussinessParams bParams = new BussinessParams();
    private int neID = -1;
    private ArrayList usableResourceList = new ArrayList();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
    TEPortModelConfigurationDataMgr cfgPortMgr = TEPortModelConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        if (boardList == null || boardList.size() == 0) {
            this.datainterface.setBussinessParams(this.bParams);
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource usableRes;
            TEBoard board = (TEBoard)boardList.get(i);
            int bdType = board.getBoardType();
            int slotID = board.getSlotID();
            String bdName = board.getBoardName();
            List subBoardList = board.getSubBoardList();
            int len = subBoardList.size();
            int subBoardType = 0;
            int subBoardId = 0;
            ArrayList portList = null;
            String subdName = "";
            if (0 < len) {
                for (int k = 0; k < len; ++k) {
                    TEUsableResource usableRes2;
                    TESubBoard subBoard = (TESubBoard)subBoardList.get(k);
                    subBoardId = subBoard.getSubSlotID();
                    subBoardType = subBoard.getSubBoardType();
                    portList = this.cfgDataMgr.getBoardPortList(neid, subBoardType, slotID);
                    ArrayList<String> portidList = new ArrayList<String>();
                    ArrayList<String> portNameList = new ArrayList<String>();
                    int size3 = portList.size();
                    for (int l = 0; l < size3; ++l) {
                        int portID = (Integer)portList.get(l);
                        portidList.add(l, portID + "");
                        String portName = this.cfgDataMgr.getPortNameForPTN(this.neID, slotID, subBoardType, portID);
                        portNameList.add(l, portName);
                    }
                    if (portidList.size() <= 0 || this.usableResourceList.contains((Object)(usableRes2 = new TEUsableResource(slotID, bdName, subBoardId, subdName = this.cfgDataMgr.getBoardTypeName(this.neID, subBoardType), portidList, portNameList)))) continue;
                    this.usableResourceList.add(usableRes2);
                }
                continue;
            }
            portList = this.getPortList(slotID, bdType, inputData.getBussinessParams().getRowParams(0).getParam("PortType"));
            ArrayList<String> portidList = new ArrayList<String>();
            ArrayList<String> portNameList = new ArrayList<String>();
            int size3 = portList.size();
            for (int l = 0; l < size3; ++l) {
                int portID = ((TEPort)portList.get(l)).getPortNo();
                portidList.add(l, portID + "");
                String portName = this.cfgDataMgr.getPortNameForPTN(this.neID, slotID, bdType, portID);
                portNameList.add(l, portName);
            }
            if (portidList.size() <= 0 || this.usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotID, bdName, subBoardId, subdName, portidList, portNameList)))) continue;
            this.usableResourceList.add(usableRes);
        }
        Datainterface value = this.constructRtnData();
        return value;
    }

    public Datainterface constructRtnData() {
        RowParams rParams = null;
        Param param = null;
        StringBuffer boardNameArray = new StringBuffer();
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            TEUsableResource res = (TEUsableResource)((Object)this.usableResourceList.get(i));
            boardNameArray.append(res.getSlotID()).append("-").append(res.getBoardName()).append(",");
        }
        rParams = new RowParams();
        param = new Param("boardNameArray", boardNameArray.toString());
        rParams.addParam(param);
        this.bParams.addRowParams(rParams);
        Collections.sort(this.usableResourceList, new Comparator<TEUsableResource>(){

            @Override
            public int compare(TEUsableResource t1, TEUsableResource t2) {
                int boarddiv = t1.getSlotID() - t2.getSlotID();
                int subbddiv = t1.getSubslotID() - t2.getSubslotID();
                if (boarddiv != 0) {
                    return boarddiv;
                }
                if (subbddiv != 0) {
                    return subbddiv;
                }
                return 0;
            }
        });
        HashSet<String> portSet = new HashSet<String>();
        HashSet<String> portNameSet = new HashSet<String>();
        int size2 = this.usableResourceList.size();
        for (int i = 0; i < size2; ++i) {
            Option option;
            int j;
            TEUsableResource res = (TEUsableResource)((Object)this.usableResourceList.get(i));
            rParams = new RowParams();
            param = null;
            param = new Param("slotid", new Integer(res.getSlotID()).toString());
            rParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("subslotid", new Integer(res.getSubslotID()).toString());
            rParams.addParam(param);
            param = new Param("subBoardName", res.getSubboardName());
            rParams.addParam(param);
            param = new Param("portid", (String)res.getPortidList().get(0));
            portSet.clear();
            int size1 = res.getPortidList().size();
            for (j = 1; j < size1; ++j) {
                String temPort = (String)res.getPortidList().get(j);
                if (portSet.contains(temPort)) continue;
                portSet.add(temPort);
                option = new Option(temPort);
                param.addOption(option);
            }
            rParams.addParam(param);
            param = res.getPortNameList().size() > 0 ? new Param("portName", (String)res.getPortNameList().get(0)) : new Param("portName", "");
            portNameSet.clear();
            size1 = res.getPortNameList().size();
            for (j = 1; j < size1; ++j) {
                String temPortName = (String)res.getPortNameList().get(j);
                if (portNameSet.contains(temPortName)) continue;
                portNameSet.add(temPortName);
                option = new Option(temPortName);
                param.addOption(option);
            }
            rParams.addParam(param);
            this.bParams.addRowParams(rParams);
        }
        this.datainterface.setBussinessParams(this.bParams);
        this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        return this.datainterface;
    }

    private ArrayList getPortList(int slotid, int boardType, Param param) {
        if (param != null) {
            return this.getPortListByType(slotid, param);
        }
        ArrayList portList = new ArrayList();
        if (boardType != 2102 && boardType != 2439) {
            portList.addAll(this.cfgPortMgr.getLogicPortList(this.neID, slotid, 1025));
            portList.addAll(this.cfgPortMgr.getLogicPortList(this.neID, slotid, 64001));
            portList.addAll(this.cfgPortMgr.getLogicPortList(this.neID, slotid, 1799));
            portList.addAll(this.cfgPortMgr.getLogicPortList(this.neID, slotid, 1802));
        } else if (boardType == 2102) {
            portList.addAll(this.cfgPortMgr.getLogicPortList(this.neID, slotid, 1799));
        } else if (boardType == 2439) {
            portList.addAll(this.cfgPortMgr.getLogicPortList(this.neID, slotid, 1799));
        }
        return portList;
    }

    private ArrayList getPortListByType(int slotid, Param param) {
        ArrayList portList = new ArrayList();
        String[] portTypes = param.getValue().split(",");
        for (int i = 0; i < portTypes.length; ++i) {
            try {
                int portType = Integer.parseInt(portTypes[i]);
                portList.addAll(this.cfgPortMgr.getLogicPortList(this.neID, slotid, portType));
                Collections.sort(portList);
                continue;
            }
            catch (NumberFormatException ex) {
                TELogFactory.getNormalLogger().error("Unkown Port type.", (Throwable)ex);
            }
        }
        return portList;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

