/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.diffserv;

import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TECreateDiffservBean
extends TENEExplorerBean {
    private static final String INVALID_SLOTID = "255";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        int len = businessparams.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = businessparams.getRowParams(i);
            String operateFlag = rowparams.getParam("operateFlag").getValue();
            if ("createMap".equals(operateFlag)) {
                this.getCreateMapOper(rowparams);
            }
            if ("modifyIngressMap".equals(operateFlag)) {
                this.getModifyIngressMapOper(rowparams);
            }
            if ("modifyEngressMap".equals(operateFlag)) {
                this.getModifyEngressMapOper(rowparams);
            }
            if (!"setPorts".equals(operateFlag)) continue;
            this.getSetPortsOper(rowparams);
        }
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void getCreateMapOper(RowParams rowparams) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_CRT_COSPRIMAP");
        Input input = oper.getInput();
        input.setPartValue("cosID", rowparams.getParam("cosID").getValue());
        input.setPartValue("cosName", rowparams.getParam("cosName").getValue());
        this.operationList.add(0, oper);
    }

    private void getModifyIngressMapOper(RowParams rowparams) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_SET_INCOSPRIMAP");
        Input input = oper.getInput();
        input.setPartValue("cosID", rowparams.getParam("cosID").getValue());
        input.setPartValue("cosMapType", rowparams.getParam("cosMapType").getValue());
        input.setPartValue("cos", rowparams.getParam("cos").getValue());
        input.setPartValue("encapsValue", rowparams.getParam("encapsValue").getValue());
        this.operationList.add(oper);
    }

    private void getModifyEngressMapOper(RowParams rowparams) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_SET_OUTCOSPRIMAP");
        Input input = oper.getInput();
        input.setPartValue("cosID", rowparams.getParam("cosID").getValue());
        input.setPartValue("cosMapType", rowparams.getParam("cosMapType").getValue());
        input.setPartValue("encapsValue", rowparams.getParam("encapsValue").getValue());
        input.setPartValue("cos", rowparams.getParam("cos").getValue());
        this.operationList.add(oper);
    }

    private void getSetPortsOper(RowParams rowparams) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_SET_APPLYCOSPRIMAP");
        Input input = oper.getInput();
        input.setPartValue("cosID", rowparams.getParam("cosID").getValue());
        input.setPartValue("slotid", rowparams.getParam("slotid").getValue());
        input.setPartValue("subBaordid", rowparams.getParam("subBaordid").getValue());
        input.setPartValue("port", rowparams.getParam("port").getValue());
        input.setPartValue("cosType", rowparams.getParam("cosType").getValue());
        this.operationList.add(oper);
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final Datainterface fInputData = inputData;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TECreateDiffservBean.this.getDetailStr(fInputData);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    public String getDetailStr(Datainterface inputData) {
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String DIFFSERV_RES = "ip" + File.separator + "ptn" + File.separator + "res" + File.separator + "diffserv" + File.separator + "diffserv_" + LANGUAGE + ".ini";
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)DIFFSERV_RES);
        StringBuffer operDesc = new StringBuffer();
        RowParams rowparams = null;
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String cos;
            String cosMapType;
            rowparams = inputData.getBussinessParams().getRowParams(i);
            String operateFlag = rowparams.getParam("operateFlag").getValue();
            if ("createMap".equals(operateFlag)) {
                operDesc.append(resourceUtil.getString("cosID")).append(":").append(rowparams.getParam("cosID").getValue()).append(",").append(resourceUtil.getString("cosName")).append(":").append(rowparams.getParam("cosName").getValue()).append(" ");
            }
            if ("modifyIngressMap".equals(operateFlag)) {
                cosMapType = rowparams.getParam("cosMapType").getValue();
                cos = rowparams.getParam("cos").getValue();
                operDesc.append(resourceUtil.getString("cosMapType")).append(":").append(resourceUtil.getString("cosMapType" + cosMapType)).append(",").append(resourceUtil.getString("encapsValue")).append(":").append(rowparams.getParam("encapsValue").getValue()).append(",").append(resourceUtil.getString("cos")).append(":").append(resourceUtil.getString("cos" + cos)).append(" ");
            }
            if ("modifyEngressMap".equals(operateFlag)) {
                cosMapType = rowparams.getParam("cosMapType").getValue();
                cos = rowparams.getParam("cos").getValue();
                operDesc.append(resourceUtil.getString("cosMapType")).append(":").append(resourceUtil.getString("cosMapType" + cosMapType)).append(",").append(resourceUtil.getString("cos")).append(":").append(resourceUtil.getString("cos" + cos)).append(",").append(resourceUtil.getString("encapsValue")).append(":").append(rowparams.getParam("encapsValue").getValue()).append(" ");
            }
            if (!"setPorts".equals(operateFlag)) continue;
            String slotid = rowparams.getParam("slotid").getValue();
            TEBoard board = configurDataMgr.getBoard(this.neid, Integer.parseInt(slotid));
            int boardType = -1;
            String boardName = "";
            if (null != board) {
                boardType = board.getBoardType();
                boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
            }
            String subBaordid = rowparams.getParam("subBaordid").getValue();
            String port = rowparams.getParam("port").getValue();
            if (INVALID_SLOTID.equals(subBaordid)) {
                String portName = configurDataMgr.getPortNameForPTN(this.neid, Integer.parseInt(slotid), boardType, Integer.parseInt(port));
                operDesc.append(slotid).append("-").append(boardName).append("-").append(portName).append(" ");
                continue;
            }
            int subBoardType = configurDataMgr.getSubboardType(this.neid, Integer.parseInt(slotid), Integer.parseInt(subBaordid));
            String subBoardName = configurDataMgr.getBoardTypeName(this.neid, subBoardType);
            String portName = configurDataMgr.getPortNameForPTN(this.neid, Integer.parseInt(slotid), subBoardType, Integer.parseInt(port));
            operDesc.append(slotid).append("-").append(boardName).append("-").append(subBaordid).append("-").append(subBoardName).append("-").append(portName).append(" ");
        }
        return operDesc.toString();
    }
}

