/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig.routeprotocol;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TECreateStaticRouteBean
extends TENEExplorerBean {
    private static final String INVALID_VALUE = "255";
    private static final String INVALID_BOARD = "65535";
    private static final int LENGTH_WITH_SUBBOARD = 4;
    private static final int SUBBOARDINDEX = 2;
    private static final int MlpppPort = 4096;
    private static final int SerialPort = 6144;
    private static final int VIRTUAL_PORT = 10240;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        BussinessParams businessparams = inputData.getBussinessParams();
        this.getCreateStaticRouteOper(businessparams);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void getCreateStaticRouteOper(BussinessParams bussinessparams) {
        RowParams rowparams = bussinessparams.getRowParams(0);
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_IP_ROUTE_ADD_STATICROUTE_EX");
        Input input = oper.getInput();
        input.setPartValue("routeID", rowparams.getParam("routeID").getValue());
        String boardInfo = rowparams.getParam("board").getValue();
        if ("ML-PPP".equals(boardInfo) || "Virtual Ethernet".equals(boardInfo)) {
            input.setPartValue("slotid", INVALID_BOARD);
            input.setPartValue("subslotid", INVALID_VALUE);
        } else {
            String[] board = boardInfo.split("-");
            input.setPartValue("slotid", board[0]);
            String subslotid = INVALID_VALUE;
            if (4 == board.length) {
                subslotid = board[2];
            }
            input.setPartValue("subslotid", subslotid);
        }
        input.setPartValue("port", rowparams.getParam("port").getValue());
        input.setPartValue("nextHop", this.convertIPAddress(rowparams.getParam("nextHop").getValue()));
        input.setPartValue("aimNode", this.convertIPAddress(rowparams.getParam("aimNode").getValue()));
        input.setPartValue("aimNodeCode", this.convertIPAddress(rowparams.getParam("aimNodeCode").getValue()));
        this.operationList.add(oper);
    }

    private String convertIPAddress(String str) {
        StringBuffer ipAddress = new StringBuffer();
        String[] ipAddressArry = str.replace('.', '-').split("-");
        int len = ipAddressArry.length;
        for (int i = 0; i < len; ++i) {
            ipAddressArry[i] = Integer.toHexString(Integer.parseInt(ipAddressArry[i]));
            if (2 > ipAddressArry[i].length()) {
                ipAddressArry[i] = "0" + ipAddressArry[i];
            }
            ipAddress.append(ipAddressArry[i]);
        }
        return ipAddress.toString();
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer operDesc = new StringBuffer();
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String CREATE_ROUTE_RES = "ip" + File.separator + "ptn" + File.separator + "res" + File.separator + "controlplaneconfig" + File.separator + "routeprotocol" + File.separator + "createstaticroute_" + LANGUAGE + ".ini";
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (String)CREATE_ROUTE_RES);
        operDesc.append(res.getString("routeID")).append(":").append(rowparams.getParam("routeID").getValue()).append(" ");
        operDesc.append(rowparams.getParam("board").getValue()).append("-");
        int portid = Integer.parseInt(rowparams.getParam("port").getValue());
        String portName = "";
        portName = 4096 <= portid && 6144 > portid ? "MLPPP-" + (portid - 4096) : (6144 <= portid && 10240 > portid ? portid - 6144 + "(Serial-Port-" + (portid - 6144) + ")" : (10240 <= portid ? "Virtual Interface-" + (portid - 10240) : portid + "(PORT-" + portid + ")"));
        operDesc.append(portName).append(" ");
        operDesc.append(res.getString("nextHop")).append(":").append(rowparams.getParam("nextHop").getValue()).append(" ").append(res.getString("aimNode")).append(":").append(rowparams.getParam("aimNode").getValue()).append(" ").append(res.getString("aimNodeCode")).append(":").append(rowparams.getParam("aimNodeCode").getValue()).append(" ");
        String value = operDesc.toString();
        return value;
    }
}

