/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig.ospfprotocol;

import com.huawei.nglct.cbb.log.TEMultiWriteLogCommonImpl;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;

public class TESetPortConfigBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String ISIS_PROTOCOL_RES = "ip" + File.separator + "ptn" + File.separator + "res" + File.separator + "controlplaneconfig" + File.separator + "ospfprotocol_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private static final int MLPPP = 4096;
    private static final int SERIALPORT = 6144;
    private static final int VIRTUALPORT = 10240;
    private static final String INVALID_SLOTID = "255";

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEMultiWriteLogCommonImpl(){

            public int getOperationResult(RowParams rowparams, RowParams errorRowParams) {
                return TESetPortConfigBean.this.getOperResult(rowparams, errorRowParams);
            }

            public String getOperationDescribtion(RowParams rowparams) {
                return TESetPortConfigBean.this.getDetailStr(rowparams);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    public String getDetailStr(RowParams rowparams) {
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)ISIS_PROTOCOL_RES);
        StringBuffer operDesc = new StringBuffer();
        Param param = null;
        operDesc.append(this.resourceUtil.getString("OSPFID")).append(":").append(rowparams.getParam("ospfID").getValue()).append(" ");
        int port = Integer.parseInt(rowparams.getParam("port").getValue());
        if (4096 <= port && 6144 > port) {
            operDesc.append(port - 4096).append("(MP-").append(port - 4096).append(")").append(" ");
        } else if (10240 <= port) {
            operDesc.append(port - 10240).append("(VEther-").append(port - 10240).append(")").append(" ");
        } else {
            String slotid = rowparams.getParam("slotid").getValue();
            int boardType = configurDataMgr.getBoard(this.neid, Integer.parseInt(slotid)).getBoardType();
            String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
            operDesc.append(slotid).append("-").append(boardName).append("-");
            String subBaordid = rowparams.getParam("subSlotid").getValue();
            String portName = "";
            if (INVALID_SLOTID.equals(subBaordid)) {
                portName = configurDataMgr.getPortName(this.neid, Integer.parseInt(slotid), boardType, port);
            } else {
                int subBoardType = configurDataMgr.getSubboardType(this.neid, Integer.parseInt(slotid), Integer.parseInt(subBaordid));
                String subBoardName = configurDataMgr.getBoardTypeName(this.neid, subBoardType);
                portName = configurDataMgr.getPortName(this.neid, Integer.parseInt(slotid), subBoardType, port);
                operDesc.append(subBaordid).append("-").append(subBoardName).append("-");
            }
            if (6144 <= port) {
                int serialPort = port - 6144;
                portName = serialPort + "(Serial-Port-" + serialPort + ")";
            }
            operDesc.append(portName).append(" ");
        }
        param = rowparams.getParam("portWeight");
        if (null != param) {
            operDesc.append(this.resourceUtil.getString("portWeight")).append(":").append(param.getValue()).append(" ");
        }
        if (null != (param = rowparams.getParam("helloTime"))) {
            operDesc.append(this.resourceUtil.getString("helloTime")).append(":").append(param.getValue()).append(" ");
        }
        if (null != (param = rowparams.getParam("mtu"))) {
            operDesc.append(this.resourceUtil.getString("mtu")).append(":").append(param.getValue()).append(" ");
        }
        if (null != (param = rowparams.getParam("cost"))) {
            operDesc.append("COST:").append(param.getValue()).append(" ");
        }
        return operDesc.toString();
    }
}

