/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig.ospfprotocol;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Vector;

public class TEQueryOSPFPortConfBean
extends TENEExplorerBean {
    private static final String INVALID_SLOTID = "65535";
    private static final String INVALID_SUBSLOTID = "255";
    private static final long PUBLIC_PROTOCOL_ID = 0xFFFFFFFFL;
    private static final int MLPPP_PORT = 4096;
    private static final int VETHNET_PORT = 10240;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.outputData = new Datainterface();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardlist = ne.getBoardList();
        Datainterface tmpInputData = new Datainterface();
        tmpInputData.setBussinessParams(new BussinessParams());
        String ospfID = this.getOspfID();
        if ("".equals(ospfID)) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        for (int i = 0; i < boardlist.size(); ++i) {
            RowParams onerow = new RowParams();
            onerow.addParam("neid", String.valueOf(neid));
            onerow.addParam("ospfID", ospfID);
            onerow.addParam("slotid", String.valueOf(((TEBoard)boardlist.get(i)).getSlotID()));
            onerow.addParam("subslotid", "0");
            onerow.addParam("port", "0");
            tmpInputData.getBussinessParams().addRowParams(onerow);
        }
        RowParams onerow = new RowParams();
        onerow.addParam("neid", String.valueOf(neid));
        onerow.addParam("ospfID", ospfID);
        onerow.addParam("slotid", INVALID_SLOTID);
        onerow.addParam("subslotid", INVALID_SUBSLOTID);
        onerow.addParam("port", "0");
        tmpInputData.getBussinessParams().addRowParams(onerow);
        this.operationList = this.getOperation(neid, subFunc, tmpInputData, memeryData);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_OSPF_GET_PORTCOST");
        this.operationList.add(oper);
        Input input = oper.getInput();
        input.getPart(0).setValue(ospfID);
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private String getOspfID() {
        String ospfID = "";
        ArrayList<Operation> ospfIDList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_OSPF_GET_OSPFINSTANCE");
        Input input = oper.getInput();
        input.setPartValue("ospfID", "0");
        ospfIDList.add(oper);
        int result = this.sendMessage(this.neid, ospfIDList);
        if (result != 0) {
            return "";
        }
        Operation tmpOper = (Operation)ospfIDList.get(0);
        Output[] outputArr = tmpOper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            long vpnID;
            boolean emptyFlag = false;
            Output output = outputArr[i];
            Fault[] faultArr = output.getFault();
            int len2 = faultArr.length;
            for (int j = 0; j < len2; ++j) {
                emptyFlag = false;
                Fault fault = faultArr[j];
                String code = fault.getCode();
                if (null != code && Integer.parseInt(code) == 0) continue;
                emptyFlag = true;
                break;
            }
            if (emptyFlag || (vpnID = Long.parseLong(output.getPartValue("vpnID"))) != 0xFFFFFFFFL) continue;
            ospfID = output.getPartValue("protocolID");
            break;
        }
        return ospfID;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList1 = new ArrayList<TELogInfo>();
            TELogInfo loginfo1 = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            RowParams rowparams1 = null;
            RowParams errorRowParams = null;
            int tmpErrorCode = 0;
            loginfo1 = new TELogInfo();
            rowparams1 = inputData.getBussinessParams().getRowParams(0);
            loginfo1.setOperateDesc(this.getDetailStr(rowparams1));
            if (errorCode != 0 && errorCode != 2 && errorCode != 1) {
                loginfo1.setResult(2);
                loginfo1.setErrCode(errorCode);
                loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else if (errorCode == 0) {
                loginfo1.setResult(0);
                loginfo1.setErrCode(errorCode);
                loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else if (errorCode == 1) {
                loginfo1.setResult(1);
                loginfo1.setErrCode(errorCode);
                loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else {
                int outputRowCount = outputData.getBussinessParams().getRowParamsCount();
                errorRowParams = outputData.getBussinessParams().getRowParams(outputRowCount - 1);
                tmpErrorCode = this.getOperResult(rowparams1, errorRowParams);
                if (tmpErrorCode != 0) {
                    loginfo1.setResult(2);
                } else {
                    loginfo1.setResult(0);
                }
                loginfo1.setErrCode(tmpErrorCode);
                loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)tmpErrorCode));
            }
            loginfoList1.add(loginfo1);
            int size = loginfoList1.size();
            for (int i = 0; i < size; ++i) {
                loginfo1 = (TELogInfo)loginfoList1.get(i);
                loginfo1.setCmdID(subfunc.getCode());
                loginfo1.setLocation(ipAddress);
                loginfo1.setUserID(userID);
                loginfo1.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo1.setOperateName(subfunc.getSubFuncDes(neid));
                loginfo1.setOperateObject(operObj);
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList1.get(i)));
            }
        }
        catch (Exception e1) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e1);
            return;
        }
    }

    public void handleMessage(int neid, ArrayList operList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operList);
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        operList.clear();
        ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME_EX");
        Input input = oper.getInput();
        input.setPartValue("slotid", INVALID_SLOTID);
        input.setPartValue("subslotid", INVALID_SUBSLOTID);
        input.setPartValue("port", "0");
        operList.add(oper);
        int resultTemp = this.sendMessage(neid);
        if (resultTemp != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultTemp));
            return;
        }
        Operation tmpOper = (Operation)operList.get(0);
        Output[] output = tmpOper.getOutput();
        for (Fault fault : output[0].getFault()) {
            int codeInt = Integer.parseInt(fault.getCode());
            if (codeInt == 0) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return;
        }
        String portname = null;
        int size = rowList.size();
        block1: for (int i = 0; i < size; ++i) {
            RowParams row = (RowParams)rowList.get(i);
            if (row.getParam("slotid") == null || !row.getParam("slotid").getValue().equals(INVALID_SLOTID) || row.getParam("subslotid") == null || !row.getParam("subslotid").getValue().equals(INVALID_SUBSLOTID)) continue;
            int len = output.length;
            for (int jIndex = 0; jIndex < len; ++jIndex) {
                int portId2;
                int portId = Integer.parseInt(row.getParam("port").getValue());
                if (portId != (portId2 = Integer.parseInt(output[jIndex].getPartValue("port")))) continue;
                portname = output[jIndex].getPartValue("portName").trim();
                if ("".equals(portname)) {
                    portname = portId >= 10240 ? portId - 10240 + "" : portId - 4096 + "";
                }
                row.getParam("portname").setValue(portname);
                continue block1;
            }
        }
    }
}

