/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig.isisprotocol;

import com.huawei.nglct.cbb.log.TEMultiWriteLogCommonImpl;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;

public class TESetPortConfigBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String ISIS_PROTOCOL_RES = "ip" + File.separator + "ptn" + File.separator + "res" + File.separator + "controlplaneconfig" + File.separator + "isisprotocol_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private static final int MLPPP = 4096;
    private static final int SERIALPORT = 6144;
    private static final int VIRTUALPORT = 10240;
    private static final String INVALID_SLOTID = "255";

    protected void modifyInputParams() {
        this.decryptParamForInputData(this.inputData, "authenticationCode");
    }

    private void decryptParamForInputData(Datainterface inputData, String paramName) {
        RowParams[] rowParamsArr;
        Param param = null;
        for (RowParams rowParams : rowParamsArr = inputData.getBussinessParams().getRowParams()) {
            param = rowParams.getParam(paramName);
            if (null == param) continue;
            byte[] value = EncryptUtils.decrypt((String)param.getValue());
            param.setValue(EncryptUtils.encryptAESByte2Str((byte[])value));
            EncryptUtils.clearByte((byte[])value);
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEMultiWriteLogCommonImpl(){

            public int getOperationResult(RowParams rowparams, RowParams errorRowParams) {
                return TESetPortConfigBean.this.getOperResult(rowparams, errorRowParams);
            }

            public String getOperationDescribtion(RowParams rowparams) {
                return TESetPortConfigBean.this.getDetailStr(rowparams);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    public String getDetailStr(RowParams rowparams) {
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)ISIS_PROTOCOL_RES);
        StringBuffer operDesc = new StringBuffer();
        operDesc.append(this.resourceUtil.getString("isisID")).append(":").append(rowparams.getParam("isisID").getValue()).append(" ");
        int port = Integer.parseInt(rowparams.getParam("port").getValue());
        if (4096 <= port && 6144 > port) {
            operDesc.append(port - 4096).append("(MP-").append(port - 4096).append(")").append(" ");
        } else if (10240 <= port) {
            operDesc.append(port - 10240).append("(VEther-").append(port - 10240).append(")").append(" ");
        } else {
            String slotid = rowparams.getParam("slotid").getValue();
            int boardType = configurDataMgr.getBoard(this.neid, Integer.parseInt(slotid)).getBoardType();
            String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
            operDesc.append(slotid).append("-").append(boardName).append("-");
            String subBaordid = rowparams.getParam("subSlotid").getValue();
            String portName = "";
            if (INVALID_SLOTID.equals(subBaordid)) {
                portName = configurDataMgr.getPortNameForPTN(this.neid, Integer.parseInt(slotid), boardType, port);
            } else {
                int subBoardType = configurDataMgr.getSubboardType(this.neid, Integer.parseInt(slotid), Integer.parseInt(subBaordid));
                String subBoardName = configurDataMgr.getBoardTypeName(this.neid, subBoardType);
                portName = configurDataMgr.getPortNameForPTN(this.neid, Integer.parseInt(slotid), subBoardType, port);
                operDesc.append(subBaordid).append("-").append(subBoardName).append("-");
            }
            if (6144 <= port) {
                int serialPort = port - 6144;
                portName = serialPort + "(Serial-Port-" + serialPort + ")";
            }
            operDesc.append(portName).append(" ");
        }
        operDesc.append(this.getDetailDesc(rowparams));
        return operDesc.toString();
    }

    private String getDetailDesc(RowParams rowparams) {
        String name = null;
        String value = null;
        String str = null;
        Param param = null;
        StringBuilder operDesc = new StringBuilder();
        int len = rowparams.getParamCount();
        for (int i = 0; i < len; ++i) {
            param = rowparams.getParam(i);
            value = param.getValue();
            name = param.getName();
            if ("isisEnable".equals(name)) {
                str = this.resourceUtil.getString(name + value);
            } else if ("linkLevel".equals(name) || "linkLevelSet".equals(name)) {
                str = this.resourceUtil.getString("nodeLevel" + value);
            } else if ("authenticationMode".equals(name)) {
                str = this.resourceUtil.getString("authenticationMode" + value);
            } else if ("authenticationType".equals(name)) {
                str = this.resourceUtil.getString("authenticationType" + value);
            } else {
                if (!"authenticationCode".equals(name)) continue;
                value = null;
                continue;
            }
            operDesc.append(this.resourceUtil.getString(name)).append(":").append(str).append(" ");
        }
        return operDesc.toString();
    }
}

