/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig.isisprotocol;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Vector;

public class TEQueryIsisPortConfBean
extends TENEExplorerBean {
    private static final String INVALID_SLOTID = "65535";
    private static final String INVALID_SUBSLOTID = "255";
    private static final String EMPTY_RESULT = "38662";
    private static final int MLPPP_PORT = 4096;
    private static final int VETHNET_PORT = 10240;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int i;
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardlist = ne.getBoardList();
        inputData.getBussinessParams().clearRowParams();
        ArrayList<String> vportList = new ArrayList<String>();
        this.operationList = new ArrayList();
        this.operationList.clear();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_MLPPP_GET_MP");
        Input input = oper.getInput();
        input.setPartValue("groupno", "0");
        this.operationList.add(oper);
        int result2 = this.sendMessage(neid);
        if (result2 != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result2));
            TELogFactory.getNormalLogger().error("get MP or VPORT error:\n");
        }
        for (i = 0; i < this.operationList.size(); ++i) {
            Operation operation = (Operation)this.operationList.get(i);
            Output[] outputArr = operation.getOutput();
            String cmdName = operation.getName();
            for (Output output : outputArr) {
                int retCode = Integer.valueOf(output.getFault()[0].getCode());
                if (retCode != 0 || !"NSCMD_ETHN_MLPPP_GET_MP".equals(cmdName)) continue;
                String mpid = output.getPartValue("groupno");
                vportList.add(mpid);
            }
        }
        for (i = 0; i < boardlist.size(); ++i) {
            RowParams onerow = new RowParams();
            onerow.addParam("neid", new Integer(neid).toString());
            onerow.addParam("isisID", "0");
            onerow.addParam("slotid", new Integer(((TEBoard)boardlist.get(i)).getSlotID()).toString());
            onerow.addParam("subslotid", "0");
            onerow.addParam("port", "0");
            inputData.getBussinessParams().addRowParams(onerow);
        }
        RowParams onerow = new RowParams();
        onerow.addParam("neid", new Integer(neid).toString());
        onerow.addParam("isisID", "0");
        onerow.addParam("slotid", INVALID_SLOTID);
        onerow.addParam("subslotid", INVALID_SUBSLOTID);
        onerow.addParam("port", "0");
        inputData.getBussinessParams().addRowParams(onerow);
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData2) {
        boolean sussFlag = true;
        BussinessParams bussinessParams = outputData2.getBussinessParams();
        if (null != bussinessParams) {
            RowParams[] rowParams1 = outputData2.getBussinessParams().getRowParams();
            int len = rowParams1.length;
            for (int i = 0; i < len; ++i) {
                RowErrors[] rowErrors = rowParams1[i].getRowErrors();
                int lenError = rowErrors.length;
                for (int j = 0; j < lenError; ++j) {
                    if (EMPTY_RESULT.equals(rowErrors[j].getErrorMessage().getErrorcode())) {
                        rowParams1[i].removeRowErrors(rowErrors[j]);
                        continue;
                    }
                    sussFlag = false;
                }
            }
            if (sussFlag) {
                outputData2.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
        }
        try {
            int errorCode = Integer.parseInt(outputData2.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo2 = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            RowParams rowparams = null;
            RowParams errorRowParams = null;
            int tmpErrorCode = 0;
            loginfo2 = new TELogInfo();
            rowparams = inputData.getBussinessParams().getRowParams(0);
            loginfo2.setOperateDesc(this.getDetailStr(rowparams));
            if (errorCode != 0 && errorCode != 2 && errorCode != 1) {
                loginfo2.setResult(2);
                loginfo2.setErrCode(errorCode);
                loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else if (errorCode == 0) {
                loginfo2.setResult(0);
                loginfo2.setErrCode(errorCode);
                loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else {
                int outputRowCount = outputData2.getBussinessParams().getRowParamsCount();
                errorRowParams = outputData2.getBussinessParams().getRowParams(outputRowCount - 1);
                tmpErrorCode = this.getOperResult(rowparams, errorRowParams);
                if (tmpErrorCode != 0) {
                    loginfo2.setResult(2);
                } else {
                    loginfo2.setResult(0);
                }
                loginfo2.setErrCode(tmpErrorCode);
                loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)tmpErrorCode));
            }
            loginfoList.add(loginfo2);
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                loginfo2 = (TELogInfo)loginfoList.get(i);
                loginfo2.setCmdID(subfunc.getCode());
                loginfo2.setLocation(ipAddress);
                loginfo2.setUserID(userID);
                loginfo2.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo2.setOperateName(subfunc.getSubFuncDes(neid));
                loginfo2.setOperateObject(operObj);
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        operationList.clear();
        ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME_EX");
        Input input = oper.getInput();
        input.setPartValue("slotid", INVALID_SLOTID);
        input.setPartValue("subslotid", INVALID_SUBSLOTID);
        input.setPartValue("port", "0");
        operationList.add(oper);
        int result = this.sendMessage(neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return;
        }
        Operation tmpOper = (Operation)operationList.get(0);
        Output[] output = tmpOper.getOutput();
        for (Fault fault : output[0].getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return;
        }
        String portname = null;
        int size = rowList.size();
        block1: for (int i = 0; i < size; ++i) {
            RowParams row = (RowParams)rowList.get(i);
            if (row.getParam("slotid") == null || !row.getParam("slotid").getValue().equals(INVALID_SLOTID) || row.getParam("subslotid") == null || !row.getParam("subslotid").getValue().equals(INVALID_SUBSLOTID)) continue;
            int len = output.length;
            for (int j = 0; j < len; ++j) {
                int portId2;
                int portId = Integer.parseInt(row.getParam("port").getValue());
                if (portId != (portId2 = Integer.parseInt(output[j].getPartValue("port")))) continue;
                portname = output[j].getPartValue("portName").trim();
                if (portname.equals("")) {
                    portname = portId >= 10240 ? portId - 10240 + "" : portId - 4096 + "";
                }
                row.getParam("portname").setValue(portname);
                continue block1;
            }
        }
    }
}

