/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig.arpagetime;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TEQueryArpAgeTime
extends TENEExplorerBean {
    private static final String IPPTN_ATTR_ARPAGE = "IPPTN_ATTR_ARPAGE";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        List boardList = TEGenCfgCommon.getAttrSupportCPs((int)neid, (String)IPPTN_ATTR_ARPAGE);
        Collections.sort(boardList);
        for (TEBoard board : boardList) {
            this.addRow(inputData, String.valueOf(board.getSlotID()), board.getBoardType());
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    private void addRow(Datainterface inputData, String slotid, int boardType) {
        RowParams row = new RowParams();
        Param param = new Param("slotid", slotid);
        row.addParam(param);
        if (TEConfigurationDataMgr.getInstance().isSupportSubCard(boardType)) {
            param = new Param("subcard", "0");
            row.addParam(param);
        }
        param = new Param("port", "0");
        row.addParam(param);
        param = new Param("isNoLog", "1");
        row.addParam(param);
        inputData.getBussinessParams().addRowParams(row);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codes = new ArrayList<Integer>();
        codes.add(38662);
        return codes;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        for (int i = rows.length - 1; i >= 0; --i) {
            int subslotid;
            if (rows[i].getParam("portname") == null) continue;
            int slotid = Integer.valueOf(rows[i].getParam("slotid").getValue());
            int boardtype = Integer.valueOf(rows[i].getParam("boardtype").getValue());
            int port = Integer.valueOf(rows[i].getParam("port").getValue());
            Param param = rows[i].getParam("subcard");
            if (null != param && null != param.getValue() && (subslotid = Integer.parseInt(rows[i].getParam("subcard").getValue())) != 255 && subslotid != 0) {
                boardtype = TEConfigurationDataMgr.getInstance().getSubboardType(neid, slotid, subslotid);
                rows[i].addParam("subcardname", TEConfigurationDataMgr.getInstance().getSubBoardName(neid, slotid, subslotid));
            }
            String portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, boardtype, port, 16);
            rows[i].getParam("portname").setValue(portname);
        }
    }
}

