/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig.arp;

import com.huawei.nglct.cbb.datamanage.integration.handler.TECIUpLoadHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECfgItem;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgNEInfo;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgUploadPara;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig.arp.TEArpDBMgr;
import com.huawei.nglct.po.embeddednemgrmo.arp.TEArpMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import org.slf4j.Logger;

public class TEArpUploadHandler
implements TECIUpLoadHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final String TENEEXPLORERBEAN_CLASSNAME = "com.huawei.nglct.explorer.TENEExplorerBean";
    TEDataCfgNEInfo neInfo = null;

    public int getItemID() {
        return 0;
    }

    public String getItemName() {
        return null;
    }

    public TECfgItem getOperIF(int OperType) {
        return null;
    }

    private boolean isNEExist(int neID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        return null != ne;
    }

    public int upLoad(TEDataCfgUploadPara pArpPara) {
        this.neInfo = pArpPara.getTmpNEInfo();
        int neID = this.neInfo.getNeID();
        if (!this.isNEExist(neID)) {
            e2eLogger.info("temp ne is not exist");
            neID = pArpPara.getOldNEID();
            if (!this.isNEExist(neID)) {
                e2eLogger.info("old ne is not exist");
                return 0;
            }
        }
        return this.uploadImpl(neID);
    }

    public int uploadImpl(int neID) {
        String FUNC_NAME_ARP = "TEArpUploadHandler.uploadImpl";
        e2eLogger.info("TEArpUploadHandler.uploadImpl: begin.");
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != retCode) {
            TEArpUploadHandler.logConnectNEFail(neID, retCode);
            e2eLogger.info("TEArpUploadHandler.uploadImpl: end.");
            return retCode;
        }
        Datainterface outputArp = this.getDataFromNe(neID);
        if (outputArp.getErrorMessage().getErrorcode().equals("0")) {
            RowParams[] rows;
            TEErrInfoReturn errRet = new TEErrInfoReturn();
            TEArpDBMgr.delAllArpsFromDB(neID, errRet);
            for (RowParams row : rows = outputArp.getBussinessParams().getRowParams()) {
                String arpIP = row.getParam("arpip").getValue();
                String arpMAC = row.getParam("arpmac").getValue();
                TEArpMOPO arpMO = new TEArpMOPO();
                arpMO.setArpIP(arpIP);
                arpMO.setArpMAC(arpMAC);
                TEArpDBMgr.createArpToDB(neID, arpMO, errRet);
            }
        }
        e2eLogger.info("TEArpUploadHandler.uploadImpl: end.");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Datainterface getDataFromNe(int neID) {
        Datainterface datainterface = new Datainterface();
        BussinessParams bussParams = new BussinessParams();
        datainterface.setBussinessParams(bussParams);
        RowParams rowParams = new RowParams();
        bussParams.addRowParams(rowParams);
        Param pArp = new Param("neid", String.valueOf(neID));
        rowParams.addParam(pArp);
        int sfid = 2167969;
        SubFunc subFuncArp = null;
        int neType = this.neInfo.getNeType();
        String neVersion = this.neInfo.getNeVersion();
        try {
            subFuncArp = TECreateObjectFactory.getSubFuncByVer((int)neID, (int)sfid, (int)neType, (String)neVersion);
        }
        catch (Exception e1) {
            TELogFactory.getNormalLogger().error(e1.getMessage());
        }
        if (null == subFuncArp) {
            TELogFactory.getNormalLogger().info("Not Find Query Lmsp subFunc!");
            return null;
        }
        Datainterface allData = null;
        String classMapping = subFuncArp.getClassMapping();
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = classMapping == null ? (TENEMgrInterface)Class.forName(TENEEXPLORERBEAN_CLASSNAME).newInstance() : (TENEMgrInterface)Class.forName(classMapping).newInstance();
        }
        catch (Exception ex) {
            e2eLogger.error("The Upload ARP from weblct exception " + neID, (Throwable)ex);
        }
        finally {
            if (null != neMgrBean) {
                allData = neMgrBean.performBussinessProcess(neID, subFuncArp, datainterface, null, null, null);
            }
        }
        return allData;
    }

    private static void logConnectNEFail(int neID, int retCode) {
        String tipStr = "upload arp fail! ";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        e2eLogger.error(tipStr);
    }
}

