/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig.arp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.arp.TEArpMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEArpDBMgr {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    private TEArpDBMgr() {
    }

    public static List<TEArpMOPO> getArpsFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEArpDBMgr.getClockDeviceFromDB";
        normalLogger.info("TEArpDBMgr.getClockDeviceFromDB: begin.");
        ArrayList<TEArpMOPO> arpList = new ArrayList<TEArpMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEArpDBMgr.logNullNEError(neID);
                TEArpDBMgr.setOperFail(neID, errRet, 1090596385);
                TEArpDBMgr.logFuncEnd("TEArpDBMgr.getClockDeviceFromDB");
                return arpList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEArpMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEArpMOPO.class);
        }
        catch (Exception e) {
            normalLogger.error("get arp from db fail! neID->" + neID, (Throwable)e);
            TEArpDBMgr.setOperFail(neID, errRet, 1092743443);
            TEArpDBMgr.logFuncEnd("TEArpDBMgr.getClockDeviceFromDB");
            return arpList;
        }
        if (null == dbResult) {
            normalLogger.error("get clock device from db fail! dbResult is null! neID->" + neID);
            TEArpDBMgr.setOperFail(neID, errRet, 1092743443);
            TEArpDBMgr.logFuncEnd("TEArpDBMgr.getClockDeviceFromDB");
            return arpList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    arpList.add((TEArpMOPO)obj);
                }
            }
        } else {
            TEArpDBMgr.logRetCodeErrorOnGet(neID, retCode);
            TEArpDBMgr.setOperFail(neID, errRet, retCode);
        }
        TEArpDBMgr.logFuncEnd("TEArpDBMgr.getClockDeviceFromDB");
        return arpList;
    }

    public static void delArpFromDB(int neID, TEArpMOPO arpMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEArpDBMgr.delArpFromDB";
        normalLogger.info("TEArpDBMgr.delArpFromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)arpMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)arpMO);
        }
        catch (Exception e) {
            normalLogger.error("delete arp from db fail! neID->" + neID, (Throwable)e);
            TEArpDBMgr.setOperFail(neID, errRet, 1092743443);
            TEArpDBMgr.logFuncEnd("TEArpDBMgr.delArpFromDB");
            return;
        }
        if (null == dbResult) {
            TEArpDBMgr.logNullError(neID);
            TEArpDBMgr.setOperFail(neID, errRet, 1092743443);
            TEArpDBMgr.logFuncEnd("TEArpDBMgr.delArpFromDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEArpDBMgr.logRetCodeError(neID, retCode);
            TEArpDBMgr.setOperFail(neID, errRet, retCode);
        }
        TEArpDBMgr.logFuncEnd("TEArpDBMgr.delArpFromDB");
    }

    public static void delAllArpsFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEArpDBMgr.delAllArpsFromDB";
        normalLogger.info("TEArpDBMgr.delAllArpsFromDB: begin.");
        List<TEArpMOPO> arpList = TEArpDBMgr.getArpsFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TEArpDBMgr.logRetCodeError(neID, retCode);
            TEArpDBMgr.setOperFail(neID, errRet, retCode);
        }
        for (TEArpMOPO arp : arpList) {
            TEArpDBMgr.delArpFromDB(neID, arp, errRet);
        }
        TEArpDBMgr.logFuncEnd("TEArpDBMgr.delAllArpsFromDB");
    }

    public static void createArpToDB(int neID, TEArpMOPO arpMO, TEErrInfoReturn errRetArp) {
        String FUNC_NAME = "TEArpDBMgr.createArpToDB";
        normalLogger.info("TEArpDBMgr.createArpToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)arpMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)arpMO);
        }
        catch (Exception ex) {
            TEArpDBMgr.logExceptionErrorOnCreate(neID, ex);
            TEArpDBMgr.setOperFail(neID, errRetArp, 1092743443);
            TEArpDBMgr.logFuncEnd("TEArpDBMgr.createArpToDB");
            return;
        }
        if (null == dbResult) {
            TEArpDBMgr.logNullError(neID);
            TEArpDBMgr.setOperFail(neID, errRetArp, 1092743443);
            TEArpDBMgr.logFuncEnd("TEArpDBMgr.createArpToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEArpDBMgr.logRetCodeError(neID, retCode);
            TEArpDBMgr.setOperFail(neID, errRetArp, retCode);
        }
        TEArpDBMgr.logFuncEnd("TEArpDBMgr.createArpToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn arpRspErrRet, int retCodeArp) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        arpRspErrRet.setResult(1090605056);
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(new int[]{neID});
        errInfo.setObjName(neName);
        errInfo.setErrorCode(retCodeArp);
        errRet.addErrInfo(errInfo);
    }

    private static void logNullError(int neID) {
        normalLogger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        normalLogger.error("create  fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeError(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    private static void logFuncEnd(String funcName) {
        normalLogger.info(funcName + ": end.");
    }

    private static void logNullNEError(int neID) {
        normalLogger.error("ne is null! neID->" + neID);
    }
}

