/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.circuitpack.TESDContianMOCount;
import com.huawei.nglct.nemgr.ip.ptn.controlplaneconfig.TEUsableResource;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEGetAvailablePortsBean
extends TENEExplorerBean {
    private List<TEUsableResource> usableResourceList = new ArrayList<TEUsableResource>();
    private static final int INVALID_SLOT = 65535;
    private static final int INVALID_SUBSLOT = 255;
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.outputData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardVec = ne.getBoardList();
        Collections.sort(boardVec);
        int slotID = -1;
        int cpType = -1;
        int portID = -1;
        String bdName = null;
        TEBoard board = null;
        TEPort port = null;
        List portList = null;
        TIntArrayList portIDList = null;
        ArrayList<String> portNameList = null;
        TIntArrayList serialSlotList = new TIntArrayList();
        int m = boardVec.size();
        for (int i = 0; i < m; ++i) {
            TEUsableResource usableRes;
            board = (TEBoard)boardVec.get(i);
            slotID = board.getSlotID();
            cpType = board.getBoardType();
            bdName = this.cfgDataMgr.getBoardTypeName(neid, cpType);
            if (this.isSupportSerialPort(cpType)) {
                serialSlotList.add(slotID);
            }
            portIDList = new TIntArrayList();
            portNameList = new ArrayList<String>();
            portList = this.getPortList(slotID, cpType);
            int n = portList.size();
            for (int j = 0; j < n; ++j) {
                port = (TEPort)portList.get(j);
                portID = port.getPortNo();
                if (portIDList.contains(portID)) continue;
                portIDList.insert(j, portID);
                portNameList.add(j, this.cfgDataMgr.getPortNameForPTN(neid, slotID, cpType, portID));
            }
            if (portIDList.size() <= 0 || this.usableResourceList.contains(usableRes = new TEUsableResource(slotID, 255, bdName, portIDList, portNameList))) continue;
            this.usableResourceList.add(usableRes);
        }
        this.getSerialPorts(serialSlotList);
        this.getMLPPPs();
        this.getVPorts();
        this.getPortName();
        this.constructData();
        return this.outputData;
    }

    private List getPortList(int slotid, int boardType) {
        List portList = this.cfgDataMgr.getPortList(this.neid, slotid, 1797);
        portList.addAll(this.cfgDataMgr.getPortList(this.neid, slotid, 1802));
        portList.addAll(this.cfgDataMgr.getPortList(this.neid, slotid, 1799));
        return portList;
    }

    private boolean isSupportSerialPort(int cpType) {
        TESDContianMOCount moCount = null;
        ArrayList moCountList = TECircuitPackDescription.getInstance().getCPContainMO(cpType);
        int m = moCountList.size();
        for (int i = 0; i < m; ++i) {
            moCount = (TESDContianMOCount)moCountList.get(i);
            if (!"TEPTNSerialGroupContainer".equalsIgnoreCase(moCount.moName)) continue;
            return true;
        }
        return false;
    }

    private void getSerialPorts(TIntArrayList slotList) {
        int errCode;
        this.operationList = new ArrayList();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_PORT_GET_SERIALPORT");
        Input input = oper.getInput();
        input.setPartValue("port", "0");
        Operation oper_vc12 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_PORT_GET_SERIALPORT_VC12");
        Input input_vc12 = oper_vc12.getInput();
        input_vc12.setPartValue("serialport", "0");
        int slotID = -1;
        int m = slotList.size();
        for (int i = 0; i < m; ++i) {
            slotID = slotList.get(i);
            input.setPartValue("slotid", String.valueOf(slotID));
            this.operationList.add(oper.clone());
            input_vc12.setPartValue("slotid", String.valueOf(slotID));
            this.operationList.add(oper_vc12.clone());
        }
        if (this.operationList.size() > 0 && 0 == (errCode = this.sendMessage(this.neid, this.operationList))) {
            int slotId = -1;
            int cpType = -1;
            int portId = -1;
            Output output = null;
            int n = this.operationList.size();
            for (int j = 0; j < n; ++j) {
                oper = (Operation)this.operationList.get(j);
                errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                if (0 != errCode) continue;
                int mn = oper.getOutputCount();
                for (int k = 0; k < mn; ++k) {
                    output = oper.getOutput(k);
                    slotId = Integer.valueOf(output.getPartValue("slotid"));
                    portId = Integer.valueOf(output.getPartValue("port"));
                    cpType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                    this.addUsableResource(slotId, this.cfgDataMgr.getBoardTypeName(this.neid, cpType), portId, this.cfgDataMgr.getPortNameForPTN(this.neid, slotId, cpType, portId));
                }
            }
        }
    }

    private void getMLPPPs() {
        this.operationList.clear();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_MLPPP_GET_MP");
        this.operationList.add(oper);
        int errCode = this.sendMessage(this.neid, this.operationList);
        if (0 == errCode) {
            int portId = -1;
            Output output = null;
            int m = this.operationList.size();
            for (int i = 0; i < m; ++i) {
                oper = (Operation)this.operationList.get(i);
                errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                if (0 != errCode) continue;
                int n = oper.getOutputCount();
                for (int j = 0; j < n; ++j) {
                    output = oper.getOutput(j);
                    portId = Integer.valueOf(output.getPartValue("groupno"));
                    this.addUsableResource(65535, "UNKNOWN", portId, this.cfgDataMgr.getPortNameForPTN(this.neid, 65535, -1, portId));
                }
            }
        }
    }

    private void getVPorts() {
        this.operationList.clear();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_PORT_GET_VPORT");
        this.operationList.add(oper);
        int errCode = this.sendMessage(this.neid, this.operationList);
        if (0 == errCode) {
            int slotId = -1;
            int cpType = -1;
            int portId = -1;
            Output output = null;
            int m = this.operationList.size();
            for (int i = 0; i < m; ++i) {
                oper = (Operation)this.operationList.get(i);
                errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                if (0 != errCode) continue;
                int n = oper.getOutputCount();
                for (int j = 0; j < n; ++j) {
                    output = oper.getOutput(j);
                    slotId = Integer.valueOf(output.getPartValue("slotid"));
                    portId = Integer.valueOf(output.getPartValue("port"));
                    cpType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                    this.addUsableResource(slotId, "UNKNOWN", portId, this.cfgDataMgr.getPortNameForPTN(this.neid, slotId, cpType, portId));
                }
            }
        }
    }

    private void addUsableResource(int slotId, String boardName, int portId, String portName) {
        TEUsableResource res = null;
        boolean isExist = false;
        int m = this.usableResourceList.size();
        for (int i = 0; i < m; ++i) {
            isExist = false;
            res = this.usableResourceList.get(i);
            if (res.slotID != slotId) continue;
            if (!res.portIDList.contains(portId)) {
                res.portIDList.add(portId);
                res.portNameList.add(portName);
            }
            isExist = true;
            break;
        }
        if (!isExist) {
            TIntArrayList portIDList = new TIntArrayList();
            portIDList.add(portId);
            ArrayList<String> portNameList = new ArrayList<String>();
            portNameList.add(portName);
            res = new TEUsableResource(slotId, boardName, portIDList, portNameList);
            this.usableResourceList.add(res);
        }
    }

    private void getPortName() {
        this.operationList.clear();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
        Input input = oper.getInput();
        input.setPartValue("slotid", String.valueOf(65535));
        input.setPartValue("subslotid", String.valueOf(255));
        input.setPartValue("port", "0");
        this.operationList.add(oper);
        int errCode = this.sendMessage(this.neid, this.operationList);
        if (0 == errCode) {
            int slotId = -1;
            int subslotId = -1;
            int portId = -1;
            String portName = null;
            Output output = null;
            int m = this.operationList.size();
            for (int i = 0; i < m; ++i) {
                oper = (Operation)this.operationList.get(i);
                errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                if (0 != errCode) continue;
                int n = oper.getOutputCount();
                for (int j = 0; j < n; ++j) {
                    output = oper.getOutput(j);
                    slotId = Integer.valueOf(output.getPartValue("slotid"));
                    subslotId = Integer.valueOf(output.getPartValue("subslotid"));
                    portId = Integer.valueOf(output.getPartValue("port"));
                    portName = IOStreamConvertor.replaceSpecialStr((String)output.getPartValue("PTNIF_PORT_ATTR_PORTNAME"));
                    this.setPortName(slotId, subslotId, portId, portName);
                }
            }
        }
    }

    private void setPortName(int slotId, int subslotId, int portId, String portName) {
        if (!"".equals(portName.trim())) {
            String tmpName = null;
            TEUsableResource res = null;
            int m = this.usableResourceList.size();
            block0: for (int i = 0; i < m; ++i) {
                res = this.usableResourceList.get(i);
                if (res.slotID != slotId) continue;
                res.subslotID = subslotId;
                int n = res.portIDList.size();
                for (int j = 0; j < n; ++j) {
                    if (res.portIDList.get(j) != portId) continue;
                    tmpName = res.portNameList.get(j);
                    tmpName = tmpName.substring(0, tmpName.indexOf("-") + 1) + "-" + portName + ")";
                    res.portNameList.remove(j);
                    res.portNameList.add(j, tmpName);
                    continue block0;
                }
            }
        }
    }

    private void constructData() {
        TEUsableResource res = null;
        RowParams rowParams = null;
        Param param = null;
        Option option = null;
        int m = this.usableResourceList.size();
        for (int i = 0; i < m; ++i) {
            res = this.usableResourceList.get(i);
            rowParams = new RowParams();
            param = new Param("slotid", String.valueOf(res.slotID));
            rowParams.addParam(param);
            param = new Param("subslotid", String.valueOf(-1 == res.subslotID ? 255 : res.subslotID));
            rowParams.addParam(param);
            param = new Param("boardName", res.boardName);
            rowParams.addParam(param);
            param = new Param("portid", String.valueOf(res.portIDList.get(0)));
            int n = res.portIDList.size();
            for (int j = 1; j < n; ++j) {
                option = new Option(String.valueOf(res.portIDList.get(j)));
                param.addOption(option);
            }
            rowParams.addParam(param);
            param = new Param("portName", res.portNameList.get(0));
            int mn = res.portNameList.size();
            for (int k = 1; k < mn; ++k) {
                option = new Option(res.portNameList.get(k));
                param.addOption(option);
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }
}

