/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.bittest;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;

public class TEQueryPTNBitTestBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "sdh" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "bittest" + File.separator + "bittestres_" + LANGUAGE + ".ini";

    public String getDetailStr(RowParams rowparams) {
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)STRING_SOURCE);
        StringBuffer operDesc = new StringBuffer();
        RowParams rowpara = this.inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        int slotid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("subslotid");
        int subslotid = 255;
        if (para != null) {
            subslotid = Integer.parseInt(para.getValue());
        }
        para = rowpara.getParam("portid");
        int portid = Integer.parseInt(para.getValue());
        operDesc.append(resourceUtil.getString("slot")).append(":").append(slotid).append(",").append(resourceUtil.getString("subslot")).append(":").append(subslotid).append(",").append(resourceUtil.getString("port")).append(":").append(portid);
        return operDesc.toString();
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        Output output = null;
        TEBitTestData testdata = null;
        int len = outputArr.length;
        for (int j = 0; j < len; ++j) {
            output = outputArr[j];
            int retCode = Integer.parseInt(output.getFault()[0].getCode());
            if (retCode == 38662) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                return;
            }
            if (retCode != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)retCode));
                return;
            }
            if (j == 0) {
                int slotid = Integer.parseInt(output.getPart("slotid").getValue());
                int subslotid = Integer.parseInt(output.getPart("subslotid").getValue());
                int portid = Integer.parseInt(output.getPart("portid").getValue());
                String portName = TEBitTestUtility.getPortName(neid, slotid, portid);
                testdata = TEBitTestCache.getInstance().getCahce(portName);
                if (testdata != null) {
                    testdata.init();
                } else {
                    testdata = new TEBitTestData();
                    testdata.setSlotid(slotid);
                    testdata.setSubSlotid(subslotid);
                    testdata.setPortid(portid);
                    TEBitTestCache.getInstance().addCahce(portName, testdata);
                }
                Calendar startTime = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).byteStrToCalendar(output.getPart("starttime").getValue());
                testdata.setStartTime(startTime.getTime().getTime());
                int testtime = Integer.parseInt(output.getPart("testtime").getValue());
                testdata.setTesttime(testtime);
                int timeunit = Integer.parseInt(output.getPart("timeunit").getValue());
                testdata.setTimeUnit(timeunit);
                portName = TEBitTestUtility.getPortName(neid, slotid, portid);
            }
            int firstpoint = Integer.parseInt(output.getPart("firstpoint").getValue());
            String value = output.getPart("errdata").getValue();
            int num = value.length() / 8;
            int index = 0;
            for (int i = 0; i < num; ++i) {
                int errnum = new BigInteger(value.substring(index, index + 8), 16).intValue();
                index += 8;
                if (errnum <= 0) {
                    errnum = 0;
                }
                testdata.addQueryResult(errnum, firstpoint);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }
}

