/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.bittest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestUtility;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;

public class TEQueryNormalBitTestBean
extends TENEExplorerBean {
    private static final String BASE_PATH = "sdh" + File.separator + "res" + File.separator;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = BASE_PATH + "bittest" + File.separator + "bittestres_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        String temp = this.getOperaStr();
        TEOperationLogUtility.setOperaStr((String)temp);
        TEOperationLogUtility.writeLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        String desStr = "";
        RowParams rowpara = this.inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        int slotid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("portid");
        int portid = Integer.parseInt(para.getValue());
        desStr = desStr + this.resourceUtil.getString("slot") + slotid + "," + this.resourceUtil.getString("port") + portid;
        return desStr;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        TEConfigurationDataMgr instace = TEConfigurationDataMgr.getInstance();
        int boardtype = instace.getBoardType(neid, slotid);
        if (boardtype == 1179) {
            inputData.getBussinessParams().getRowParams(0).addParam("level", "1");
        }
        try {
            return TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        TEBitTestData testdata = null;
        int len = outputArr.length;
        for (int j = 0; j < len; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode == 38662) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                return;
            }
            if (retCode != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)retCode));
                return;
            }
            if (j == 0) {
                testdata = new TEBitTestData();
                int slotid = Integer.parseInt(output.getPart("slotid").getValue());
                testdata.setSlotid(slotid);
                int portid = Integer.parseInt(output.getPart("portid").getValue());
                testdata.setPortid(portid);
                int direction = Integer.parseInt(output.getPart("direction").getValue());
                testdata.setDirection(direction);
                int timeunit = Integer.parseInt(output.getPart("timeunit").getValue());
                testdata.setTimeUnit(timeunit);
                Calendar startTime = TEDateUtils.byteStrToCalendar((String)output.getPart("starttime").getValue());
                testdata.setStartTime(startTime.getTime().getTime());
                int testtime = Integer.parseInt(output.getPart("testtime").getValue());
                testdata.setTesttime(testtime);
                String hashvalue = TEBitTestUtility.getPortName(neid, slotid, portid);
                TEBitTestCache.getInstance().addCahce(hashvalue, testdata);
            }
            int firstpoint = Integer.parseInt(output.getPart("firstpoint").getValue());
            Part p = output.getPart("errdata");
            String value = p.getValue();
            int num = value.length() / 8;
            int index = 0;
            for (int i = 0; i < num; ++i) {
                long errnum = Long.parseLong(value.substring(index, index + 8), 16);
                index += 8;
                if (errnum <= 0L) {
                    errnum = 0L;
                }
                testdata.addQueryResult(errnum, firstpoint);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }
}

