/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.bittest;

import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestNum;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Calendar;
import java.util.List;

public class TEDrawBitTestPic {
    private static final String BASE_PATH = "sdh" + File.separator + "res" + File.separator;
    private static final String PAKAGE_PATH = BASE_PATH + "bittest" + File.separator + "bittestres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private int PIC_HEIGHT = 220;
    private int PIC_WIDTH = 800;
    private BufferedImage spectWaveimage1 = new BufferedImage(this.PIC_WIDTH, this.PIC_HEIGHT, 1);
    private TEBitTestData testdata1 = null;
    private int x_lefttop = 90;
    private int y_lefttop = 30;
    private int y_leftbottom = this.PIC_HEIGHT - 20;
    private int x_rightbottom = this.PIC_WIDTH - 3;
    private String ystr = "errnum";
    private String xstr = "time";
    private Color standcoler = new Color(239, 239, 239);
    TimeZoneDateBean timezonebean = null;
    private static TEDrawBitTestPic instance = null;

    private TEDrawBitTestPic() {
    }

    public static synchronized TEDrawBitTestPic getInstance() {
        if (instance == null) {
            instance = new TEDrawBitTestPic();
        }
        return instance;
    }

    private void initres(int neid) {
        this.ystr = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.ystr);
        this.xstr = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.xstr);
        this.timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
    }

    public BufferedImage drawBitTestPic(int neid, String hashvalue) {
        this.initres(neid);
        this.testdata1 = TEBitTestCache.getInstance().getCahce(hashvalue);
        if (this.testdata1 == null) {
            this.drawInitPic1();
        } else {
            this.drawDataPic1();
        }
        return this.spectWaveimage1;
    }

    public void drawInitPic1() {
        Graphics2D waveg2d = this.getSVGGraphics1();
        this.paintFrame(waveg2d);
        this.paintinitY(waveg2d);
    }

    public Graphics2D getSVGGraphics1() {
        Graphics2D waveg2d = (Graphics2D)this.spectWaveimage1.getGraphics();
        return waveg2d;
    }

    public void drawDataPic1() {
        Graphics2D waveg2d = this.getSVGGraphics1();
        this.paintFrame(waveg2d);
        this.paintBitTestData1(waveg2d, this.testdata1);
    }

    private long getrealdata1(long querydata1) {
        if (querydata1 >= 0xFFFFFFL) {
            return 0L;
        }
        return querydata1;
    }

    private long[] getYaxisData1(TEBitTestData testdata1) {
        int isaccu = testdata1.isAccumulation();
        long ymax1 = 100L;
        if (isaccu == 1) {
            if (ymax1 < testdata1.getTotalErrNum()) {
                ymax1 = testdata1.getTotalErrNum();
            }
        } else {
            List<TEBitTestNum> relist = testdata1.getResultData();
            int len = relist.size();
            for (int i = 0; i < len; ++i) {
                TEBitTestNum testNum = relist.get(i);
                long num = this.getrealdata1(testNum.getErrnum());
                if (num <= ymax1) continue;
                ymax1 = num;
            }
        }
        long[] ydata = new long[6];
        if (ymax1 <= 120L) {
            ydata[0] = 0L;
            ydata[1] = 20L;
            ydata[2] = 40L;
            ydata[3] = 60L;
            ydata[4] = 80L;
            ydata[5] = ymax1;
        } else {
            long gridy = ymax1 / 5L;
            ydata[0] = 0L;
            ydata[1] = gridy * 1L;
            ydata[2] = gridy * 2L;
            ydata[3] = gridy * 3L;
            ydata[4] = gridy * 4L;
            ydata[5] = ymax1;
        }
        return ydata;
    }

    private long[] getErrData(TEBitTestData testdata1) {
        int isaccu = testdata1.isAccumulation();
        List<TEBitTestNum> relist = testdata1.getResultData();
        int size = relist.size();
        long[] errdata1 = new long[size];
        if (isaccu == 1) {
            long sum = testdata1.getOldErrNum();
            for (int i = 0; i < size; ++i) {
                long num = relist.get(i).getErrnum();
                if (num >= 0xFFFFFFL) {
                    errdata1[i] = -1L;
                    sum += 0L;
                    continue;
                }
                if (num == 0L) {
                    errdata1[i] = 0L;
                    sum += 0L;
                    continue;
                }
                errdata1[i] = sum + num;
                sum += num;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                long num = relist.get(i).getErrnum();
                errdata1[i] = num >= 0xFFFFFFL ? -1L : (num == 0L ? 0L : num);
            }
        }
        return errdata1;
    }

    private String[] getTimeData1(TEBitTestData testdata1) {
        String[] timestr1 = new String[5];
        List<TEBitTestNum> relist = testdata1.getResultData();
        int size = relist.size();
        int j = 0;
        int i = 0;
        while (i < size) {
            long time = relist.get(i).getHappenTime();
            Calendar calTime = Calendar.getInstance();
            calTime.setTimeInMillis(time);
            timestr1[j] = testdata1.getQueryList().size() <= 0 ? this.timezonebean.newCalendarToTime(calTime) : this.timezonebean.calendarToTime(calTime);
            i += 20;
            ++j;
        }
        for (i = 0; i < timestr1.length; ++i) {
            if (timestr1[i] != null) continue;
            timestr1[i] = "";
        }
        return timestr1;
    }

    public void paintBitTestData1(Graphics2D dc1, TEBitTestData testdata) {
        long[] ydata1 = this.getYaxisData1(testdata);
        long[] errdata1 = this.getErrData(testdata);
        String[] timedata1 = this.getTimeData1(testdata);
        dc1.setColor(Color.BLACK);
        long ymax = ydata1[ydata1.length - 1];
        int y_gridh = (this.y_leftbottom - this.y_lefttop) / 5;
        for (int i = 0; i < ydata1.length; ++i) {
            FontMetrics fontmetri = dc1.getFontMetrics();
            int cswidth = fontmetri.stringWidth(ydata1[i] + "");
            dc1.drawString(ydata1[i] + "", this.x_lefttop - cswidth - 3, this.y_leftbottom + 5 - y_gridh * i);
        }
        int x_gridw = (this.x_rightbottom - this.x_lefttop) / 100;
        for (int i = 0; i < timedata1.length; ++i) {
            dc1.drawString(timedata1[i], this.x_lefttop + x_gridw * i * 20, this.y_leftbottom + 15);
        }
        dc1.setColor(Color.red);
        int h = this.y_leftbottom - this.y_lefttop;
        for (int i = 0; i < errdata1.length; ++i) {
            int errh;
            if (errdata1[i] == -1L) {
                dc1.setColor(Color.YELLOW);
                errh = h;
                dc1.fillRect(this.x_lefttop + x_gridw * (i + 1) - 1, this.y_lefttop, 3, errh);
                continue;
            }
            if (errdata1[i] == 0L) {
                dc1.setColor(Color.GREEN);
                errh = h;
                dc1.fillRect(this.x_lefttop + x_gridw * (i + 1) - 1, this.y_lefttop, 3, errh);
                continue;
            }
            errh = (int)((double)errdata1[i] / (double)ymax * (double)h);
            dc1.fillRect(this.x_lefttop + x_gridw * (i + 1) - 1, this.y_leftbottom - errh, 3, errh);
        }
    }

    public void paintinitY(Graphics2D dc1) {
        int[] ydata1 = new int[]{0, 20, 40, 60, 80, 100};
        dc1.setColor(Color.BLACK);
        int y_gridh = (this.y_leftbottom - this.y_lefttop) / 5;
        for (int i = 0; i < ydata1.length; ++i) {
            FontMetrics fontmetri = dc1.getFontMetrics();
            int cswidth = fontmetri.stringWidth(ydata1[i] + "");
            dc1.drawString(ydata1[i] + "", this.x_lefttop - cswidth - 3, this.y_leftbottom + 5 - y_gridh * i);
        }
    }

    public void paintFrame(Graphics2D dc1) {
        dc1.setColor(this.standcoler);
        dc1.fillRect(0, 0, 820, 250);
        dc1.setColor(Color.BLACK);
        dc1.drawLine(this.x_lefttop, this.y_lefttop - 2, this.x_lefttop, this.y_leftbottom);
        dc1.drawLine(this.x_lefttop, this.y_leftbottom, this.x_rightbottom, this.y_leftbottom);
        int y_gridh = (this.y_leftbottom - this.y_lefttop) / 5;
        for (int i = 0; i < 5; ++i) {
            dc1.drawLine(this.x_lefttop - 2, this.y_lefttop + y_gridh * i, this.x_lefttop + 2, this.y_lefttop + y_gridh * i);
        }
        int x_gridw = (this.x_rightbottom - this.x_lefttop) / 100;
        for (int j = 1; j <= 100; ++j) {
            dc1.setColor(Color.BLACK);
            dc1.drawLine(this.x_lefttop + x_gridw * j, this.y_leftbottom + 2, this.x_lefttop + x_gridw * j, this.y_leftbottom - 2);
            if (j % 10 != 0) continue;
            dc1.setColor(Color.blue);
            dc1.drawLine(this.x_lefttop + x_gridw * j, this.y_leftbottom + 2, this.x_lefttop + x_gridw * j, this.y_leftbottom - 5);
        }
        dc1.drawString("(" + this.ystr + ")", this.x_lefttop + 5, this.y_lefttop - 10);
        dc1.drawString("(" + this.xstr + ")", this.x_rightbottom - 32, this.y_leftbottom + 15);
    }
}

