/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.bittest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestNum;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class TEBitTestData {
    private int neid;
    private int slotid;
    private int subslotid;
    private int portid;
    private int direction = -1;
    private int timeUnit;
    private long startTime;
    private int testtime;
    private int isAccumulation;
    private int progress = 0;
    private long oldErrNum = 0L;
    private long totalErrNum = 0L;
    private LinkedList<TEBitTestNum> reportResult = new LinkedList();
    private LinkedList<TEBitTestNum> queryResult = new LinkedList();
    private int teststate = 0;
    private long lastreportTime = 0L;

    public void init() {
        this.setOldErrNum(0L);
        this.totalErrNum = 0L;
        this.queryResult.clear();
    }

    public LinkedList<TEBitTestNum> getQueryList() {
        return this.queryResult;
    }

    public List<TEBitTestNum> getResultData() {
        if (this.teststate == 0) {
            if (this.queryResult.size() != 0) {
                return this.queryResult;
            }
            return this.reportResult;
        }
        return this.reportResult;
    }

    private long getrealdata(long querydata) {
        if (querydata >= 0xFFFFFFL) {
            return 0L;
        }
        return querydata;
    }

    public void addQueryResult(long errnum, int firstpoint) {
        if (this.queryResult.size() >= 100) {
            TEBitTestNum tNum = this.queryResult.removeFirst();
            this.setOldErrNum(this.getOldErrNum() + this.getrealdata(tNum.getErrnum()));
        }
        TEBitTestNum testnum = new TEBitTestNum();
        testnum.setErrnum(errnum);
        int size = this.queryResult.size();
        switch (this.timeUnit) {
            case 1: {
                testnum.setHappenTime(this.startTime + (long)(1000 * size));
                break;
            }
            case 2: {
                testnum.setHappenTime(this.startTime + 600000L);
                break;
            }
            case 3: {
                testnum.setHappenTime(this.startTime + 3600000L);
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("TEBitTestData.addQueryResult() timeUnit:" + this.timeUnit + " not in case!");
            }
        }
        this.progress = (int)((double)firstpoint / (double)this.testtime * 100.0);
        this.queryResult.add(testnum);
        this.totalErrNum += this.getrealdata(errnum);
    }

    public void addReportResult(TEBitTestNum testnum) {
        if (this.reportResult.size() >= 100) {
            TEBitTestNum tNum = this.reportResult.removeFirst();
            this.oldErrNum += this.getrealdata(tNum.getErrnum());
        }
        this.reportResult.add(testnum);
        this.totalErrNum += this.getrealdata(testnum.getErrnum());
    }

    public void refreshdata(int elapsetime, long errnum) {
        switch (this.timeUnit) {
            case 1: {
                this.progress = (int)((double)elapsetime / (double)this.testtime * 100.0);
                break;
            }
            case 2: {
                this.progress = (int)((double)elapsetime / (double)(this.testtime * 10) * 100.0);
                break;
            }
            case 3: {
                this.progress = (int)((double)elapsetime / (double)(this.testtime * 60) * 100.0);
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("TEBitTestData.refreshdata() timeUnit:" + this.timeUnit + " not in case!");
            }
        }
        TEBitTestNum testNum = new TEBitTestNum();
        Date d = new Date();
        testNum.setHappenTime(d.getTime());
        testNum.setErrnum(errnum);
        this.addReportResult(testNum);
        this.setLastreportTime(d.getTime());
        this.teststate = this.progress >= 100 ? 0 : 1;
    }

    public void setTotalErrNum(long totalErrNum) {
        this.totalErrNum = totalErrNum;
    }

    public long getTotalErrNum() {
        return this.totalErrNum;
    }

    public synchronized void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setTeststate(int teststate) {
        this.teststate = teststate;
    }

    public int getTeststate() {
        return this.teststate;
    }

    public void setOldErrNum(long oldErrNum) {
        this.oldErrNum = oldErrNum;
    }

    public long getOldErrNum() {
        return this.oldErrNum;
    }

    public void setLastreportTime(long lastreportTime) {
        this.lastreportTime = lastreportTime;
    }

    public long getLastreportTime() {
        return this.lastreportTime;
    }

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public int getNeid() {
        return this.neid;
    }

    public void setSlotid(int slotid) {
        this.slotid = slotid;
    }

    public int getSlotid() {
        return this.slotid;
    }

    public void setSubSlotid(int subSlotid) {
        this.subslotid = subSlotid;
    }

    public int getSubSlotid() {
        return this.subslotid;
    }

    public void setPortid(int portid) {
        this.portid = portid;
    }

    public int getPortid() {
        return this.portid;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setTimeUnit(int timeUnit) {
        this.timeUnit = timeUnit;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setAccumulation(int isAccumulation) {
        this.isAccumulation = isAccumulation;
    }

    public int isAccumulation() {
        return this.isAccumulation;
    }

    public void setTesttime(int testtime) {
        this.testtime = testtime;
    }

    public int getTesttime() {
        return this.testtime;
    }
}

