/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.bittest;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestCache;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestData;
import com.huawei.nglct.nemgr.ip.ptn.bittest.TEBitTestUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class TEBitInitTable
extends TENEExplorerBean {
    private int slotid = 0;
    private static int RTN910 = 76;
    private static int RTN950 = 77;
    private static int RTN910NA = 89;
    private static int RTN950NA = 90;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        this.slotid = Integer.parseInt(para.getValue());
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, this.slotid);
        int boardtype = board.getBoardType();
        ArrayList portnolist = TEConfigurationDataMgr.getInstance().getBoardPortList(neid, boardtype, this.slotid);
        this.outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        int len = portnolist.size();
        if ((TENEListMgr.getInstance().getNE(neid).getNEType() == RTN910 || TENEListMgr.getInstance().getNE(neid).getNEType() == RTN950 || TENEListMgr.getInstance().getNE(neid).getNEType() == 114 || TENEListMgr.getInstance().getNE(neid).getNEType() == RTN910NA || TENEListMgr.getInstance().getNE(neid).getNEType() == RTN950NA) && TEConfigurationDataMgr.getInstance().isIFboard(boardtype)) {
            len = 1;
        }
        for (int i = 0; i < len; ++i) {
            int portid = (Integer)portnolist.get(i);
            RowParams rowdata = null;
            String hashvalue = TEBitTestUtility.getPortName(neid, this.slotid, portid);
            TEBitTestData testdata = TEBitTestCache.getInstance().getCahce(hashvalue);
            rowdata = testdata == null ? this.getBlankData(portid) : this.getSaveData(testdata);
            bussiness.addRowParams(rowdata);
        }
        this.outputData.setBussinessParams(bussiness);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        return this.outputData;
    }

    private RowParams getBlankData(int portid) {
        boolean isbranch = true;
        isbranch = TEConfigurationDataMgr.getInstance().isBranchBoard(this.neid, this.slotid);
        RowParams param = new RowParams();
        String portname = TEBitTestUtility.getPortName(this.neid, this.slotid, portid);
        param.addParam("portid", portid + "");
        param.addParam("portname", portname);
        param.addParam("channel", "-");
        if (isbranch) {
            param.addParam("direction", "1");
        } else {
            param.addParam("direction", "0");
        }
        param.addParam("timeunit", "1");
        param.addParam("testtime", "1");
        param.addParam("starttime", "-");
        param.addParam("progress", "0%");
        param.addParam("totalErrNum", "0");
        param.addParam("isaccu", "0");
        param.addParam("teststate", "0");
        param.addParam("isbranch", "" + isbranch);
        return param;
    }

    private RowParams getSaveData(TEBitTestData testdata) {
        this.handledata(testdata);
        RowParams param = new RowParams();
        String portname = TEBitTestUtility.getPortName(this.neid, this.slotid, testdata.getPortid());
        param.addParam("portid", testdata.getPortid() + "");
        param.addParam("portname", portname);
        param.addParam("channel", "-");
        param.addParam("direction", testdata.getDirection() + "");
        param.addParam("timeunit", testdata.getTimeUnit() + "");
        param.addParam("testtime", testdata.getTesttime() + "");
        param.addParam("starttime", this.getStarttime(testdata));
        param.addParam("progress", testdata.getProgress() + "%");
        param.addParam("totalErrNum", testdata.getTotalErrNum() + "");
        param.addParam("isaccu", testdata.isAccumulation() + "");
        param.addParam("teststate", testdata.getTeststate() + "");
        if (0 == testdata.getDirection()) {
            param.addParam("isbranch", "false");
        } else {
            param.addParam("isbranch", "true");
        }
        return param;
    }

    private String getStarttime(TEBitTestData testdata) {
        TimeZoneDateBean timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neid);
        Calendar startTime = Calendar.getInstance();
        startTime.setTimeInMillis(testdata.getStartTime());
        String formatstr = TimeZoneDateBean.getTimeConvertFormat();
        String returnstr = null;
        if (testdata.getQueryList().size() <= 0) {
            SimpleDateFormat dataFormatterOther = new SimpleDateFormat(formatstr, Locale.ENGLISH);
            return dataFormatterOther.format(startTime.getTime());
        }
        returnstr = timezonebean.calendarToTime(startTime);
        return returnstr;
    }

    private void handledata(TEBitTestData testdata) {
        if (testdata.getTeststate() == 0) {
            return;
        }
        long lastreporttime = testdata.getLastreportTime();
        if (lastreporttime == 0L && testdata.getQueryList().size() <= 0) {
            testdata.setTeststate(1);
            return;
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

