/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.bfdmanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryPorts
implements TENEMgrInterface {
    private Datainterface datainterface = null;
    private int neID = 0;
    private int slotID = 0;
    private int subslotID = 0;
    private int querytype = 0;
    private static final int BOARDTYPE_EFG2 = 1171;
    private static final int BOARDTYPE_EG16 = 1125;
    private static final int BOARDTYPE_POD41 = 1134;
    private static final String INVALID_SUBSLOTID = "255";
    private static final int TN81ETFC = 1133;
    private static final int TN81D12 = 1135;
    private static final int TN81D75 = 1137;
    private static final int LAST_E1_PORTID = 32;
    private static final int LAST_FE_PORTID = 12;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        Param slotParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        this.slotID = Integer.parseInt(slotParam.getValue());
        Param subSlotParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"subslotid");
        this.subslotID = Integer.parseInt(subSlotParam.getValue());
        Param queryTParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"querytype");
        if (queryTParam != null) {
            this.querytype = Integer.parseInt(queryTParam.getValue());
        }
        this.datainterface = this.querytype == 0 ? this.constructBoardListData() : this.constructEthPortData();
        if (null != this.datainterface && null != this.datainterface.getBussinessParams()) {
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        return this.datainterface;
    }

    public Datainterface constructEthPortData() {
        String portLists = "";
        Param param = null;
        Datainterface data = new Datainterface();
        RowParams rParams = null;
        BussinessParams bParams = new BussinessParams();
        if (this.subslotID == 0) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardType();
            ArrayList<Integer> boardPortList = this.getPortList(this.slotID, boardType);
            if (boardType == 2079 || boardType == 2080) {
                boardPortList = TEConfigurationDataMgr.getInstance().getETHPort(this.neID, boardType);
            }
            if (boardType == 2084 || boardType == 2099 || boardType == 1254 || boardType == 2451 || boardType == 2551) {
                boardPortList = new ArrayList<Integer>();
                boardPortList.add(1);
                boardPortList.add(2);
            }
            if (boardType == 2081) {
                boardPortList = new ArrayList();
                boardPortList.add(1);
            }
            int len = boardPortList.size();
            for (int j = 0; j < len; ++j) {
                int portID = (Integer)boardPortList.get(j);
                if ((1135 == boardType || 1137 == boardType) && 0 == this.slotID % 2 && 32 == portID || 1133 == boardType && 2 == this.slotID % 4 && 12 == portID || (1410 == boardType || 1411 == boardType || 1607 == boardType || 1608 == boardType) && portID <= 16) continue;
                rParams = new RowParams();
                String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neID, this.slotID, boardType, portID);
                portLists = portName + "," + portID;
                param = new Param("portList", portLists);
                rParams.addParam(param);
                param = new Param("slotid", this.slotID + "");
                rParams.addParam(param);
                param = new Param("portid", portID + "");
                rParams.addParam(param);
                param = new Param("subslotid", "0");
                rParams.addParam(param);
                bParams.addRowParams(rParams);
            }
        } else {
            List subBoardList = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getSubBoardList();
            int isize = subBoardList.size();
            for (int k = 0; k < isize; ++k) {
                TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                int subBoardType = subBoards.getSubBoardType();
                int subBoardSlot = subBoards.getSubSlotID();
                ArrayList subBoardPortList = TEConfigurationDataMgr.getInstance().getETHVCTrunkPort(this.neID, subBoardType);
                int len = subBoardPortList.size();
                for (int j = 0; j < len; ++j) {
                    int portID = (Integer)subBoardPortList.get(j);
                    rParams = new RowParams();
                    String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neID, subBoardSlot, subBoardType, portID);
                    portLists = portName + "," + portID;
                    param = new Param("portList", portLists);
                    rParams.addParam(param);
                    param = new Param("slotid", this.slotID + "");
                    rParams.addParam(param);
                    param = new Param("portid", portID + "");
                    rParams.addParam(param);
                    param = new Param("subslotid", subBoardSlot + "");
                    rParams.addParam(param);
                    bParams.addRowParams(rParams);
                }
            }
        }
        data.setBussinessParams(bParams);
        return data;
    }

    public Datainterface constructBoardListData() {
        Datainterface data = new Datainterface();
        RowParams rParams = null;
        BussinessParams bParams = new BussinessParams();
        String portLists = "";
        Param param = null;
        if (this.subslotID == 0) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardType();
            ArrayList boardPortList = this.getPortList(this.slotID, boardType);
            int len = boardPortList.size();
            for (int j = 0; j < len; ++j) {
                int portID = (Integer)boardPortList.get(j);
                String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neID, this.slotID, boardType, portID);
                portLists = portName + "," + portID;
                param = new Param("portList", portLists);
                rParams = new RowParams();
                rParams.addParam(param);
                bParams.addRowParams(rParams);
            }
        } else {
            List subBoardList = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getSubBoardList();
            int isize = subBoardList.size();
            for (int k = 0; k < isize; ++k) {
                TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                int subBoardType = subBoards.getSubBoardType();
                int subBoardSlot = subBoards.getSubSlotID();
                ArrayList subBoardPortList = TEConfigurationDataMgr.getInstance().getBoardPortList(this.neID, subBoardType, this.slotID);
                int len = subBoardPortList.size();
                for (int j = 0; j < len; ++j) {
                    int portID = (Integer)subBoardPortList.get(j);
                    String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neID, subBoardSlot, subBoardType, portID);
                    portLists = portName + "," + portID;
                    param = new Param("portList", portLists);
                    rParams = new RowParams();
                    rParams.addParam(param);
                    bParams.addRowParams(rParams);
                }
            }
        }
        data.setBussinessParams(bParams);
        return data;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private ArrayList getPortList(int slotid, int boardType) {
        ArrayList allPortList = TEConfigurationDataMgr.getInstance().getBoardPortList(this.neID, boardType, this.slotID);
        ArrayList existPortList = null;
        if (1171 == boardType || 1125 == boardType || 1134 == boardType) {
            existPortList = this.getExistPortList(allPortList, slotid);
        }
        if (null == existPortList || existPortList.isEmpty()) {
            return allPortList;
        }
        return existPortList;
    }

    private ArrayList getExistPortList(ArrayList portList, int slotid) {
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_SUBBD_GET_PORT");
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(String.valueOf(slotid));
            input.setPartValue("subslotid", INVALID_SUBSLOTID);
            input.setPartValue("port", "0");
            operationList.add(oper);
            ArrayList<Integer> returnList = new ArrayList<Integer>();
            if (operationList.isEmpty()) {
                return returnList;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)this.neID, operationList, (int)10).retCode;
            if (result == 0) {
                Operation oOperation = (Operation)operationList.get(0);
                for (Output output : oOperation.getOutput()) {
                    if (!String.valueOf(0).equals(output.getFault()[0].getCode())) continue;
                    String portId = output.getPartValue("port");
                    returnList.add(Integer.valueOf(portId));
                }
            }
            return returnList;
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }
}

