/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.bfdmanagement;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Vector;

public class TEQueryBFD
extends TENEExplorerBean {
    private static final int INVALID_SLOTID = 255;
    public static final long MPLSTUNNELSTARTINDEX = 1L;
    public static final long GRETUNNELSTARTINDEX = 0x1000001L;
    public static final long IPTUNNELSTARTINDEX = 0x2000001L;
    private static final int VETHNET_PORT = 10240;
    private static final int MLPPP_PORT = 4096;
    public static final int MPLS = 0;
    public static final int GRE = 1;
    public static final int IP = 2;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        boolean allSucc = true;
        boolean allFail = true;
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        Vector logBoardList = neObj.getBoardList();
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        if ("0".equals(errorCode)) {
            allFail = false;
            RowParams[] rowParams = bussiness.getRowParams();
            for (int i = rowParams.length - 1; i >= 0; --i) {
                RowParams rowParam = rowParams[i];
                int slotId = 0;
                int portId = 0;
                try {
                    slotId = Integer.parseInt(rowParam.getParam("sourceboard").getValue());
                    portId = Integer.parseInt(rowParam.getParam("frontport").getValue());
                }
                catch (Exception ex) {
                    bussiness.removeRowParams(rowParam);
                    continue;
                }
                if (slotId >= 255) {
                    rowParam.addParam("frontportName", this.queryPortName(slotId, portId));
                }
                int len = logBoardList.size();
                for (int j = 0; j < len; ++j) {
                    TEBoard board = (TEBoard)logBoardList.get(j);
                    int boardType = board.getBoardType();
                    int boardSlot = board.getSlotID();
                    if (boardSlot != slotId) continue;
                    String boardName = cfgDataMgr.getBoardTypeName(neid, boardType);
                    rowParam.addParam("bdName", boardName);
                    String portName = cfgDataMgr.getPortName(neid, slotId, boardType, portId);
                    rowParam.addParam("frontportName", portName);
                }
                String tunnelIndex = rowParam.getParam("tunnelindex").getValue();
                if (tunnelIndex == null || tunnelIndex.equals("")) {
                    rowParam.addParam("bindtype", "3");
                } else if ("4294967295".equals(tunnelIndex)) {
                    rowParam.addParam("bindtype", "1");
                    continue;
                }
                this.queryTunnelInfo(tunnelIndex, rowParam);
            }
        } else {
            allSucc = false;
        }
        if (allSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else if (allFail) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
        this.outputData.setBussinessParams(bussiness);
    }

    private void queryTunnelInfo(String tunnelIndex, RowParams rowParam) {
        String cmdCode = "";
        if (this.getTunnelType(Long.parseLong(tunnelIndex)) == 1) {
            cmdCode = "NSCMD_CFG_GRE_TNL_GET_TUNNEL_EX";
            rowParam.addParam("bindtype", String.valueOf(1));
        } else {
            cmdCode = "NSCMD_CFG_IP_TNL_GET_TUNNEL_EX";
            rowParam.addParam("bindtype", String.valueOf(2));
        }
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("tunnelindex").setValue(tunnelIndex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            rowParam.addParam("tunnelid", operation.getOutput(0).getPart("tunnelid").getValue());
            rowParam.addParam("ip", operation.getOutput(0).getPart("ip").getValue());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    public int getTunnelType(long tunnelIndex) {
        int tunnelType = -1;
        tunnelType = 1L <= tunnelIndex && tunnelIndex < 0x1000001L ? 0 : (0x1000001L <= tunnelIndex && tunnelIndex < 0x2000001L ? 1 : 2);
        return tunnelType;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>(1);
        filterErrorCodeList.add(38662);
        return filterErrorCodeList;
    }

    private String queryPortName(int slotid, int port) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME_EX");
        Input input2 = oper.getInput();
        input2.setPartValue("slotid", slotid + "");
        input2.setPartValue("subslotid", "255");
        input2.setPartValue("port", port + "");
        operationList.add(oper);
        TENECommMgr.getInstance().sendCommand(this.neid, operationList, this.TIME_OUT);
        String portName = ((Operation)operationList.get(0)).getOutput()[0].getPartValue("portName").trim();
        if (port >= 10240) {
            portName = portName == null || "".equals(portName.trim()) ? Integer.valueOf(port - 10240).toString() : portName.trim();
            portName = port - 10240 + "(VEther-" + portName + ")";
        } else {
            portName = portName == null || "".equals(portName.trim()) ? Integer.valueOf(port - 10240).toString() : portName.trim();
            portName = port - 4096 + "(MP-" + portName + ")";
        }
        return portName;
    }
}

