/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atmoam;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;

public class TEQueryATMBean
extends TENEExplorerBean {
    protected String qxString = null;
    protected TEResourceUtil res = TEResourceUtil.getInstance((String)("nemgr/ip/ptn/res/atmoam/atmoamres_" + TESysManagerBean.getInstance().getlanguage() + ".ini"));
    protected static final int SRC = 1;
    protected static final int SINK = 2;
    protected static final int UNI = 0;
    protected static final String INVALID = "INVALID";
    protected static final int DEACTIVATE = 0;
    protected static final String INVALIDVCI = "4294967295";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Param qx = inputData.getBussinessParams().getRowParams(0).getParam("qx");
        this.qxString = qx.getValue();
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        int i;
        Param param;
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        if (Integer.parseInt(errorCode) != 0) {
            return;
        }
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        RowParams[] desRows = new RowParams[rowParamses.length];
        int size = rowParamses.length;
        for (int i2 = 0; i2 < size; ++i2) {
            RowParams rowParams = rowParamses[i2];
            if (null == rowParams || 0 == rowParams.getParamCount()) continue;
            param = null;
            param = rowParams.getParam("atmindex");
            String atmindex = param.getValue();
            param = rowParams.getParam("connectionid");
            String connectionid = param.getValue();
            if (this.qxString.equals("NSCMD_PTN_ATM_GET_SEGEND")) {
                desRows[i2] = this.qureySegmentInfo(atmindex, connectionid, rowParams);
                continue;
            }
            if (this.qxString.equals("NSCMD_PTN_ATM_GET_CC")) {
                this.handleMessageWhenGetCC(desRows, i2, rowParams, atmindex, connectionid);
                continue;
            }
            desRows[i2] = this.qureySegmentInfo(atmindex, connectionid, rowParams);
            param = rowParams.getParam("segmentattri");
            param.setValue("1");
            Param neParam = this.queryNeList();
            param = desRows[i2].getParam("segmentattri");
            param.setValue("1");
            if (neParam.getName() == null || neParam.getName().isEmpty()) continue;
            rowParams.addParam(neParam);
            desRows[i2].addParam(neParam);
        }
        if (rowParamses.length == 0) {
            return;
        }
        ArrayList<RowParams> newRows = new ArrayList<RowParams>();
        int size2 = rowParamses.length;
        for (i = 0; i < size2; ++i) {
            this.addSrCAndSinkCon(rowParamses, desRows, newRows, i);
        }
        for (i = newRows.size() - 1; i >= 0; --i) {
            RowParams rowParams = (RowParams)newRows.get(i);
            if (null == rowParams || 0 == rowParams.getParamCount()) continue;
            param = rowParams.getParam("pwID");
            if (param != null && param.getValue().equals(INVALID)) {
                newRows.remove(i);
                continue;
            }
            StringBuilder src = new StringBuilder();
            param = rowParams.getParam("srcboardName");
            if (param != null) {
                src.append(param.getValue());
                src.append("-");
                param = rowParams.getParam("srcportName");
                src.append(param.getValue());
                param = rowParams.getParam("invpi");
                if (!INVALIDVCI.equals(param.getValue())) {
                    src.append("-");
                    src.append(param.getValue());
                }
                if (!INVALIDVCI.equals((param = rowParams.getParam("invci")).getValue())) {
                    src.append("-");
                    src.append(param.getValue());
                }
            }
            StringBuilder des = new StringBuilder();
            if (rowParams.getParam("pwID") != null) {
                des.append("PW(");
                param = rowParams.getParam("serviceType");
                des.append(param.getValue());
                des.append(":");
                param = rowParams.getParam("pwID");
                des.append(param.getValue());
                des.append(")");
                param = rowParams.getParam("outvpi");
                if (!INVALIDVCI.equals(param.getValue())) {
                    des.append("-");
                    des.append(param.getValue());
                }
                if (!INVALIDVCI.equals((param = rowParams.getParam("outvci")).getValue())) {
                    des.append("-");
                    des.append(param.getValue());
                }
            } else if (rowParams.getParam("desboardName") != null) {
                param = rowParams.getParam("desboardName");
                des.append(param.getValue());
                des.append("-");
                param = rowParams.getParam("desportName");
                des.append(param.getValue());
                param = rowParams.getParam("outvpi");
                if (!INVALIDVCI.equals(param.getValue())) {
                    des.append("-");
                    des.append(param.getValue());
                }
                if (!INVALIDVCI.equals((param = rowParams.getParam("outvci")).getValue())) {
                    des.append("-");
                    des.append(param.getValue());
                }
            }
            rowParams.addParam("source", src.toString());
            rowParams.addParam("sink", des.toString());
        }
        RowParams[] rowArray = new RowParams[newRows.size()];
        newRows.toArray(rowArray);
        this.outputData.getBussinessParams().setRowParams(rowArray);
    }

    protected void addSrCAndSinkCon(RowParams[] rowParamses, RowParams[] desRows, List<RowParams> newRows, int i) {
        if (rowParamses[i].getParam("direction").getValue().equals(String.valueOf(1))) {
            newRows.add(rowParamses[i]);
        }
        if (desRows[i].getParam("direction").getValue().equals(String.valueOf(1))) {
            newRows.add(desRows[i]);
        }
    }

    protected void handleMessageWhenGetCC(RowParams[] desRows, int i, RowParams rowParams, String atmindex, String connectionid) {
        desRows[i] = this.qureyCCInfo(atmindex, connectionid, rowParams);
        Param param = rowParams.getParam("activateflag");
        if (Integer.parseInt(param.getValue()) == 0) {
            param = rowParams.getParam("segmentattri");
            param.setValue("255");
        }
        if (Integer.parseInt((param = desRows[i].getParam("activateflag")).getValue()) == 0) {
            param = desRows[i].getParam("segmentattri");
            param.setValue("255");
        }
    }

    protected Param queryNeList() {
        TIntArrayList neList = TENEListMgr.getInstance().getNEIDList();
        Param param = new Param();
        int size = neList.size();
        for (int i = 0; i < size; ++i) {
            TENE ne = TENEListMgr.getInstance().getNE(neList.get(i));
            String[] neversion = ne.getHostVersion().split("\\.");
            if (ne.getNEType() != 76 && ne.getNEType() != 77 && ne.getNEType() != 83 && ne.getNEType() != 89 && ne.getNEType() != 90 || Integer.parseInt(neversion[2]) != 1 && Integer.parseInt(neversion[2]) != 3) continue;
            String tmp = ne.getNEName() + "." + ne.getNEID();
            param.setName("ne");
            param.setValue("");
            param.addOption(new Option(tmp));
        }
        return param;
    }

    protected RowParams qureySegmentInfo(String atmindex, String connectionid, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_ATM_GET_SEGEND";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return null;
        }
        operation.getInput().getPart("atmindex").setValue(atmindex);
        operation.getInput().getPart("connectionid").setValue(connectionid);
        operation.getInput().getPart("direction").setValue(String.valueOf(1));
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        Operation operation2 = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        operation2.getInput().getPart("atmindex").setValue(atmindex);
        operation2.getInput().getPart("connectionid").setValue(connectionid);
        operation2.getInput().getPart("direction").setValue(String.valueOf(2));
        list.add(operation2);
        int result = this.sendMessage(this.neid, list);
        RowParams desRow = (RowParams)rowParam.clone();
        if (result == 0) {
            rowParam.addParam("direction", operation.getOutput(0).getPart("direction").getValue());
            rowParam.addParam("segmentattri", operation.getOutput(0).getPart("segmentattri").getValue());
            desRow.addParam("direction", operation2.getOutput(0).getPart("direction").getValue());
            desRow.addParam("segmentattri", operation2.getOutput(0).getPart("segmentattri").getValue());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        this.queryDetail(atmindex, rowParam, desRow);
        return desRow;
    }

    protected void queryDetail(String atmindex, RowParams rowParam, RowParams desRowParam) {
        String cmdCode = "NSCMD_PTN_ATM_GET_SRVPINFO";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("atmindex").setValue(atmindex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            int size = operation.getOutputCount();
            for (int i = 0; i < size; ++i) {
                String slotid = operation.getOutput(i).getPart("slotid").getValue();
                String srcPorttype = operation.getOutput(i).getPart("porttype").getValue();
                if (Integer.parseInt(slotid) != 65535) {
                    TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, Integer.parseInt(slotid));
                    String boardName = board.getBoardName();
                    String portid = operation.getOutput(i).getPart("pwindex").getValue();
                    String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, Integer.parseInt(slotid), board.getBoardType(), Integer.parseInt(portid));
                    if (Integer.parseInt(srcPorttype) == 0) {
                        if (i == 0) {
                            rowParam.addParam("srcboardName", slotid + "-" + boardName);
                            rowParam.addParam("srcportName", portName);
                            rowParam.addParam("srcportid", portid);
                            desRowParam.addParam("srcboardName", slotid + "-" + boardName);
                            desRowParam.addParam("srcportName", portName);
                            desRowParam.addParam("srcportid", portid);
                            continue;
                        }
                        rowParam.addParam("desboardName", slotid + "-" + boardName);
                        rowParam.addParam("desportName", portName);
                        rowParam.addParam("desportid", portid);
                        desRowParam.addParam("desboardName", slotid + "-" + boardName);
                        desRowParam.addParam("desportName", portName);
                        desRowParam.addParam("desportid", portid);
                        continue;
                    }
                    rowParam.addParam("desboardName", slotid + "-" + boardName);
                    rowParam.addParam("desportName", portName);
                    rowParam.addParam("desportid", portid);
                    desRowParam.addParam("desboardName", slotid + "-" + boardName);
                    desRowParam.addParam("desportName", portName);
                    desRowParam.addParam("desportid", portid);
                    continue;
                }
                String pwIndex = operation.getOutput(i).getPart("pwindex").getValue();
                this.queryPWInfo(pwIndex, rowParam);
                desRowParam.addParam("pwID", rowParam.getParam("pwID").getValue());
                desRowParam.addParam("serviceType", rowParam.getParam("serviceType").getValue());
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    protected void queryPWInfo(String pwIndex, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_MPLS_PW_GET_PW";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("pwIndex").setValue(pwIndex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            rowParam.addParam("pwID", operation.getOutput(0).getPart("pwID").getValue());
            String type = operation.getOutput(0).getPart("serviceType").getValue();
            rowParam.addParam("serviceType", this.res.getString("pwType_" + type));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    protected RowParams qureyCCInfo(String atmindex, String connectionid, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_ATM_GET_CC";
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == oper) {
            return null;
        }
        oper.getInput().getPart("atmindex").setValue(atmindex);
        oper.getInput().getPart("connectionid").setValue(connectionid);
        oper.getInput().getPart("direction").setValue(String.valueOf(1));
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(oper);
        Operation operation2 = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        operation2.getInput().getPart("atmindex").setValue(atmindex);
        operation2.getInput().getPart("connectionid").setValue(connectionid);
        operation2.getInput().getPart("direction").setValue(String.valueOf(2));
        list.add(operation2);
        int resultObj = this.sendMessage(this.neid, list);
        RowParams desRow = (RowParams)rowParam.clone();
        if (resultObj == 0) {
            rowParam.addParam("direction", oper.getOutput(0).getPart("direction").getValue());
            rowParam.addParam("segmentattri", oper.getOutput(0).getPart("segmentattri").getValue());
            rowParam.addParam("activateflag", oper.getOutput(0).getPart("activateflag").getValue());
            desRow.addParam("direction", operation2.getOutput(0).getPart("direction").getValue());
            desRow.addParam("segmentattri", operation2.getOutput(0).getPart("segmentattri").getValue());
            desRow.addParam("activateflag", operation2.getOutput(0).getPart("activateflag").getValue());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultObj));
        }
        this.queryDetail(atmindex, rowParam, desRow);
        return desRow;
    }
}

