/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm_u2kv1r3c00;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEATMIDUtil;
import com.huawei.nglct.nemgr.ip.ptn.atm_u2kv1r3c00.TEPWInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEQueryATMServiceBean
extends TENEExplorerBean {
    private static final int UNIUNI = 1;
    private static final int UNIsNNI = 2;
    private static final int NNI = 1;
    private static final int PWINDEX_INVALID = 0;
    private static final int NO_PROTECT = 0;
    private static final int PW_APS = 1;
    private static final int PROTECT_PAIRS = 2;
    public static final String NSCMD_ETHN_PWAPS_GET_APSPG = "NSCMD_ETHN_PWAPS_GET_APSPG";
    public static final String NSCMD_ETHN_PWAPS_GET_APSPAIR = "NSCMD_ETHN_PWAPS_GET_APSPAIR";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        if (Integer.parseInt(errorCode) != 0) {
            return;
        }
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        List apsList = this.queryAllAPS();
        for (int i = rowParamses.length - 1; i >= 0; --i) {
            RowParams rowParams = rowParamses[i];
            if (null == rowParams || 0 == rowParams.getParamCount()) continue;
            String atmIndex = rowParams.getParam("atmIndex").getValue();
            this.queryServiceType(atmIndex, rowParams);
            String pwIndex = this.queryServiceInfo(atmIndex, rowParams);
            if (pwIndex == null) continue;
            if (!apsList.isEmpty()) {
                this.queryPWIndex(atmIndex, pwIndex, rowParams, apsList);
                continue;
            }
            rowParams.addParam(new Param("pwIndex", pwIndex));
            rowParams.addParam(new Param("protecttype", String.valueOf(0)));
        }
        TEATMIDUtil.refreshATMIDCache(neid, rowParamses);
    }

    private List queryAllAPS() {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation apspgOper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_PWAPS_GET_APSPG);
        Operation apspairOper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_PWAPS_GET_APSPAIR);
        operList.add(apspgOper);
        operList.add(apspairOper);
        int retCode = TENECommMgr.getInstance().sendCommand((int)this.neid, operList, null, (int)this.TIME_OUT, (boolean)false).retCode;
        ArrayList<TEPWInfo> pwInfoList = new ArrayList<TEPWInfo>();
        if (0 == retCode) {
            int i;
            Output output = null;
            TEPWInfo pwInfo = null;
            int length = apspgOper.getOutputCount();
            for (i = 0; i < length && Integer.valueOf((output = apspgOper.getOutput(i)).getFault()[0].getCode()) == 0; ++i) {
                pwInfo = new TEPWInfo();
                pwInfo.setApsid(output.getPartValue("apsid"));
                pwInfo.setWorkpw(output.getPartValue("workpw"));
                pwInfo.setProtectpw(output.getPartValue("protectpw"));
                pwInfo.setProtecttype(String.valueOf(1));
                pwInfoList.add(pwInfo);
            }
            length = apspairOper.getOutputCount();
            for (i = 0; i < length && Integer.valueOf((output = apspairOper.getOutput(i)).getFault()[0].getCode()) == 0; ++i) {
                pwInfo = new TEPWInfo();
                pwInfo.setApsid(output.getPartValue("apsid"));
                pwInfo.setWorkpw(output.getPartValue("workpw"));
                pwInfo.setProtectpw(output.getPartValue("protectpw"));
                pwInfo.setProtecttype(String.valueOf(2));
                pwInfoList.add(pwInfo);
            }
        }
        return pwInfoList;
    }

    private void queryPWIndex(String atmindex, String pwIndex, RowParams rowParam, List<TEPWInfo> pwInfoList) {
        Iterator<TEPWInfo> it = pwInfoList.iterator();
        TEPWInfo pwInfo = null;
        boolean no_protect = true;
        while (it.hasNext()) {
            pwInfo = it.next();
            if (!pwInfo.getWorkpw().equals(pwIndex)) continue;
            rowParam.addParam(new Param("apsID", pwInfo.getApsid()));
            rowParam.addParam(new Param("pwIndex", pwInfo.getWorkpw()));
            rowParam.addParam(new Param("protectpwIndex", pwInfo.getProtectpw()));
            rowParam.addParam(new Param("protecttype", pwInfo.getProtecttype()));
            no_protect = false;
            break;
        }
        if (no_protect) {
            rowParam.addParam(new Param("pwIndex", pwIndex));
            rowParam.addParam(new Param("protecttype", String.valueOf(0)));
        }
    }

    private String queryServiceInfo(String atmindex, RowParams rowParam) {
        String pwIndex = null;
        if (rowParam.getParam("atmType").getValue().equals(String.valueOf(1))) {
            rowParam.addParam(new Param("pwIndex", String.valueOf(0)));
            return null;
        }
        String cmdCode = "NSCMD_PTN_ATM_GET_SRVPINFO";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return null;
        }
        operation.getInput().getPart("atmindex").setValue(atmindex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            int size = operation.getOutputCount();
            for (int i = 0; i < size; ++i) {
                if (!"0".equals(operation.getOutput(i).getFault(0).getCode())) {
                    rowParam.addParam(new Param("pwIndex", String.valueOf(0)));
                    continue;
                }
                String porttype = operation.getOutput(i).getPart("porttype").getValue();
                if (Integer.parseInt(porttype) != 1) continue;
                pwIndex = operation.getOutput(i).getPart("pwindex").getValue();
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        return pwIndex;
    }

    private void queryServiceType(String atmindex, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_ATM_GET_VNNI";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("servIndex").setValue(atmindex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            if (operation.getOutput(0).getPart("servIndex").getValue() == null) {
                rowParam.getParam("atmType").setValue(String.valueOf(1));
            } else {
                rowParam.getParam("atmType").setValue(String.valueOf(2));
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }
}

