/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm.create;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eaggr.TEEAggrUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;

public class TEATMUtil {
    private TEATMUtil() {
    }

    public static int createPW(int neid, List<RowParams> rowList) {
        Operation addSPWOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_ADD_STCUCPW");
        Input addSPWIpt = addSPWOper.getInput();
        Operation addDPWOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_ADD_DYNLDPPW");
        Input addDPWIpt = addDPWOper.getInput();
        Operation setEncapTypeOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_ENCAPTYPE");
        Input setEncapTypeInput = setEncapTypeOper.getInput();
        Operation setCWOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_CW");
        Input setCWInput = setCWOper.getInput();
        Operation setVccvOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_VCCV");
        Input setVccvInput = setVccvOper.getInput();
        Operation setConcat = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_ATM_CONCAT");
        Input setConcatInput = setConcat.getInput();
        Operation setExpOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_QOS_SET_PW_EXP");
        Input setExpInput = setExpOper.getInput();
        Operation setLspOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_QOS_SET_PW_LSPMODE");
        Input setLspInput = setLspOper.getInput();
        int pwSignalType = 0;
        Param param = null;
        RowParams rowParams = null;
        ArrayList<Object> operaList = null;
        int retCode = 0;
        ArrayList<String> pwIndexList = new ArrayList<String>();
        int m = rowList.size();
        for (int i = 0; i < m; ++i) {
            operaList = new ArrayList<Object>();
            rowParams = rowList.get(i);
            pwSignalType = Integer.valueOf(rowParams.getParam("pwSignalType").getValue());
            if (1 == pwSignalType) {
                addSPWIpt.setPartValue("pwType", rowParams.getParam("pwType").getValue());
                addSPWIpt.setPartValue("pwID", rowParams.getParam("pwID").getValue());
                addSPWIpt.setPartValue("direction", rowParams.getParam("direction").getValue());
                addSPWIpt.setPartValue("pwIngressLabel", rowParams.getParam("pwIngressLabel").getValue());
                addSPWIpt.setPartValue("pwEgressLabel", rowParams.getParam("pwEgressLabel").getValue());
                addSPWIpt.setPartValue("oppositeLsrID", rowParams.getParam("oppositeLsrID").getValue());
                addSPWIpt.setPartValue("tunnelIndexes", rowParams.getParam("tunnelIndexes").getValue());
                operaList.add(addSPWOper.clone());
            } else {
                addDPWIpt.setPartValue("pwType", rowParams.getParam("pwType").getValue());
                addDPWIpt.setPartValue("pwID", rowParams.getParam("pwID").getValue());
                addDPWIpt.setPartValue("direction", rowParams.getParam("direction").getValue());
                addDPWIpt.setPartValue("oppositeLsrID", rowParams.getParam("oppositeLsrID").getValue());
                addDPWIpt.setPartValue("tunnelIndexes", rowParams.getParam("tunnelIndexes").getValue());
                operaList.add(addDPWOper.clone());
            }
            setEncapTypeInput.setPartValue("pwEncapsType", rowParams.getParam("pwEncapsType").getValue());
            operaList.add(setEncapTypeOper.clone());
            setCWInput.setPartValue("controlWord", rowParams.getParam("controlWord").getValue());
            operaList.add(setCWOper.clone());
            setVccvInput.setPartValue("ctrlChanType", rowParams.getParam("ctrlChanType").getValue());
            setVccvInput.setPartValue("vccv", rowParams.getParam("vccv").getValue());
            operaList.add(setVccvOper.clone());
            setConcatInput.setPartValue("autoid", "2");
            setConcatInput.setPartValue("pwIndex", "0");
            setConcatInput.setPartValue("maxcount", rowParams.getParam("maxcount").getValue());
            setConcatInput.setPartValue("maxtime", rowParams.getParam("maxtime").getValue());
            operaList.add(setConcat.clone());
            param = rowParams.getParam("exp");
            if (null != param) {
                setExpInput.setPartValue("auto", "2");
                setExpInput.setPartValue("pwIndex", "0");
                setExpInput.setPartValue("direction", rowParams.getParam("idirection").getValue());
                setExpInput.setPartValue("exp", param.getValue());
                operaList.add(setExpOper.clone());
            }
            if (null != (param = rowParams.getParam("lspmode"))) {
                setLspInput.setPartValue("auto", "2");
                setLspInput.setPartValue("pwIndex", "0");
                setLspInput.setPartValue("direction", rowParams.getParam("edirection").getValue());
                setLspInput.setPartValue("lspmode", param.getValue());
                operaList.add(setLspOper.clone());
            }
            TEEAggrUtil.addTransaction(neid, operaList);
            retCode = TEEAggrUtil.handleCreatePW(neid, rowList, operaList, pwIndexList);
            if (0 != retCode) break;
        }
        TEEAggrUtil.backFillPwIndex(retCode, rowList, pwIndexList);
        return retCode;
    }

    public static String parseLabel(String vpi, String vci) {
        String[] vpiArr = vpi.split(",");
        String[] vciArr = vci.split(",");
        StringBuilder sb = new StringBuilder();
        int size = vpiArr.length;
        for (int i = 0; i < size; ++i) {
            if (vpiArr[i].equals("4294967295")) {
                sb.append("FFFFFFFF");
            } else {
                byte[] bvpi = TEATMUtil.unsignedShort2Bytes(Integer.parseInt(vpiArr[i]));
                String bsvpi = IOStreamConvertor.hexChangToString((byte[])bvpi);
                sb.append(bsvpi);
            }
            if (vciArr[i].equals("4294967295")) {
                sb.append("FFFFFFFF");
                continue;
            }
            byte[] bvci = TEATMUtil.unsignedShort2Bytes(Integer.parseInt(vciArr[i]));
            String bsvci = IOStreamConvertor.hexChangToString((byte[])bvci);
            sb.append(bsvci);
        }
        return sb.toString();
    }

    public static final byte[] unsignedShort2Bytes(int a) {
        byte[] byts = new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
        return byts;
    }
}

