/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEQxTrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TETrunckMbr;
import java.util.ArrayList;
import java.util.Collections;

public class TEVC12TrunckMbr
extends TETrunckMbr {
    public int boundPortID;
    public int upChannelID;

    public TEVC12TrunckMbr(int neid, int slotid, int trunckid, String level, String direction) {
        super(neid, slotid, trunckid, level, direction);
    }

    public TEVC12TrunckMbr(int neid, int slotid, int trunckid, String level, String direction, int boundSlotID, int boundPortID, int upChannelID, ArrayList<Integer> boundPaths) {
        super(neid, slotid, trunckid, level, direction, boundSlotID, boundPaths);
        this.boundPortID = boundPortID;
        this.upChannelID = upChannelID;
    }

    @Override
    public String buildBoundPathString() {
        Collections.sort(this.boundPaths);
        TEBoard teboard = TEConfigurationDataMgr.getInstance().getBoard(this.neid, this.boundSlotID);
        String boundBoardDes = TEImamgrUtils.buildBoardDes(this.neid, this.boundSlotID);
        String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, this.boundSlotID, teboard.getBoardType(), this.boundPortID);
        boundBoardDes = boundBoardDes + "-" + portName + "-VC4-" + this.upChannelID + "-(";
        boundBoardDes = boundBoardDes + TEImamgrUtils.buildIntStrFromList(this.boundPaths) + ")";
        return boundBoardDes;
    }

    @Override
    public boolean isEqualPort(int boundSlotID, int portID, int upChannelID) {
        return this.boundSlotID == boundSlotID && this.upChannelID == upChannelID && this.boundPortID == portID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.boundPortID;
        result = 31 * result + this.upChannelID;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEVC12TrunckMbr other = (TEVC12TrunckMbr)obj;
        if (this.boundPortID != other.boundPortID) {
            return false;
        }
        return this.upChannelID == other.upChannelID;
    }

    @Override
    public void addPathList(String pathListStr) {
        int upPathid = 0;
        int optiPortID = 0;
        int slotID = 0;
        if (pathListStr != null) {
            int endpos = pathListStr.indexOf("(");
            String cpnameStr = pathListStr.substring(0, endpos);
            int startLinePos = cpnameStr.indexOf("-");
            String slotIDStr = cpnameStr.substring(0, startLinePos);
            try {
                slotID = Integer.parseInt(slotIDStr);
            }
            catch (NumberFormatException e) {
                log.error("IMA\u00c9\u00e8\u00d6\u00c3\u00b3\u00c9\u00d4\u00b1\u00bd\u00e2\u00ce\u00f6\u00d0\u00c5\u00cf\u00a2\u00ca\u00a7\u00b0\u00dc:" + pathListStr, (Throwable)e);
                return;
            }
            int endLinePos = cpnameStr.lastIndexOf("-");
            String optiPortIDStr = cpnameStr.substring(endLinePos + 1);
            try {
                optiPortID = Integer.parseInt(optiPortIDStr);
            }
            catch (NumberFormatException e) {
                log.error("IMA\u00c9\u00e8\u00d6\u00c3\u00b3\u00c9\u00d4\u00b1\u00bd\u00e2\u00ce\u00f6\u00d0\u00c5\u00cf\u00a2\u00ca\u00a7\u00b0\u00dc:" + pathListStr, (Throwable)e);
                return;
            }
            int startVC4pos = pathListStr.indexOf("VC4-");
            String pathInfoStr = pathListStr.substring(startVC4pos);
            int vc4pos = pathInfoStr.indexOf("(");
            String vc4idStr = pathInfoStr.substring(4, vc4pos - 1);
            try {
                upPathid = Integer.parseInt(vc4idStr);
            }
            catch (NumberFormatException e) {
                log.error("IMA\u00c9\u00e8\u00d6\u00c3\u00b3\u00c9\u00d4\u00b1\u00bd\u00e2\u00ce\u00f6\u00d0\u00c5\u00cf\u00a2\u00ca\u00a7\u00b0\u00dc:" + pathListStr, (Throwable)e);
                return;
            }
            ArrayList<Integer> pathList = TEImamgrUtils.parserIntegerList(pathInfoStr.substring(vc4pos + 1, pathInfoStr.length() - 1));
            if (pathList != null && pathList.size() > 0) {
                this.boundPortID = optiPortID;
                this.boundSlotID = slotID;
                this.upChannelID = upPathid;
                this.boundPaths.addAll(pathList);
            }
        }
    }

    @Override
    public ArrayList<TEQxTrunckMbr> getLoseBoundPathList(TETrunckMbr otherTrunck) {
        ArrayList<TEQxTrunckMbr> qxTrunckList = new ArrayList<TEQxTrunckMbr>();
        ArrayList diff = TEImamgrUtils.getDiference(otherTrunck.boundPaths, this.boundPaths);
        for (int i = 0; i < diff.size(); ++i) {
            ArrayList<Integer> linktable = new ArrayList<Integer>();
            linktable.add((Integer)diff.get(i));
            TEQxTrunckMbr qxTrunck = new TEQxTrunckMbr(this.slotid, this.getTrunckid(), this.parserDirection(), this.boundSlotID, this.boundPortID, this.upChannelID, linktable);
            qxTrunckList.add(qxTrunck);
        }
        return qxTrunckList;
    }

    @Override
    public ArrayList<TEQxTrunckMbr> getMoreBoundPathList(TETrunckMbr otherTrunck) {
        ArrayList<TEQxTrunckMbr> qxTrunckList = new ArrayList<TEQxTrunckMbr>();
        ArrayList diff = TEImamgrUtils.getDiference(this.boundPaths, otherTrunck.boundPaths);
        for (int i = 0; i < diff.size(); ++i) {
            ArrayList<Integer> linktable = new ArrayList<Integer>();
            linktable.add((Integer)diff.get(i));
            TEQxTrunckMbr qxTrunck = new TEQxTrunckMbr(this.slotid, this.getTrunckid(), this.parserDirection(), this.boundSlotID, this.boundPortID, this.upChannelID, linktable);
            qxTrunckList.add(qxTrunck);
        }
        return qxTrunckList;
    }

    @Override
    public ArrayList<TEQxTrunckMbr> getQxTrunckPathList() {
        ArrayList<TEQxTrunckMbr> qxTrunckList = new ArrayList<TEQxTrunckMbr>();
        TEQxTrunckMbr qxTrunck = new TEQxTrunckMbr(this.slotid, this.getTrunckid(), this.parserDirection(), this.boundSlotID, this.boundPortID, this.upChannelID, this.boundPaths);
        qxTrunckList.add(qxTrunck);
        return qxTrunckList;
    }

    @Override
    public RowParams parserTrunckMbrToRowParams() {
        RowParams row = super.parserTrunckMbrToRowParams();
        row.addParam("optiPortid", String.valueOf(this.boundPortID));
        return row;
    }

    @Override
    public boolean isEqualTrunck(TETrunckMbr other) {
        return super.isEqualTrunck(other) && other instanceof TEVC12TrunckMbr && this.boundPortID == ((TEVC12TrunckMbr)other).boundPortID;
    }
}

