/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.nemgr.ip.ptn.atm.TEE1TrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEFranE1TrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEQxTrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TETrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEVC12TrunckMbr;

public class TETrunckMbrFactory {
    private static TETrunckMbrFactory instance = null;

    private TETrunckMbrFactory() {
    }

    public static synchronized TETrunckMbrFactory getInstance() {
        if (instance == null) {
            instance = new TETrunckMbrFactory();
        }
        return instance;
    }

    public TETrunckMbr createTrunckMbr(int neid, int slotid, int trunckid, String level, String direction) {
        if (level.equalsIgnoreCase("E1")) {
            return new TEE1TrunckMbr(neid, slotid, trunckid, level, direction);
        }
        if (level.equalsIgnoreCase("Fractional E1")) {
            return new TEFranE1TrunckMbr(neid, slotid, trunckid, level, direction);
        }
        return new TEVC12TrunckMbr(neid, slotid, trunckid, level, direction);
    }

    public TETrunckMbr createTrunckMbr(TEQxTrunckMbr qxmbr, int neid) {
        String level = null;
        if (qxmbr.boundportid == 65535) {
            level = "E1";
            if (qxmbr.linktable.size() > 0 && qxmbr.linktable.get(0) > 6144 && qxmbr.linktable.get(0) < 8191) {
                level = "Fractional E1";
            }
        } else {
            level = "VC12-xv";
        }
        if ("E1".equals(level)) {
            return new TEE1TrunckMbr(neid, qxmbr.slotid, qxmbr.trunckid, level, TEImamgrUtils.parserDirection(qxmbr.direction), qxmbr.boundslotid, qxmbr.linktable);
        }
        if ("Fractional E1".equals(level)) {
            return new TEFranE1TrunckMbr(neid, qxmbr.slotid, qxmbr.trunckid, level, TEImamgrUtils.parserDirection(qxmbr.direction), qxmbr.boundslotid, qxmbr.linktable);
        }
        return new TEVC12TrunckMbr(neid, qxmbr.slotid, qxmbr.trunckid, level, TEImamgrUtils.parserDirection(qxmbr.direction), qxmbr.boundslotid, qxmbr.boundportid, qxmbr.bounduppath, qxmbr.linktable);
    }
}

