/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEQxTrunckMbr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TETrunckMbr {
    protected static Logger log = TELogFactory.getNormalLogger();
    protected static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    protected static final String STRING_SOURCE = "ip" + File.separator + "ptn" + File.separator + "res" + File.separator + "imamanagement" + File.separator + "imamanagement_" + LANGUAGE + ".ini";
    TEResourceUtil resourceUtil;
    public String level;
    public String direction;
    public String vctrunck;
    public ArrayList<Integer> boundPaths = new ArrayList();
    public int numBoundPaths;
    public int boundSlotID;
    public int neid;
    public int slotid;
    public int trunckid;

    public TETrunckMbr(int neid, int slotid, int trunckid, String level, String direction) {
        this.neid = neid;
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        this.slotid = slotid;
        this.trunckid = trunckid;
        this.level = level;
        this.direction = direction;
        this.vctrunck = TEImamgrUtils.getTrunckName(neid, slotid, this.trunckid);
    }

    public static String getTrunckName(int neid, int slotid, int trunckid) {
        TEBoard teboard = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        String portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, teboard.getBoardType(), trunckid);
        portname = TEImamgrUtils.buildBoardDes(neid, slotid) + "-" + portname;
        return portname;
    }

    public TETrunckMbr(int neid, int slotid, int trunckid, String level, String direction, int boundSlotID, ArrayList<Integer> boundPaths) {
        this.neid = neid;
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        this.slotid = slotid;
        this.trunckid = trunckid;
        this.level = level;
        this.direction = direction;
        this.boundSlotID = boundSlotID;
        this.boundPaths = boundPaths;
        this.vctrunck = TEImamgrUtils.getTrunckName(neid, slotid, this.trunckid);
    }

    public RowParams parserTrunckMbrToRowParams() {
        RowParams row = new RowParams();
        row.addParam("vctrunck", this.vctrunck);
        row.addParam("level", this.level);
        row.addParam("direction", this.resourceUtil.getString(this.direction));
        row.addParam("boundpath", this.buildBoundPathString());
        row.addParam("boundpathnum", String.valueOf(2 * this.boundPaths.size()));
        row.addParam("pathListNum", this.buildBoundPathList());
        return row;
    }

    public String buildBoundPathString() {
        return "";
    }

    protected String buildBoundPathList() {
        StringBuffer pathList = new StringBuffer("");
        for (int i = 0; i < this.boundPaths.size(); ++i) {
            pathList.append(this.boundPaths.get(i));
            if (i == this.boundPaths.size() - 1) continue;
            pathList.append(",");
        }
        return pathList.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boundPaths == null ? 0 : this.boundPaths.hashCode());
        result = 31 * result + this.boundSlotID;
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
        result = 31 * result + this.neid;
        result = 31 * result + this.numBoundPaths;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TETrunckMbr other = (TETrunckMbr)obj;
        if (this.boundPaths == null ? other.boundPaths != null : !this.boundPaths.equals(other.boundPaths)) {
            return false;
        }
        if (this.boundSlotID != other.boundSlotID) {
            return false;
        }
        if (this.direction == null ? other.direction != null : !this.direction.equals(other.direction)) {
            return false;
        }
        if (this.level == null ? other.level != null : !this.level.equals(other.level)) {
            return false;
        }
        if (this.neid != other.neid) {
            return false;
        }
        return this.numBoundPaths == other.numBoundPaths;
    }

    public boolean isEqualPort(int boundSlotID, int portID, int upChannelID) {
        return false;
    }

    public void addPathList(String pathListStr) {
    }

    public ArrayList<TEQxTrunckMbr> getQxTrunckPathList() {
        return null;
    }

    public ArrayList<TEQxTrunckMbr> getLoseBoundPathList(TETrunckMbr otherTrunck) {
        return null;
    }

    public ArrayList<TEQxTrunckMbr> getMoreBoundPathList(TETrunckMbr otherTrunck) {
        return null;
    }

    public int parserDirection() {
        if (this.direction.equalsIgnoreCase(this.resourceUtil.getString("UPLINK"))) {
            return 2;
        }
        if (this.direction.equalsIgnoreCase(this.resourceUtil.getString("UPLINK"))) {
            return 1;
        }
        return 0;
    }

    public int getTrunckid() {
        return this.trunckid;
    }

    public boolean isEqualTrunck(TETrunckMbr other) {
        return this.vctrunck.equalsIgnoreCase(other.vctrunck);
    }
}

