/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TEQueryPortAttributeBean
extends TENEExplorerBean {
    private static final int UNI = 0;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        if (Integer.parseInt(errorCode) != 0) {
            return;
        }
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        HashMap portMap = new HashMap();
        for (int i = rowParamses.length - 1; i >= 0; --i) {
            RowParams rowParams = rowParamses[i];
            if (null == rowParams || 0 == rowParams.getParamCount()) continue;
            String porttype = rowParams.getParam("porttype").getValue();
            if (Integer.parseInt(porttype) != 0) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            Param param = rowParams.getParam("slotid");
            String slotid = param.getValue();
            param = rowParams.getParam("pwindex");
            String portid = param.getValue();
            TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(slotid));
            String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, Integer.parseInt(slotid), board.getBoardType(), Integer.parseInt(portid));
            String boardName = board.getBoardName();
            String name = slotid + "-" + boardName + "-" + portName;
            if (!portMap.containsKey(name)) {
                rowParams.addParam("portname", name);
                portMap.put(name, null);
            } else {
                this.outputData.getBussinessParams().removeRowParams(i);
            }
            this.queryVPVCRange(slotid, portid, rowParams);
        }
    }

    private void queryVPVCRange(String slotid, String portid, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_ATM_GET_PORTVPVCRNG_EX";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("slotid").setValue(slotid);
        operation.getInput().getPart("trunckid").setValue(portid);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }
}

