/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEQueryPWBasicInfoBean
extends TENEExplorerBean {
    private static final int UNI = 0;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        if (Integer.parseInt(errorCode) != 0) {
            return;
        }
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        for (int i = rowParamses.length - 1; i >= 0; --i) {
            String porttype;
            RowParams rowParams = rowParamses[i];
            if (null == rowParams || 0 == rowParams.getParamCount() || Integer.parseInt(porttype = rowParams.getParam("porttype").getValue()) != 0) continue;
            this.outputData.getBussinessParams().removeRowParams(i);
        }
    }

    private void queryEnable(String pwIndex, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_MPLS_PW_GET_ENABLE";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("pwIndex").setValue(pwIndex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            rowParam.addParam("enableState", operation.getOutput(0).getPart("enableState").getValue());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    private void queryState(String pwIndex, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_MPLS_PW_GET_STATE";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("pwIndex").setValue(pwIndex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            rowParam.addParam("localWorkingStat", operation.getOutput(0).getPart("localWorkingStat").getValue());
            rowParam.addParam("remoteWorkingStat", operation.getOutput(0).getPart("remoteWorkingStat").getValue());
            rowParam.addParam("compWorkingStat", operation.getOutput(0).getPart("compWorkingStat").getValue());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    private void queryPWInfo(String pwIndex, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_MPLS_PW_GET_PW";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("pwIndex").setValue(pwIndex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            rowParam.addParam("pwID", operation.getOutput(0).getPart("pwID").getValue());
            rowParam.addParam("pwSignalType", operation.getOutput(0).getPart("pwSignalType").getValue());
            rowParam.addParam("serviceType", operation.getOutput(0).getPart("serviceType").getValue());
            rowParam.addParam("pwEncapsType", operation.getOutput(0).getPart("pwEncapsType").getValue());
            rowParam.addParam("pwIngressLabel", operation.getOutput(0).getPart("pwIngressLabel").getValue());
            rowParam.addParam("pwEgressLabel", operation.getOutput(0).getPart("pwEgressLabel").getValue());
            rowParam.addParam("direction", operation.getOutput(0).getPart("direction").getValue());
            String oppositeLsrID = this.getLsrID(operation.getOutput(0).getPart("oppositeLsrID").getValue());
            rowParam.addParam("oppositeLsrID", oppositeLsrID);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    private String getLsrID(String id) {
        byte[] b = TEQueryPWBasicInfoBean.UnsignedShort2Bytes(Integer.parseInt(id));
        String bs = IOStreamConvertor.hexChangToString((byte[])b);
        StringBuilder idb = new StringBuilder();
        int size = 8;
        for (int i = 0; i < size; ++i) {
            idb.append(Integer.parseInt(bs.substring(i, i + 2), 16));
            idb.append(".");
            ++i;
        }
        String tmp = idb.toString();
        return tmp.substring(0, tmp.length() - 1);
    }

    public static final byte[] UnsignedShort2Bytes(int a) {
        byte[] b = new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
        return b;
    }
}

