/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEQueryCosInfoBean
extends TENEExplorerBean {
    private static final int UNI = 0;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        if (Integer.parseInt(errorCode) != 0) {
            return;
        }
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        for (int i = rowParamses.length - 1; i >= 0; --i) {
            RowParams rowParams = rowParamses[i];
            if (null == rowParams || 0 == rowParams.getParamCount()) continue;
            String porttype = rowParams.getParam("porttype").getValue();
            if (Integer.parseInt(porttype) == 0) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            String portid = rowParams.getParam("portid").getValue();
            String atmindex = rowParams.getParam("atmindex").getValue();
            this.queryCosMappingID(atmindex, portid, rowParams);
            String pwIndex = rowParams.getParam("pwIndex").getValue();
            this.queryPWInfo(pwIndex, rowParams);
        }
    }

    private void queryPWInfo(String pwIndex, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_MPLS_PW_GET_PW";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("pwIndex").setValue(pwIndex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            rowParam.addParam("pwID", operation.getOutput(0).getPart("pwID").getValue());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    private void queryCosMappingID(String atmindex, String portid, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_QOS_GET_ATMCOSMAPAPPLY_BYVNNIINFO";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("vnniid").setValue(portid);
        operation.getInput().getPart("atmindex").setValue(atmindex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            String cosmappingid = operation.getOutput(0).getPart("cosid").getValue();
            rowParam.addParam("cosid", cosmappingid);
            this.queryCosMappingName(cosmappingid, rowParam);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    private void queryCosMappingName(String cosmappingid, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_QOS_GET_ATMCOSMAPNAME";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("cosid").setValue(cosmappingid);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            String name = operation.getOutput(0).getPart("cosname").getValue().trim();
            rowParam.addParam("showname", cosmappingid + "(" + name + ")");
            rowParam.addParam("cosname", name);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }
}

