/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryConnectionBean
extends TENEExplorerBean {
    private static final int UNI = 0;
    private static final String INVALID = "-";
    private static final int POLICY_ATM = 5;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        if (Integer.parseInt(errorCode) != 0) {
            return;
        }
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        if (rowParamses.length == 0) {
            Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_ATM_GET_VNNI");
            Operation servInfoperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_ATM_GET_SRVPINFO");
            String inputAtmindex = this.inputData.getBussinessParams().getRowParams(0).getParam("atmindex").getValue();
            operation.getInput().getPart("servIndex").setValue(inputAtmindex);
            servInfoperation.getInput().getPart("atmindex").setValue(inputAtmindex);
            ArrayList<Operation> list = new ArrayList<Operation>();
            list.add(operation);
            list.add(servInfoperation);
            int result = this.sendMessage(neid, list);
            if (result == 0 && operation.getOutput().length > 0) {
                Output output = operation.getOutput(0);
                RowParams rowParams = new RowParams();
                rowParams.addParam(new Param("atmindex", inputAtmindex));
                rowParams.addParam(new Param("connectionid", output.getPartValue("vnniid")));
                rowParams.addParam(new Param("inlogicporttype", INVALID));
                rowParams.addParam(new Param("inlogicportid", INVALID));
                rowParams.addParam(new Param("invpi", INVALID));
                rowParams.addParam(new Param("invci", INVALID));
                rowParams.addParam(new Param("outlogicporttype", INVALID));
                rowParams.addParam(new Param("outlogicportid", INVALID));
                rowParams.addParam(new Param("outvpi", INVALID));
                rowParams.addParam(new Param("outvci", INVALID));
                rowParams.addParam(new Param("upid", INVALID));
                rowParams.addParam(new Param("downid", INVALID));
                rowParams.addParam(new Param("sinkport", INVALID));
                rowParams.addParam(new Param("uplinkpolicy", INVALID));
                rowParams.addParam(new Param("downlinkpolicy", INVALID));
                this.queryPWInfo(output.getPartValue("pwIndex"), rowParams);
                int iLength = servInfoperation.getOutput().length;
                for (int i = 0; i < iLength; ++i) {
                    if (!String.valueOf(0).equals(servInfoperation.getOutput(i).getPartValue("porttype"))) continue;
                    String portid = servInfoperation.getOutput(i).getPart("pwindex").getValue();
                    String slotid = servInfoperation.getOutput(i).getPart("slotid").getValue();
                    TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(slotid));
                    String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, Integer.parseInt(slotid), board.getBoardType(), Integer.parseInt(portid));
                    String boardName = board.getBoardName();
                    rowParams.addParam("srcport", slotid + INVALID + boardName + INVALID + portName);
                }
                this.outputData.getBussinessParams().addRowParams(rowParams);
                return;
            }
        }
        for (RowParams rowParams : rowParamses) {
            if (null == rowParams || 0 == rowParams.getParamCount()) continue;
            Param param = rowParams.getParam("atmindex");
            String atmindex = param.getValue();
            param = rowParams.getParam("connectionid");
            String connid = param.getValue();
            this.queryConnName(atmindex, connid, rowParams);
            param = rowParams.getParam("inlogicportid");
            int inlogicportid = Integer.parseInt(param.getValue());
            param = rowParams.getParam("inlogicporttype");
            int inlogicporttype = Integer.parseInt(param.getValue());
            param = rowParams.getParam("outlogicportid");
            int outlogicportid = Integer.parseInt(param.getValue());
            param = rowParams.getParam("outlogicporttype");
            int outlogicporttype = Integer.parseInt(param.getValue());
            this.queryDetail(atmindex, inlogicportid, inlogicporttype, outlogicportid, outlogicporttype, rowParams);
            String up = rowParams.getParam("upid").getValue();
            String down = rowParams.getParam("downid").getValue();
            this.queryPolicyID(up, down, rowParams);
        }
    }

    private void queryDetail(String atmindex, int inlogicportid, int inlogicporttype, int outlogicportid, int outlogicporttype, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_ATM_GET_SRVPINFO";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("atmindex").setValue(atmindex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            int size = operation.getOutputCount();
            for (int i = 0; i < size; ++i) {
                String logicid = operation.getOutput(i).getPart("portid").getValue();
                String porttype = operation.getOutput(i).getPart("porttype").getValue();
                try {
                    String boardName;
                    String portName;
                    TEBoard board;
                    String slotid;
                    String portid;
                    if (Integer.parseInt(logicid) == inlogicportid && Integer.parseInt(porttype) == inlogicporttype) {
                        portid = operation.getOutput(i).getPart("pwindex").getValue();
                        slotid = operation.getOutput(i).getPart("slotid").getValue();
                        board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, Integer.parseInt(slotid));
                        portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, Integer.parseInt(slotid), board.getBoardType(), Integer.parseInt(portid));
                        boardName = board.getBoardName();
                        rowParam.addParam("srcatmslottid", slotid);
                        rowParam.addParam("srcatmportid", portid);
                        rowParam.addParam("srcport", slotid + INVALID + boardName + INVALID + portName);
                    }
                    if (Integer.parseInt(logicid) != outlogicportid || Integer.parseInt(porttype) != outlogicporttype) continue;
                    portid = operation.getOutput(i).getPart("pwindex").getValue();
                    if (Integer.parseInt(porttype) == 0) {
                        slotid = operation.getOutput(i).getPart("slotid").getValue();
                        board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, Integer.parseInt(slotid));
                        portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, Integer.parseInt(slotid), board.getBoardType(), Integer.parseInt(portid));
                        boardName = board.getBoardName();
                        rowParam.addParam("dstatmslotid", slotid);
                        rowParam.addParam("dstatmportid", portid);
                        rowParam.addParam("sinkport", slotid + INVALID + boardName + INVALID + portName);
                        rowParam.addParam("pwid", INVALID);
                        continue;
                    }
                    this.queryPWInfo(portid, rowParam);
                    rowParam.addParam("pwid", rowParam.getParam("pwID").getValue());
                    rowParam.addParam("serviceType", rowParam.getParam("serviceType").getValue());
                    rowParam.addParam("sinkport", INVALID);
                    continue;
                }
                catch (NumberFormatException e) {
                    TELogFactory.getNormalLogger().error("get atm portid fail!" + e.toString());
                }
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    private void queryPWInfo(String pwIndex, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_MPLS_PW_GET_PW";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("pwIndex").setValue(pwIndex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            rowParam.addParam("pwID", operation.getOutput(0).getPart("pwID").getValue());
            rowParam.addParam("pwid", operation.getOutput(0).getPart("pwID").getValue());
            rowParam.addParam("serviceType", operation.getOutput(0).getPart("serviceType").getValue());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    private void queryPolicyID(String uppolicyid, String downpolicyid, RowParams rowParam) {
        ArrayList<Operation> list = new ArrayList<Operation>();
        String cmdCode = "NSCMD_PTN_QOS_GET_POLICY_QOSINFO";
        Operation operation1 = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation1) {
            return;
        }
        Part tmpPart = operation1.getInput().getPart("policytype");
        if (tmpPart == null) {
            tmpPart = operation1.getInput().getPart("policyType");
        }
        tmpPart.setValue(String.valueOf(5));
        tmpPart = operation1.getInput().getPart("policyid");
        if (tmpPart == null) {
            tmpPart = operation1.getInput().getPart("policyId");
        }
        tmpPart.setValue(uppolicyid);
        list.add(operation1);
        Operation operation2 = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        tmpPart = operation2.getInput().getPart("policytype");
        if (tmpPart == null) {
            tmpPart = operation2.getInput().getPart("policyType");
        }
        tmpPart.setValue(String.valueOf(5));
        tmpPart = operation2.getInput().getPart("policyid");
        if (tmpPart == null) {
            tmpPart = operation2.getInput().getPart("policyId");
        }
        tmpPart.setValue(downpolicyid);
        list.add(operation2);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            String policyname = operation1.getOutput(0).getPart("policyName").getValue().trim();
            rowParam.addParam("uplinkpolicy", uppolicyid + "(" + policyname + ")");
            rowParam.addParam("uplinkpolicyid", uppolicyid);
            policyname = operation2.getOutput(0).getPart("policyName").getValue().trim();
            rowParam.addParam("downlinkpolicy", downpolicyid + "(" + policyname + ")");
            rowParam.addParam("downlinkpolicyid", downpolicyid);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    private void queryConnName(String atmindex, String connectionid, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_ATM_GET_CONNECTION_NAME";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("atmindex").setValue(atmindex);
        operation.getInput().getPart("connectionid").setValue(connectionid);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            String connectName = operation.getOutput(0).getPart("connectionname").getValue();
            if (connectName != null) {
                rowParam.addParam("connectionname", connectName.trim());
            } else {
                rowParam.addParam("connectionname", "");
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }
}

