/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEImamgrUtils;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEQxTrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TETrunckMbr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TETrunckMbrFactory;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Iterator;

public class TEQueryBindingPathBean
extends TENEExplorerBean {
    private static final int UNI = 0;
    public static final int BIDIRECTION = 0;
    public static final int UPDIRECTION = 1;
    public static final int DOWNDIRECTION = 2;
    public static final String BIDIRECTION_STR = "BIDIRECTIONAL";
    public static final String UPDIRECTION_STR = "DOWNLINK";
    public static final String DOWNDIRECTION_STR = "UPLINK";
    public static final String PTNCP_ATTR_IMAGROUP = "PTNCP_ATTR_IMAGROUP";
    public static final int ENABLE = 1;
    public static final int NSCMD_PTN_ATM_GET_TRUNKIMAEN_EX = 33902;
    public static final int NSCMD_PTN_ATM_GET_IMASTATUS_EX = 33906;
    public static final int NSCMD_PTN_ATM_GET_TRUNKMBR_EX = 33899;
    public static final int NSCMD_PTN_ATM_GET_IMALINKSTATUS_EX = 33907;
    public static final int OPERATION_SUCCESS = 0;
    public static final int OPERATION_FAILED = -1;
    public static final String E1 = "E1";
    public static final String FRACTIONE1 = "Fractional E1";
    public static final String VC12 = "VC12-xv";
    private ArrayList<TEQxTrunckMbr> trunckMbrs = new ArrayList();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        if (Integer.parseInt(errorCode) != 0) {
            return;
        }
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        for (int i = rowParamses.length - 1; i >= 0; --i) {
            RowParams rowParams = rowParamses[i];
            if (null == rowParams || 0 == rowParams.getParamCount()) continue;
            String porttype = rowParams.getParam("porttype").getValue();
            if (Integer.parseInt(porttype) != 0) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            Param param = rowParams.getParam("slotid");
            String slotid = param.getValue();
            param = rowParams.getParam("pwindex");
            String portid = param.getValue();
            this.queryBindPath(slotid, portid, rowParams);
            this.queryPWInfo(slotid, portid, rowParams);
        }
    }

    private void queryPWInfo(String slotid, String trunckid, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_ATM_GET_TRUNKIMAEN_EX";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("slotid").setValue(slotid);
        operation.getInput().getPart("trunckid").setValue(trunckid);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            rowParam.addParam("imaenable", operation.getOutput(0).getPart("imaenable").getValue());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    private void queryBindPath(String inputslotid, String portid, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_ATM_GET_TRUNKMBR_EX";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("slotid").setValue(inputslotid);
        operation.getInput().getPart("trunckid").setValue(portid);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            Output[] outputs = operation.getOutput();
            for (int i = outputs.length - 1; i >= 0; --i) {
                int bounduppath;
                int boundportid;
                int boundslotid;
                int direction;
                int trunckid;
                int slotid = Integer.parseInt(outputs[i].getPart("slotid").getValue());
                if (slotid == -1 || (trunckid = Integer.parseInt(outputs[i].getPart("trunckid").getValue())) == -1 || (direction = Integer.parseInt(outputs[i].getPart("direction").getValue())) == -1 || (boundslotid = Integer.parseInt(outputs[i].getPart("boundslotid").getValue())) == -1 || (boundportid = Integer.parseInt(outputs[i].getPart("boundportid").getValue())) == -1 || (bounduppath = Integer.parseInt(outputs[i].getPart("bounduppath").getValue())) == -1) continue;
                ArrayList<Integer> linktable = TEQueryBindingPathBean.parserIntListParam(outputs[i].getPart("linktable").getValue(), "linktable", 16);
                TEQxTrunckMbr qxmbr = new TEQxTrunckMbr(slotid, trunckid, direction, boundslotid, boundportid, bounduppath, linktable);
                this.trunckMbrs.add(qxmbr);
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.trunckMbrs.size() > 0) {
            do {
                TEQxTrunckMbr head = this.trunckMbrs.get(0);
                this.trunckMbrs.remove(0);
                TETrunckMbr trunckMbr = this.joinTrunckMbr(this.trunckMbrs, head);
                RowParams newParams = trunckMbr.parserTrunckMbrToRowParams();
                int size = newParams.getParamCount();
                for (int i = 0; i < size; ++i) {
                    rowParam.addParam(newParams.getParam(i));
                }
            } while (this.trunckMbrs.size() != 0);
        }
    }

    public static ArrayList<Integer> parserIntListParam(String stringlist, String paramName, int radix) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (int i = 0; i < stringlist.length(); i += 4) {
            int intpara = 0;
            try {
                intpara = Integer.parseInt(stringlist.substring(i, i + 4), radix);
            }
            catch (NumberFormatException e) {
                intpara = -1;
            }
            if (intpara == -1) continue;
            intList.add(intpara);
        }
        return intList;
    }

    private TETrunckMbr joinTrunckMbr(ArrayList<TEQxTrunckMbr> qxTrunckList, TEQxTrunckMbr todoQxtrunckMbr) {
        TETrunckMbr trunckMbr = TETrunckMbrFactory.getInstance().createTrunckMbr(todoQxtrunckMbr, this.neid);
        Iterator<TEQxTrunckMbr> qxiter = qxTrunckList.iterator();
        while (qxiter.hasNext()) {
            TEQxTrunckMbr tempQxMbr = qxiter.next();
            if (todoQxtrunckMbr.equalsWithoutDirection(tempQxMbr)) {
                trunckMbr.direction = TEImamgrUtils.parserDirection(0);
                todoQxtrunckMbr.direction = 0;
                qxiter.remove();
                continue;
            }
            if (!todoQxtrunckMbr.equalsWithoutPath(tempQxMbr)) continue;
            if (trunckMbr.boundPaths.containsAll(tempQxMbr.linktable)) {
                if (trunckMbr.direction.equalsIgnoreCase(BIDIRECTION_STR) && !trunckMbr.direction.equalsIgnoreCase(TEImamgrUtils.parserDirection(tempQxMbr.direction))) {
                    trunckMbr.direction = BIDIRECTION_STR;
                }
            } else {
                trunckMbr.boundPaths.addAll(tempQxMbr.linktable);
            }
            qxiter.remove();
        }
        return trunckMbr;
    }
}

