/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ptn.atm.TEATMIDUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEQueryATMServiceBean
extends TENEExplorerBean {
    private static final int UNIUNI = 1;
    private static final int UNIsNNI = 2;
    private static final int NNI = 1;
    private static final int PWINDEX_INVALID = 0;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        if (Integer.parseInt(errorCode) != 0) {
            return;
        }
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        for (int i = rowParamses.length - 1; i >= 0; --i) {
            RowParams rowParams = rowParamses[i];
            if (null == rowParams || 0 == rowParams.getParamCount()) continue;
            String atmIndex = rowParams.getParam("atmIndex").getValue();
            this.queryServiceInfo(atmIndex, rowParams);
            this.queryServiceType(atmIndex, rowParams);
        }
        TEATMIDUtil.refreshATMIDCache(neid, rowParamses);
    }

    private void queryServiceInfo(String atmindex, RowParams rowParam) {
        if (rowParam.getParam("atmType").getValue().equals(String.valueOf(1))) {
            rowParam.addParam(new Param("pwIndex", String.valueOf(0)));
            return;
        }
        String cmdCode = "NSCMD_PTN_ATM_GET_SRVPINFO";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("atmindex").setValue(atmindex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            int size = operation.getOutputCount();
            for (int i = 0; i < size; ++i) {
                if (!"0".equals(operation.getOutput(i).getFault(0).getCode())) {
                    rowParam.addParam(new Param("pwIndex", String.valueOf(0)));
                    continue;
                }
                String porttype = operation.getOutput(i).getPart("porttype").getValue();
                if (Integer.parseInt(porttype) != 1) continue;
                String pwIndex = operation.getOutput(i).getPart("pwindex").getValue();
                rowParam.addParam(new Param("pwIndex", pwIndex));
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }

    private void queryServiceType(String atmindex, RowParams rowParam) {
        String cmdCode = "NSCMD_PTN_ATM_GET_VNNI";
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdCode);
        if (null == operation) {
            return;
        }
        operation.getInput().getPart("servIndex").setValue(atmindex);
        ArrayList<Operation> list = new ArrayList<Operation>();
        list.add(operation);
        int result = this.sendMessage(this.neid, list);
        if (result == 0) {
            if (operation.getOutput(0).getPart("servIndex").getValue() == null) {
                rowParam.getParam("atmType").setValue(String.valueOf(1));
            } else {
                rowParam.getParam("atmType").setValue(String.valueOf(2));
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
    }
}

