/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.atm.TrunckInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TEImamgrUtils {
    public static int parserIntParam(RowParams row, String paramName) {
        Param intparaParam = row.getParam(paramName);
        int intpara = 0;
        try {
            intpara = Integer.parseInt(intparaParam.getValue());
        }
        catch (NumberFormatException e) {
            intpara = -1;
        }
        return intpara;
    }

    public static ArrayList<Integer> parserIntListParam(RowParams row, String paramName, int radix) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        Param intparaParam = row.getParam(paramName);
        String stringlist = intparaParam.getValue();
        for (int i = 0; i < stringlist.length(); i += 4) {
            int intpara = 0;
            try {
                intpara = Integer.parseInt(stringlist.substring(i, i + 4), radix);
            }
            catch (NumberFormatException e) {
                intpara = -1;
            }
            if (intpara == -1) continue;
            intList.add(intpara);
        }
        return intList;
    }

    public static TrunckInfo getTrunckInfo(String trunckName) {
        TrunckInfo trunck = null;
        if (trunckName != null) {
            StringTokenizer st = new StringTokenizer(trunckName, "-");
            int i = 0;
            trunck = new TrunckInfo();
            while (st.hasMoreTokens()) {
                String modifier = st.nextToken();
                if (i == 0) {
                    try {
                        trunck.slotid = Integer.parseInt(modifier);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                if (i == 2) {
                    StringTokenizer trunckst = new StringTokenizer(modifier, "(");
                    if (trunckst.hasMoreElements()) {
                        try {
                            trunck.trunckid = Integer.parseInt(trunckst.nextToken());
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                ++i;
            }
        }
        return trunck;
    }

    public static String buildBoardDes(int neid, int slotid) {
        TEBoard teboard = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        if (teboard != null) {
            String boardInfo = slotid + "-" + teboard.getBoardName();
            return boardInfo;
        }
        return null;
    }

    public static List getQxTrunckID(int neid, int boardType) {
        List portid = TEConfigurationDataMgr.getInstance().getPortListFromPortType(neid, boardType, 64001);
        ArrayList<Integer> trunckIDs = new ArrayList<Integer>();
        for (int i = 0; i < portid.size(); ++i) {
            trunckIDs.add((Integer)portid.get(i) + 8192);
        }
        return trunckIDs;
    }

    public static String getTrunckName(int neid, int slotid, int trunckid) {
        TEBoard teboard = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        String portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, teboard.getBoardType(), trunckid);
        portname = TEImamgrUtils.buildBoardDes(neid, slotid) + "-" + portname;
        return portname;
    }

    public static String getPortName(int neid, int slotid, int portid) {
        TEBoard teboard = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        String portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, teboard.getBoardType(), portid);
        portname = TEImamgrUtils.buildBoardDes(neid, slotid) + "-" + portname;
        return portname;
    }

    public static String getOldPortName(int neid, int slotid, int portid) {
        TEBoard teboard = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, teboard.getBoardType(), portid);
        portname = TEImamgrUtils.buildBoardDes(neid, slotid) + "-" + portname;
        return portname;
    }

    public static String parserDirection(int direction) {
        switch (direction) {
            case 2: {
                return "UPLINK";
            }
            case 1: {
                return "DOWNLINK";
            }
        }
        return "BIDIRECTIONAL";
    }

    public static ArrayList getDiference(ArrayList<Integer> fisrtArray, ArrayList secondArray) {
        ArrayList<Integer> diference = new ArrayList<Integer>();
        for (int i = 0; i < fisrtArray.size(); ++i) {
            if (secondArray.contains(fisrtArray.get(i))) continue;
            diference.add(fisrtArray.get(i));
        }
        return diference;
    }

    public static ArrayList<Integer> parserIntegerList(String formularStr) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(formularStr, ",");
        while (st.hasMoreTokens()) {
            ArrayList<Integer> temp = TEImamgrUtils.parserLineIntList(st.nextToken());
            if (temp == null) continue;
            intList.addAll(temp);
        }
        return intList;
    }

    /*
     * Unable to fully structure code
     */
    public static String buildIntStrFromList(ArrayList<Integer> intlist) {
        intListStr = new StringBuffer();
        first = 0;
        second = 0;
        isNewRange = true;
        for (i = 0; i < intlist.size(); ++i) {
            if (!isNewRange) ** GOTO lbl19
            first = intlist.get(i);
            if (i != intlist.size() - 1) {
                if (intlist.get(i) != intlist.get(i + 1) - 1) {
                    second = first;
                    intListStr.append(first).append(",");
                    isNewRange = true;
                    continue;
                }
            } else {
                intListStr.append(first);
                break;
lbl19:
                // 1 sources

                if (i != intlist.size() - 1) {
                    if (intlist.get(i) != intlist.get(i + 1) - 1) {
                        second = intlist.get(i);
                        intListStr.append(first).append("-").append(second).append(",");
                        isNewRange = true;
                        continue;
                    }
                } else {
                    second = intlist.get(i);
                    intListStr.append(first).append("-").append(second);
                    break;
                }
            }
            isNewRange = false;
        }
        return intListStr.toString();
    }

    public static ArrayList<Integer> parserLineIntList(String formularStr) {
        ArrayList<Integer> inteList = new ArrayList<Integer>();
        if (formularStr.indexOf(45) < 0) {
            int firstInt = 0;
            try {
                firstInt = Integer.parseInt(formularStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
            inteList.add(firstInt);
            return inteList;
        }
        StringTokenizer st = new StringTokenizer(formularStr, "-");
        int firstInt = 0;
        try {
            firstInt = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            return null;
        }
        int secondInt = 0;
        try {
            secondInt = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (firstInt > secondInt) {
            return null;
        }
        for (int i = firstInt; i <= secondInt && firstInt >= 0; ++i) {
            inteList.add(i);
        }
        return inteList;
    }
}

