/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.atm;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class TEATMIDUtil {
    private static Hashtable<Integer, Integer> ATMID_CACHE = new Hashtable();
    private static List<Integer> atmIDList = new ArrayList<Integer>();

    public static synchronized void refreshATMIDCache(int neid, RowParams[] rowParamses) {
        atmIDList.clear();
        for (RowParams rowParams : rowParamses) {
            Param serviceIDPart = rowParams.getParam("atmId");
            if (serviceIDPart == null) continue;
            try {
                atmIDList.add(Integer.parseInt(serviceIDPart.getValue()));
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Refresh atm id cache failed beacause input error serviceid=" + serviceIDPart.getValue(), (Throwable)e);
                return;
            }
        }
        int atmID = 1;
        while (atmIDList.contains(atmID)) {
            ++atmID;
        }
        ATMID_CACHE.put(neid, atmID);
    }

    public static synchronized void addServiceID(int neid, int serviceID) {
        atmIDList.add(serviceID);
        int atmID = 1;
        while (atmIDList.contains(atmID)) {
            ++atmID;
        }
        ATMID_CACHE.put(neid, atmID);
    }

    public static int getMaxATMID(int neid) {
        if (ATMID_CACHE.containsKey(neid)) {
            return ATMID_CACHE.get(neid);
        }
        return -1;
    }

    public static boolean removeATMIDCache(int neID) {
        boolean isRemoved = false;
        if (ATMID_CACHE.contains(neID)) {
            ATMID_CACHE.remove(neID);
            isRemoved = true;
        } else {
            TELogFactory.getNormalLogger().info("The atm id list is not exist. neID->" + neID);
        }
        return isRemoved;
    }
}

