/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.apsmgr;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nemgr.ip.ptn.apsmgr.TEPWAPSInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TEQueryPWAPS
extends TECommonWriteLogBean {
    private Map<String, TEPWAPSInfo> indexApsMap = new HashMap<String, TEPWAPSInfo>();
    private Map<String, String> pwIndex2IDMap = new HashMap<String, String>();
    private Map<String, String> pwID2IndexMap = new HashMap<String, String>();
    private Map<String, String> carryIDMap = new HashMap<String, String>();
    public static final String NSCMD_ETHN_PWAPS_GET_APSEN = "NSCMD_ETHN_PWAPS_GET_APSEN";
    public static final String NSCMD_ETHN_PWAPS_GET_APSCFG = "NSCMD_ETHN_PWAPS_GET_APSCFG";
    public static final String NSCMD_ETHN_PWAPS_GET_STATE = "NSCMD_ETHN_PWAPS_GET_STATE";
    public static final String NSCMD_SERVICE_GET_EVNNI_EX = "NSCMD_SERVICE_GET_EVNNI_EX";
    public static final String PRO_TYPE_FBB = "2";
    public static final String APS_TYPE_FPS = "5";
    public static final String APS_TYPE_APS = "1";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        ArrayList<Operation> newOperList = new ArrayList<Operation>();
        Operation oper = (Operation)operationList.get(0);
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        Operation pwOper = (Operation)operationList.get(1);
        Param serviceIndexParam = this.inputData.getBussinessParams().getRowParams(0).getParam("serviceIndex");
        Operation evnniOper = null;
        if (operationList.size() > 2) {
            evnniOper = (Operation)operationList.get(2);
        }
        if (0 == errCode) {
            int i;
            int iLength = pwOper.getOutputCount();
            for (i = 0; i < iLength; ++i) {
                String pwID = pwOper.getOutput(i).getPartValue("pwID");
                String pwIndex = pwOper.getOutput(i).getPartValue("pwIndex");
                this.pwIndex2IDMap.put(pwIndex, pwID);
                this.pwID2IndexMap.put(pwID, pwIndex);
            }
            if (evnniOper != null) {
                iLength = evnniOper.getOutputCount();
                for (i = 0; i < iLength; ++i) {
                    String serviceIndex = evnniOper.getOutput(i).getPartValue("serviceIndex");
                    String carryid = evnniOper.getOutput(i).getPartValue("carrierID3");
                    this.carryIDMap.put(serviceIndex, carryid);
                }
            }
            iLength = oper.getOutputCount();
            for (i = 0; i < iLength; ++i) {
                String carryid;
                String apsid = oper.getOutput(i).getPartValue("apsid");
                TEPWAPSInfo pwaps = new TEPWAPSInfo(apsid);
                pwaps.setWorkpw(this.pwIndex2IDMap.get(oper.getOutput(i).getPartValue("workpw")));
                pwaps.setProtectpw(this.pwIndex2IDMap.get(oper.getOutput(i).getPartValue("protectpw")));
                pwaps.setProtype(oper.getOutput(i).getPartValue("protype"));
                if (pwaps.getProtype().equals(PRO_TYPE_FBB)) {
                    pwaps.setApstype(APS_TYPE_FPS);
                } else {
                    pwaps.setApstype(APS_TYPE_APS);
                }
                this.indexApsMap.put(pwaps.getApsid(), pwaps);
                if (!(serviceIndexParam == null || serviceIndexParam.getValue() == null || (carryid = this.carryIDMap.get(serviceIndexParam.getValue())) != null && oper.getOutput(i).getPartValue("workpw").equals(carryid))) {
                    this.indexApsMap.remove(pwaps.getApsid());
                    continue;
                }
                Operation apsenOper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETHN_PWAPS_GET_APSEN).clone();
                apsenOper.getInput().setPartValue("apsid", apsid);
                newOperList.add(apsenOper);
                Operation apscfgOper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETHN_PWAPS_GET_APSCFG).clone();
                apscfgOper.getInput().setPartValue("apsid", apsid);
                newOperList.add(apscfgOper);
                Operation stateOper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETHN_PWAPS_GET_STATE).clone();
                stateOper.getInput().setPartValue("apsid", apsid);
                newOperList.add(stateOper);
            }
            if (newOperList.size() == 0) {
                this.outputData.setBussinessParams(new BussinessParams());
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                return;
            }
            int retCode = TECommuNEMgr.getInstance().sendCommand((int)neid, newOperList, (int)this.getTimeOut(), (SubFunc)this.subfunc).retCode;
            if (0 == retCode) {
                this.setPWAPSAttr(newOperList);
                this.outputData.setBussinessParams(new BussinessParams());
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                this.outputData.getBussinessParams().setRowParams(this.getOutputRow(this.indexApsMap));
            }
        } else {
            this.outputData.setBussinessParams(new BussinessParams());
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return;
        }
    }

    private ArrayList getOutputRow(Map<String, TEPWAPSInfo> indexApsMap2) {
        ArrayList<RowParams> outputRowList = new ArrayList<RowParams>();
        for (Map.Entry<String, TEPWAPSInfo> entry : this.indexApsMap.entrySet()) {
            RowParams rowParams = new RowParams();
            rowParams.addParam("apsid", entry.getKey());
            rowParams.addParam("apstype", entry.getValue().getApstype());
            rowParams.addParam("protype", entry.getValue().getProtype());
            rowParams.addParam("workpw", entry.getValue().getWorkpw());
            rowParams.addParam("protectpw", entry.getValue().getProtectpw());
            rowParams.addParam("protectpwindex", this.pwID2IndexMap.get(entry.getValue().getProtectpw()));
            rowParams.addParam("isenable", entry.getValue().getIsenable());
            rowParams.addParam("switchmode", entry.getValue().getSwitchmode());
            rowParams.addParam("rvtmode", entry.getValue().getRvtmode());
            rowParams.addParam("wtrtime", entry.getValue().getWtrtime());
            rowParams.addParam("delaytime", entry.getValue().getDelaytime());
            rowParams.addParam("switchstatus", this.getEmptyIfNull(entry.getValue().getSwitchstatus()));
            rowParams.addParam("protocolstatus", this.getEmptyIfNull(entry.getValue().getProtocolstatus()));
            rowParams.addParam("workstatus", this.getEmptyIfNull(entry.getValue().getWorkstatus()));
            rowParams.addParam("protectstatus", this.getEmptyIfNull(entry.getValue().getProtectstatus()));
            outputRowList.add(rowParams);
        }
        return outputRowList;
    }

    private void setPWAPSAttr(ArrayList newOperList) {
        int jLength = newOperList.size();
        for (int j = 0; j < jLength; ++j) {
            Operation newOper = (Operation)newOperList.get(j);
            Output newOutput = newOper.getOutput(0);
            TEPWAPSInfo pwaps = this.indexApsMap.get(newOutput.getPartValue("apsid"));
            if (null == pwaps) continue;
            pwaps.setSwitchstatus("-");
            pwaps.setProtocolstatus("-");
            pwaps.setWorkstatus("-");
            pwaps.setProtectstatus("-");
            if (NSCMD_ETHN_PWAPS_GET_APSEN.equals(newOper.getName())) {
                pwaps.setIsenable(newOutput.getPartValue("isenable"));
                continue;
            }
            if (!NSCMD_ETHN_PWAPS_GET_APSCFG.equals(newOper.getName())) continue;
            pwaps.setProtype(newOutput.getPartValue("protype"));
            if (newOutput.getPartValue("protype").equals(PRO_TYPE_FBB)) {
                pwaps.setApstype(APS_TYPE_FPS);
            } else {
                pwaps.setApstype(APS_TYPE_APS);
            }
            pwaps.setSwitchmode(newOutput.getPartValue("switchmode"));
            pwaps.setRvtmode(newOutput.getPartValue("rvtmode"));
            pwaps.setWtrtime(newOutput.getPartValue("wtrtime"));
            pwaps.setDelaytime(newOutput.getPartValue("delaytime"));
        }
    }

    private String getEmptyIfNull(String s) {
        return s == null ? "" : s;
    }
}

