/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.apsmgr;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ptn.apsmgr.TEAPSInfo;
import com.huawei.nglct.nemgr.ip.ptn.apsmgr.TETunnelInfo;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;

public class TEQueryAPS
extends TECommonWriteLogBean {
    private Operation ipOper = null;
    private Operation greOper = null;
    private Operation mplsOper = null;
    private TIntObjectHashMap<TEAPSInfo> indexApsMap = new TIntObjectHashMap();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        Operation oper = (Operation)operationList.get(0);
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        if (0 == errCode) {
            TEAPSInfo apsInfo = null;
            RowParams rowParams = null;
            RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
            int m = rowParamses.length;
            for (int i = 0; i < m; ++i) {
                rowParams = rowParamses[i];
                if (rowParams.getRowErrorsCount() > 0) continue;
                apsInfo = new TEAPSInfo();
                apsInfo.apsId = Integer.valueOf(rowParams.getParam("apsid").getValue());
                apsInfo.wInTunnel = new TETunnelInfo(Long.valueOf(rowParams.getParam("winindex").getValue()));
                apsInfo.wOutTunnel = new TETunnelInfo(Long.valueOf(rowParams.getParam("woutindex").getValue()));
                apsInfo.pInTunnel = new TETunnelInfo(Long.valueOf(rowParams.getParam("pinindex").getValue()));
                apsInfo.pOutTunnel = new TETunnelInfo(Long.valueOf(rowParams.getParam("poutindex").getValue()));
                this.indexApsMap.put(i, (Object)apsInfo);
            }
            this.queryTunnelInfo();
        }
    }

    private void queryTunnelInfo() {
        if (this.indexApsMap.size() > 0) {
            this.ipOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_IP_TNL_GET_TUNNEL");
            this.greOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GRE_TNL_GET_TUNNEL");
            this.mplsOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_MPLS_GET_STATICTUNNEL");
            TEAPSInfo apsInfo = null;
            this.operationList.clear();
            TIntObjectIterator iter = this.indexApsMap.iterator();
            while (iter.hasNext()) {
                iter.advance();
                apsInfo = (TEAPSInfo)iter.value();
                this.addOperation(apsInfo.wInTunnel.tunnelIndex);
                this.addOperation(apsInfo.wOutTunnel.tunnelIndex);
                this.addOperation(apsInfo.pInTunnel.tunnelIndex);
                this.addOperation(apsInfo.pOutTunnel.tunnelIndex);
            }
            int errCode = this.sendMessage(this.neid);
            if (0 == errCode) {
                this.handleTunnelInfo();
            }
        }
    }

    private void addOperation(long tunnelIndex) {
        if (-1L != tunnelIndex) {
            this.ipOper.getInput().setPartValue("tunnelindex", String.valueOf(tunnelIndex));
            this.operationList.add(this.ipOper.clone());
            this.greOper.getInput().setPartValue("tunnelindex", String.valueOf(tunnelIndex));
            this.operationList.add(this.greOper.clone());
            this.mplsOper.getInput().setPartValue("tunnelindex", String.valueOf(tunnelIndex));
            this.operationList.add(this.mplsOper.clone());
        }
    }

    private void handleTunnelInfo() {
        int errCode = 0;
        String operName = null;
        Output output = null;
        Operation oper = null;
        int m = this.operationList.size();
        for (int i = 0; i < m; ++i) {
            long snkNode;
            int tunnelType;
            oper = (Operation)this.operationList.get(i);
            output = oper.getOutput(0);
            errCode = Integer.valueOf(output.getFault(0).getCode());
            if (0 != errCode) continue;
            operName = oper.getName();
            long tunnelIndex = Long.valueOf(output.getPartValue("tunnelindex"));
            int tunnelId = Integer.valueOf(output.getPartValue("tunnelid"));
            if ("NSCMD_CFG_IP_TNL_GET_TUNNEL".equals(operName)) {
                tunnelType = 3;
                snkNode = Long.valueOf(output.getPartValue("dstipaddr"));
                this.setAPSTunnelInfo(tunnelIndex, tunnelType, tunnelId, snkNode);
                continue;
            }
            if ("NSCMD_CFG_GRE_TNL_GET_TUNNEL".equals(operName)) {
                tunnelType = 4;
                snkNode = Long.valueOf(output.getPartValue("dstipaddr"));
                this.setAPSTunnelInfo(tunnelIndex, tunnelType, tunnelId, snkNode);
                continue;
            }
            if (!"NSCMD_CFG_MPLS_GET_STATICTUNNEL".equals(operName)) continue;
            tunnelType = 1;
            long srcNode = Long.valueOf(output.getPartValue("srcnode"));
            snkNode = Long.valueOf(output.getPartValue("snknode"));
            int tunnelDir = Integer.valueOf(output.getPartValue("direction"));
            this.setAPSTunnelInfo(tunnelIndex, tunnelType, tunnelId, IOStreamConvertor.replaceSpecialStr((String)output.getPartValue("name")), srcNode, snkNode, tunnelDir);
        }
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        int m2 = rowParamses.length;
        for (int i = 0; i < m2; ++i) {
            if (!this.indexApsMap.containsKey(i)) continue;
            ((TEAPSInfo)this.indexApsMap.get(i)).setParams(rowParamses[i]);
        }
    }

    private void setAPSTunnelInfo(long tunnelIndex, int tunnelType, int tunnelId, long snkNode) {
        this.setAPSTunnelInfo(tunnelIndex, tunnelType, tunnelId, "", 0L, snkNode, 0);
    }

    private void setAPSTunnelInfo(long tunnelIndex, int tunnelType, int tunnelId, String tunnelName, long srcNode, long snkNode, int direction) {
        TEAPSInfo apsInfo = null;
        TETunnelInfo tunnelInfo = null;
        ArrayList<TETunnelInfo> tunnelInfoList = new ArrayList<TETunnelInfo>();
        int m = this.indexApsMap.size();
        for (int i = 0; i < m; ++i) {
            apsInfo = (TEAPSInfo)this.indexApsMap.get(i);
            if (apsInfo.wInTunnel.tunnelIndex == tunnelIndex) {
                tunnelInfoList.add(apsInfo.wInTunnel);
            }
            if (apsInfo.wOutTunnel.tunnelIndex == tunnelIndex) {
                tunnelInfoList.add(apsInfo.wOutTunnel);
            }
            if (apsInfo.pInTunnel.tunnelIndex == tunnelIndex) {
                tunnelInfoList.add(apsInfo.pInTunnel);
            }
            if (apsInfo.pOutTunnel.tunnelIndex != tunnelIndex) continue;
            tunnelInfoList.add(apsInfo.pOutTunnel);
        }
        int n = tunnelInfoList.size();
        for (int j = 0; j < n; ++j) {
            tunnelInfo = (TETunnelInfo)tunnelInfoList.get(j);
            tunnelInfo.tunnelType = tunnelType;
            tunnelInfo.tunnelId = tunnelId;
            tunnelInfo.tunnelName = tunnelName;
            tunnelInfo.srcNode = srcNode;
            tunnelInfo.snkNode = snkNode;
            tunnelInfo.direction = direction;
        }
    }
}

