/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.bundleactivator;

import com.huawei.nglct.bundleactivator.PTNIPBundleRegCmd;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TEWNEMgrTaskDispatcher;
import com.huawei.nglct.nemgr.ip.ptn.TEPTNIPFileProvider;
import com.huawei.nglct.nemgr.ip.ptn.TEPTNIPInnerEventObserver;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.TEE2EErpsTask;
import com.huawei.nglct.nemgr.ip.ptn.e2e.lldp.TEE2ELldpTask;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.innerevent.delneevent.TEInnerDelNEEventCenter;
import com.huawei.nglct.util.innerevent.delneevent.TEInnerDelNEObserver;
import com.huawei.nglct.util.string.IFileRegisterer;
import com.huawei.nglct.util.string.TEFileRegisterer;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.xml.IFileProvider;
import gnu.trove.TIntArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class PTNIPBundleActivator
implements BundleActivator,
BundleListener,
IFileRegisterer {
    private TIntArrayList fbMapping = new TIntArrayList();
    private ServiceRegistration sr;

    public void start(BundleContext context) {
        context.registerService(IFileProvider.class.getName(), (Object)new TEPTNIPFileProvider(), null);
        try {
            this.fbMapping = TEFileRegisterer.registerFiles((Bundle)context.getBundle());
            this.sr = context.registerService(IFileRegisterer.class.getName(), (Object)this, null);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("PTNIPBundleActivator.start() fail!", (Throwable)e);
        }
        this.registerInnerEventObserver();
        Bundle commBundle = FrameworkUtil.getBundle(IFileProvider.class);
        if (commBundle.getState() == 32) {
            this.registerTask();
        }
    }

    public void bundleChanged(BundleEvent arg0) {
        Bundle bundle = (Bundle)arg0.getSource();
        if ("com.huawei.weblct.common".equals(bundle.getSymbolicName()) && bundle.getState() == 32) {
            this.registerTask();
        }
    }

    private void registerTask() {
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            PTNIPBundleRegCmd.regCmdCode();
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEE2EErpsTask.class);
            TEWNEMgrTaskDispatcher.getInstance().registerTask(TEE2ELldpTask.class);
        }
    }

    private void registerInnerEventObserver() {
        TEInnerDelNEEventCenter.getInstance().addObserver((TEInnerDelNEObserver)TEPTNIPInnerEventObserver.getInstance());
    }

    public void stop(BundleContext context) {
        this.sr.unregister();
    }

    public boolean containsResFile(String filePaht) {
        int hash = TEStringUtils.hashString((String)filePaht);
        return this.fbMapping.contains(hash);
    }
}

