 var winobj = getNeProperty(parent);
var COMMANDCONSTOBJ = {};
COMMANDCONSTOBJ.QUERYPROTOCAL_CMD = TECMDCODE_QUERY_IGMP_ENABLE;
COMMANDCONSTOBJ.QUERYPORTINFO_CMD = TECMDCODE_GET_IGMP_ENABLE;
COMMANDCONSTOBJ.MODIFY_CMD = TECMDCODE_SET_IGMP_ENABLE;
var QUERY_AVAILABLERES_CMD = TECMDCODE_IP_STATICIGMP_GET_VALIDRESOURCE;

var protocalTable = null;
var portTable = null;
var btnRightArr = new Object();

var PROTOCALTABLE_COLIDOBJ = {};
PROTOCALTABLE_COLIDOBJ.indexID = "indexID";
PROTOCALTABLE_COLIDOBJ.enableState = "enableState";
PROTOCALTABLE_COLIDOBJ.rtAgeTime = "rtAgeTime";
PROTOCALTABLE_COLIDOBJ.maxNRSPTime = "maxNRSPTime";
PROTOCALTABLE_COLIDOBJ.maxGrpNum = "maxGrpNum";
PROTOCALTABLE_COLIDOBJ.maxMemNum = "maxMemNum";
var PORTTABLE_COLIDOBJ = {};
PORTTABLE_COLIDOBJ.indexID = "indexID";


var RTAGETIME_CONST = {};
RTAGETIME_CONST.MAX = "120";
RTAGETIME_CONST.MIN = "1";
RTAGETIME_CONST.DEFAULT = "8";
var MAXNRSPTIME = {};
MAXNRSPTIME.MAX = "4"
MAXNRSPTIME.MIN = "1"
MAXNRSPTIME.DEFAULT = "3"
var MAXGROUPNUM = {};
MAXGROUPNUM.MAX = "4294967295"
MAXGROUPNUM.MIN = "0"
MAXGROUPNUM.DEFAULT = "4294967295"
var MAXMEMNUM = {};
MAXMEMNUM.MAX = "4294967295"
MAXMEMNUM.MIN = "0"
MAXMEMNUM.DEFAULT = "4294967295"

var ENABLESTATE_CONST = {};
ENABLESTATE_CONST.ENABLE = "1";
ENABLESTATE_CONST.DISABLE = "0";

var maxMemNumStr = "";
var rowSelected;
var EMPTY_RESULT = "38662";
var EMPTYRESULT = "42617";
var TIMEOUT = 131080;
var applybtnStatus = false;
var PARTSUCC = 1;
var FAIL = 2;
var SVL_VLAN = "65534";
var selectedRowID;
var MACMODE_SVL = "1";
var MIN_VLAN = "1";
var MAX_VLAN = "4094";
var uniPortArray = new Array();
var nniPortArray = new Array();
var UNI = "1";
var NNI = "2";
var PW = "1";
var QINQ = "4";
var INVALID_SUBSLOTID = 255;
var DISABLED = "0";
var ENABLED = "1";
var deleteRowArray = new Array();
var TRANSFER = "0";
var BPDUTRANS = "1";

var hasResized = false;
 
loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");

getResourse("../../res/snooping/snooping_" + SYSTEMCONF.getLanguage() + ".xml");

loadXMLdoc("../../conf/snooping/snoopingprotocaluptable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);
loadXMLdoc("../../conf/snooping/snoopingportleaveflagtable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);
loadXMLdoc("../../conf/snooping/portleavetable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);

/**
 * initialize the page;
 */
function initPage()
{
    initProtocalTable();
    initPortTable();
    initButton();
    doQueryProtocalData();
}
function tabSelectHandler()
{
    if(btnRightArr.queryBtn.right)
	  {
		    doQueryProtocalData();
	  } 
}
function doQueryProtocalData()
{
    if (!btnRightArr.queryBtn.right) 
    {
        return;
    }
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    var xmlData = createQueryProtocalXmlData();
    var url = "../../../../neExlorerServlet?sfid=" + COMMANDCONSTOBJ.QUERYPROTOCAL_CMD + "&nmUser=" + winobj["nmUser"];
    
    loadXMLdoc(url, "POST", true, queryProtocalHandler, null, "inputdata=" + xmlData);
}

function queryProtocalHandler(doc)
{
    var data = EncapsulateData(doc);
    var errCode = data.getSErrorCode();
    if (0 != errCode) 
    {
        var len = data.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (EMPTY_RESULT == data.errObj.rowErrors[i].error.code) 
            {
                data.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (PARTSUCC == errCode || FAIL == errCode)) 
        {
            data.errObj.s_error.code = 0;
        }
        else 
        {
            for (var i = 0; i < len; i++) 
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["querybutton"] + RESOURCE["protocolConfig"];
            }
            
            var errArr = [];
            errArr[0] = "operateObj";
            openErrPage("../../../../page/", data.getError(), errArr);
        }
    }
    
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        for (var len = data.getDataRowLength() - 1; len >= 0; len--) 
        {
            var row = data.rows[len];
	    	if(TRANSFER == row["tagFlag"].value || (null != row["bpduFlag"] && BPDUTRANS == row["bpduFlag"].value))
	    	{
	    		  data.rows.removeAt(len);
	    		  continue;
	    	}
            
            if (row["maxGrpNum"].value == MAXGROUPNUM.MAX) 
            {
                row["maxGrpNum"].value = RESOURCE["unlimited"];
            }
            if (row["maxMemNum"].value == MAXGROUPNUM.MAX) 
            {
                row["maxMemNum"].value = RESOURCE["unlimited"];
            }
        }
        
        protocalTable.clearTableData();
        createTableBody(protocalTable, protocalTableConf, data, RESOURCE);
        
        refreshCellEvent();
        if (0 != protocalTable.getDataRowLength()) 
        {
            $("addRowBtn").disabled = !btnRightArr.applyBtn.right;
            protocalTable.setRowSelect(0);
            var selectedRows = [0];
            protocalTableRowSelectHandler(selectedRows);
        }
    }
    $("queryBtn").disabled = false;
}

function refreshCellEvent()
{
    var enableStateCellEidt = null;
    for (var i = 0, rowCount = protocalTable.getDataRowLength(); i < rowCount; ++i) 
    {
        cell = protocalTable.getCell(i, PROTOCALTABLE_COLIDOBJ.rtAgeTime);
        if (cell) 
        {
            textCheck(cell.element.editElement.element, RTAGETIME_CONST.MIN, RTAGETIME_CONST.MAX);
        }
        cell = protocalTable.getCell(i, PROTOCALTABLE_COLIDOBJ.maxNRSPTime);
        if (cell) 
        {
            textCheck(cell.element.editElement.element, MAXNRSPTIME.MIN, MAXNRSPTIME.MAX);
        }
        
        function refreshCell(cellObj, bcolor, dhandler, iedit)
        {
            protocalTable.setCellIsEdit(cellObj, iedit);
        }
        function refreshCell_Num(cellObj, bcolor, dhandler, iedit)
        {
            protocalTable.setCellIsEdit(cellObj, iedit);
            if(iedit)
            {
            	cellObj.element.ondblclick = dhandler;
            }
            else
            {
            	cellObj.element.ondblclick = null;
            }
        }
        function enableStateChanged(row)
        {
            var rowindex;
            rowindex = this.parentNode.parentNode.rowIndex;
            
            var curEnableState;
            if (this.options) 
            {
                curEnableState = this.options[this.selectedIndex].value;
            }
            else 
            {
                curEnableState = protocalTable.getCellCurrentValue(rowindex, PROTOCALTABLE_COLIDOBJ.enableState, "enableState")
            }
            
            var rtAgeTimeCell = protocalTable.getCell(rowindex, PROTOCALTABLE_COLIDOBJ.rtAgeTime);
            var maxNRSPTimeCell = protocalTable.getCell(rowindex, PROTOCALTABLE_COLIDOBJ.maxNRSPTime);
            var maxGrpNumCell = protocalTable.getCell(rowindex, PROTOCALTABLE_COLIDOBJ.maxGrpNum);
            var maxMemNumCell = protocalTable.getCell(rowindex, PROTOCALTABLE_COLIDOBJ.maxMemNum);
            var bgcolor = null;
            var dbclickhandler = null;
            var numhandler = null;
            var isedit = null;
            if (ENABLESTATE_CONST.ENABLE == curEnableState) 
            {
                bgcolor = "#ffffff";
                dbclickhandler = cellondbclick;
                isedit = 1;
                refreshCell_Num(maxGrpNumCell, bgcolor, dblclick_maxGrpNum, isedit);
            	refreshCell_Num(maxMemNumCell, bgcolor, dblclick_maxMemNum, isedit);
            }
            else 
            {
                bgcolor = "#e3e8e6";
                dbclickhandler = null;
                isedit = 0;
                refreshCell_Num(maxGrpNumCell, bgcolor, null, isedit);
            	refreshCell_Num(maxMemNumCell, bgcolor, null, isedit);
            }
            refreshCell(rtAgeTimeCell, bgcolor, dbclickhandler, isedit);
            refreshCell(maxNRSPTimeCell, bgcolor, dbclickhandler, isedit);
        }
        
        enableStateCellEidt = protocalTable.getCellEdit(i, PROTOCALTABLE_COLIDOBJ.enableState);
        enableStateCellEidt.element["onchange"] = enableStateChanged;
        function enableStateChanged_Init(row)
        {
            var rowindex;
            if (!arguments.length) 
            {
                rowindex = this.parentNode.parentNode.rowIndex;
            }
            else 
            {
                rowindex = row;
            }
            var curEnableState;
            if (this.options) 
            {
                curEnableState = this.options[this.selectedIndex].value;
            }
            else 
            {
                curEnableState = protocalTable.getCellCurrentValue(rowindex, PROTOCALTABLE_COLIDOBJ.enableState, "enableState")
            }
            
            var rtAgeTimeCell = protocalTable.getCell(rowindex, PROTOCALTABLE_COLIDOBJ.rtAgeTime);
            var maxNRSPTimeCell = protocalTable.getCell(rowindex, PROTOCALTABLE_COLIDOBJ.maxNRSPTime);
            var maxGrpNumCell = protocalTable.getCell(rowindex, PROTOCALTABLE_COLIDOBJ.maxGrpNum);
            var maxMemNumCell = protocalTable.getCell(rowindex, PROTOCALTABLE_COLIDOBJ.maxMemNum);
            var bgcolor = null;
            var dbclickhandler = null;
            var isedit = null;
            if (ENABLESTATE_CONST.ENABLE == curEnableState) 
            {
                bgcolor = "#ffffff";
                dbclickhandler = cellondbclick;
                isedit = 1;
                refreshCell_Num(maxGrpNumCell, bgcolor, dblclick_maxGrpNum, isedit);
            	refreshCell_Num(maxMemNumCell, bgcolor, dblclick_maxMemNum, isedit);
            }
            else 
            {
                bgcolor = "#e3e8e6";
                dbclickhandler = null;
                isedit = 0;
                refreshCell_Num(maxGrpNumCell, bgcolor, null, isedit);
            	refreshCell_Num(maxMemNumCell, bgcolor, null, isedit);
            }
            refreshCell(rtAgeTimeCell, bgcolor, dbclickhandler, isedit);
            refreshCell(maxNRSPTimeCell, bgcolor, dbclickhandler, isedit);
        }
        enableStateChanged_Init(i);
    }
}

function dblclick_maxGrpNum()
{
    rowSelected = this.parentNode.rowIndex;
    maxMemNumStr = protocalTable.getCellStoreValue(rowSelected, "maxGrpNum", "maxGrpNum");
    protocalTable.element.datarows[rowSelected].element.modify = true;
    this.modify = true;
    var cell = protocalTable.getCell(rowSelected, "maxMemNum");
    cell.element.modify = true;
    applybtnStatus = btnRightArr.applyBtn.right;
    
    if (this.isEdit) 
    {
        xshowModalDialog("maxGrpNum.html", RESOURCE["maxGrpNum"], 520, 170, "../../../../images/");
    }
}

function dblclick_maxMemNum()
{
    rowSelected = this.parentNode.rowIndex;
    maxMemNumStr = protocalTable.getCellStoreValue(rowSelected, "maxMemNum", "maxMemNum");
    protocalTable.element.datarows[rowSelected].element.modify = true;
    this.modify = true;
    var cell = protocalTable.getCell(rowSelected, "maxGrpNum");
    cell.element.modify = true;
    applybtnStatus = btnRightArr.applyBtn.right;
    
    if (this.isEdit) 
    {
        xshowModalDialog("maxMemNum.html", RESOURCE["maxMemNum"], 550, 170, "../../../../images/");
    }
}

function refreshTable(cellValue, cellName)
{
    var cell = protocalTable.getCell(rowSelected, cellName);
    protocalTable.setCellValue(cell, cellName, cellValue);
    protocalTable.setAtomValue(cell.element.showElement, cellValue);
    $("applyBtn").disabled = !btnRightArr.applyBtn.right;
}


function createQueryProtocalXmlData()
{
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    var rowParams = null;
    var param = null;
    
    rowParams = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", winobj["neid"]);
    rowParams.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "indexID");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

function initButton()
{
    $("queryBtn").value = RESOURCE["querybutton"];
    $("addRowBtn").value = RESOURCE["addRowBtn"];
    $("deleteRowBtn").value = RESOURCE["deleteRowBtn"];
    $("applyBtn").value = RESOURCE["applybutton"];
    
    btnRightArr.queryBtn = new BtnRightObj("queryBtn", COMMANDCONSTOBJ.QUERYPORTINFO_CMD);
    btnRightArr.applyBtn = new BtnRightObj("applyBtn", COMMANDCONSTOBJ.MODIFY_CMD);
    
    checkRights();
}

function checkRights()
{
    var xmlData = createCheckRightXmlData();
    var checkUrl = "../../../../securityServlet?neID=" + winobj["neid"] + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(checkUrl, "POST", false, checkRightsHandler, null, "inputdata=" + xmlData);
}

function checkRightsHandler(doc)
{
    var data = EncapsulateData(doc);
    var right = null;
    for (var i = 0, rowLength = data.getDataRowLength(); i < rowLength; ++i) 
    {
        right = ("1" == data.getDataRowParam(i, "right"));
        
        btnRightArr[data.getDataRowParam(i, "btnId")].right = right;
    }
    
    updataButtonState();
}

function updataButtonState()
{
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    $("applyBtn").disabled = !btnRightArr.applyBtn.right;
}

function createCheckRightXmlData()
{
    var root = new inputxml("datainterface");
    
    var bussinessNode = new tagElement("bussiness-params");
    var rowParams = null;
    var param = null;
    
    for (var oneRight in btnRightArr) 
    {
        rowParams = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "btnId");
        param.setAttribute("value", btnRightArr[oneRight].btnID);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "sfid");
        param.setAttribute("value", btnRightArr[oneRight].sfid);
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
    
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}


/**
 * initialize protocal table;
 */
function initProtocalTable()
{
    protocalTable = new SortTable();
    protocalTable.head.setAttribute("id", "htmlTable_STHead_protocolmgr");
    protocalTable.body.setAttribute("id", "htmlTable_STBody_protocolmgr");
    
    protocalTable.setImage("../../../../images/");
    
    protocalTable.setOnRowSelectHandler(protocalTableRowSelectHandler);
    
    protocalTable.setOnCellEditHandler(protocalTableCellEditHandler);
    
    protocalTableConf = window.tableconf[0];
    
    protocalTable.isUsedForSelectList = true;
    createTableHead(protocalTable, protocalTableConf);
    
    document.getElementById("protocalTableComponent").appendChild(protocalTable.getTable());
    
    protocalTable.setBodyHeight(getComponetHeight($("protocalTableComponent"), 250) + "px");
    
    $("protocalTableComponent").oncontextmenu = popupMenuHandler;
}

/**
 * initialize portTable;
 */
function initPortTable()
{
    portTable = new SortTable();
    portTable.head.setAttribute("id", "htmlTable_STHead_protocolmgr1");
    portTable.body.setAttribute("id", "htmlTable_STBody_protocolmgr1");
    
    portTable.setImage("../../../../images/");
    
    portTable.setOnCellEditHandler(portTableCellEditHandler);
    portTable.setOnRowSelectHandler(portTableRowSelected);
    
    portTableConf = window.tableconf[1];
    
    portTable.isUsedForSelectList = true;
    createTableHead(portTable, portTableConf);
    
    document.getElementById("portTableComponent").appendChild(portTable.getTable());
    
    portTable.setBodyHeight("130px");
    
    adjustTableLayout(portTable, portTableConf, 0);
    
    $("portTableComponent").oncontextmenu = popupMenuHandler;
}

/**
 *         
 */
function portTableCellEditHandler(params)
{
    $("applyBtn").disabled = !btnRightArr.applyBtn.right;
    applybtnStatus = btnRightArr.applyBtn.right;
  	if (params.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
			var editRow = params.rowindex;
			var colid = params.colid;
			
			if (colid == "portID")				
			{
				var portType = portTable.getCellStoreValue(editRow, "portType", "portType");
				var cell = portTable.getCellEdit(editRow,"portID");
                var portArray;
                if (UNI == portType)
                {	  	  
  	                cell.clearOptions();
  	                var len = uniPortArray.length
  	                for (var i = 0; i < len; i++)
  	                {
  	  	                portArray = uniPortArray[i].split(":");
  	  	                cell.addOption(portArray[0], portArray[1]);
  	                }
  	                if (0 < len)
  	                {
  	  	                portArray = uniPortArray[0].split(":");
  	  	                portTable.getCellShow(editRow,"portID").setValue(portArray[0]);
  	  	                portTable.setCellValue(portTable.getCell(editRow,"portID"),"portID",portArray[1]);
  	                }	
  	                else
  	                {	  	  	  
  	  	                portTable.getCellShow(editRow,"portID").setValue("");
  	  	                portTable.setCellValue(portTable.getCell(editRow,"portID"),"portID","");
  	                } 	  	  
                 }
                 else
                 {
  	                 cell.clearOptions();
  	                 var len = nniPortArray.length
  	                 for (var i = 0; i < len; i++)
  	                 {
  	  	                 portArray = nniPortArray[i].split(":");
  	  	                 cell.addOption(portArray[0], portArray[1]);
  	                 }	
  	                 if (0 < len)
  	                 {
  	  	                 portArray = nniPortArray[0].split(":");
  	  	                 portTable.getCellShow(editRow,"portID").setValue(portArray[0]);
  	  	                 portTable.setCellValue(portTable.getCell(editRow,"portID"),"portID",portArray[1]);
  	                 }	
  	                 else
  	                 {	  	  	  
  	  	                 portTable.getCellShow(editRow,"portID").setValue("");
  	  	                 portTable.setCellValue(portTable.getCell(editRow,"portID"),"portID","");
  	                 } 	    	  	  
                 }
			}
	}	
}

function portTableRowSelected(rows)
{
    if (0 == rows.length) 
    {
        $("deleteRowBtn").disabled = true;
    }
    else 
    {
        $("deleteRowBtn").disabled = !btnRightArr.applyBtn.right;
    }
}

/**
 *                               
 * rows:       
 * TODO
 */
var currentSelectedRowID = -1;
function protocalTableRowSelectHandler(rows)
{
    if (0 == rows.length) 
    {
        portTable.clearTableData();
        return;
    }
    
    selectedRowID = rows[0];
    if(selectedRowID == currentSelectedRowID){return;}
    currentSelectedRowID = selectedRowID;
    queryPortInfo();
}

function queryPortInfo()
{
    uniPortArray.length = 0;
    nniPortArray.length = 0;
    deleteRowArray.length = 0;
    
    $("applyBtn").disabled = true;
    $("queryBtn").disabled = true;
    var protocalIndexID = protocalTable.getCellCurrentValue(selectedRowID, PROTOCALTABLE_COLIDOBJ.indexID, "indexID");
    var xmlData = createQueryPortInfoXmlData(protocalIndexID);
    var url = "../../../../neExlorerServlet?sfid=" + COMMANDCONSTOBJ.QUERYPORTINFO_CMD + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, queryPortInfoHandler, null, "inputdata=" + xmlData);
}

function queryPortInfoHandler(doc)
{
    var data = EncapsulateData(doc);
    portTable.clearTableData();
    
    var servicID = protocalTable.getCellCurrentValue(selectedRowID, "serviceID", "serviceID");
    
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        for (var len = data.getDataRowLength() - 1; len >= 0; len--) 
        {
            var row = data.rows[len];
            
            if (DISABLED == row["quickLeaveEnableState"].value) 
            {
                data.rows.removeAt(len);
                return;
            }
            
            if (SVL_VLAN == row["vlanID"].value) 
            {
                row["vlanID"].value = "-";
            }
            
            var ptag = new ParamTag();
            ptag.value = servicID;
            row["serviceID"] = ptag;
        }
        createTableBody(portTable, portTableConf, data, RESOURCE);
    }
    
    if (!portTable.element.colsArray.selectedId) 
    {
        portTable.element.colsArray.selectedId = "serviceID";
        portTable.element.colsArray.imgflag = 1;
    }
    
    var td = portTable.element.headRow.element.cols[portTable.element.colsArray.selectedId].element;
    portTable.sortRows(td, portTable.element.colsArray.imgflag);
    
    $("queryBtn").disabled = false;
    $("applyBtn").disabled = !applybtnStatus;
}

function createQueryPortInfoXmlData(protocalIndexID)
{
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    var rowParams = null;
    var param = null;
    
    rowParams = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", winobj["neid"]);
    rowParams.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "indexID");
    param.setAttribute("value", protocalIndexID);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vlanID");
    param.setAttribute("value", "65535");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portType");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portID");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
    
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

/**
 *           
 */
function protocalTableCellEditHandler(params)
{
    $("applyBtn").disabled = !btnRightArr.applyBtn.right;
    applybtnStatus = btnRightArr.applyBtn.right;
}

/**
 *        
 * @param btnId       ID  sfid             ID
 * @return  
 */
function BtnRightObj(btnId, sfid)
{
    if (null != btnId) 
    {
        this.btnID = btnId;
    }
    else 
    {
        this.btnID = "";
    }
    
    if (isNaN(parseInt(sfid))) 
    {
        this.sfid = -1;
    }
    else 
    {
        this.sfid = sfid;
    }
    
    this.right = true;
}

function doApply()
{
    var xmlData = createModifyXmlData();
    
    if (!xmlData) 
    {
        return;
    }
    $("applyBtn").disabled = true;
    $("queryBtn").disabled = true;
    
    var url = "../../../../neExlorerServlet?sfid=" + COMMANDCONSTOBJ.MODIFY_CMD + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", true, modifyHandler, null, "inputdata=" + xmlData);
}

function modifyHandler(doc)
{
    updataButtonState();
    var dataInterface = EncapsulateData(doc);
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    if (0 != dataInterface.getSErrorCode()) 
    {
        $("applyBtn").disabled = !btnRightArr.applyBtn.right;
        var size = dataInterface.getBErrLength();
        for (var i = 0; i < size; i++) 
        {
            var tempObj = dataInterface.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["setPortParam"];
        }
        
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../page/", dataInterface.getError(), errArr);
    }
    else 
    {
        applybtnStatus = false;
    }
    
    refreshTableState(protocalTable, protocalTableConf, dataInterface);
    queryPortInfo();
}

function createModifyXmlData()
{
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    var rowParams = null; //new tagElement("row-params");
    var param = null;
    var colid = null;
    var key = null;
    var colkeyarray = null;
    var cellModifyFlag = false;
    for (var row = 0, rowCount = protocalTable.getDataRowLength(); row < rowCount; ++row) 
    {
        if (!protocalTable.getModify(row)) 
        {
            continue;
        }
        rowParams = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winobj["neid"]);
        rowParams.appendChild(param);
        var indexID = protocalTable.getCellCurrentValue(row, "indexID", "indexID");
        param = new tagElement("param");
        param.setAttribute("name", "indexID");
        param.setAttribute("value", indexID);
        rowParams.appendChild(param);
        
        for (var colindex = 0, collen = protocalTable.getColumnCount(); colindex < collen; colindex++) 
        {
            colid = protocalTableConf.getColId(colindex);
            cellModifyFlag = protocalTable.getCellModify(row, colid);
            if (!cellModifyFlag) 
            {
                continue;
            }
            var tmpColID;
            if (PROTOCALTABLE_COLIDOBJ.maxGrpNum == colid) 
            {
                tmpColID = PROTOCALTABLE_COLIDOBJ.maxMemNum;
            }
            else if (PROTOCALTABLE_COLIDOBJ.maxMemNum == colid) 
            {
                tmpColID = PROTOCALTABLE_COLIDOBJ.maxGrpNum;
            }
            var tmpFlag
            if (tmpColID) 
            {
                tmpFlag = protocalTable.getCellModify(row, tmpColID);
                if (tmpFlag || cellModifyFlag) 
                {
                    cellModifyFlag = true;
                }
            }
            if (!cellModifyFlag) 
            {
                continue;
            }
            colkeyarray = protocalTableConf.getColKeyArray(colindex);
            
            for (var keyindex = 0, keylen = colkeyarray.length; keyindex < keylen; keyindex++) 
            {
                param = new tagElement("param");
                
                key = colkeyarray[keyindex].name;
                
                param.setAttribute("name", key);
                var cellValue = protocalTable.getCellStoreValue(row, colid, key);
                if (RESOURCE["unlimited"] == cellValue) 
                {
                    cellValue = MAXGROUPNUM.MAX;
                }
                param.setAttribute("value", cellValue);
                
                param.setAttribute("modifyFlag", cellModifyFlag);
                
                rowParams.appendChild(param);
            }
        }
        bussinessNode.appendChild(rowParams);
    }
    
    for (var rowCount = portTable.getDataRowLength() - 1; rowCount >= 0; rowCount--) 
    {
        if (0 == portTable.getCellElement(rowCount, "portID").isEdit) 
        {
            continue;
        }
        rowParams = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winobj["neid"]);
        rowParams.appendChild(param);
        
        var indexID = protocalTable.getCellCurrentValue(selectedRowID, "indexID", "indexID");
        param = new tagElement("param");
        param.setAttribute("name", "indexID");
        param.setAttribute("value", indexID);
        rowParams.appendChild(param);
        
        var vlanID = portTable.getCellCurrentValue(rowCount, "vlanID", "vlanID");
        if ("-" == vlanID) 
        {
            vlanID = SVL_VLAN;
        }
        param = new tagElement("param");
        param.setAttribute("name", "vlanID");
        param.setAttribute("value", vlanID);
        rowParams.appendChild(param);
        
        var portType = portTable.getCellStoreValue(rowCount, "portType", "portType");
        param = new tagElement("param");
        param.setAttribute("name", "portType");
        param.setAttribute("value", portType);
        rowParams.appendChild(param);
        
        var portID = portTable.getCellStoreValue(rowCount, "portID", "portID");
        if ("" == portID) 
        {
            alert(RESOURCE["noport"]);
            return;
        }
        param = new tagElement("param");
        param.setAttribute("name", "portID");
        param.setAttribute("value", portID);
        rowParams.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "quickLeaveEnableState");
        param.setAttribute("value", ENABLED);
        rowParams.appendChild(param);
        
        var portFullName = portTable.getCellShow(rowCount, "portID").element.innerText;
        param = new tagElement("param");
        param.setAttribute("name", "portFullName");
        param.setAttribute("value", portFullName);
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
    
    for (var colindex = 0, collen = deleteRowArray.length; colindex < collen; colindex++) 
    {
        rowParams = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winobj["neid"]);
        rowParams.appendChild(param);
        
        var indexID = protocalTable.getCellCurrentValue(selectedRowID, "indexID", "indexID");
        param = new tagElement("param");
        param.setAttribute("name", "indexID");
        param.setAttribute("value", indexID);
        rowParams.appendChild(param);
        
        var vlanID = deleteRowArray[colindex][0];
        if ("-" == vlanID) 
        {
            vlanID = SVL_VLAN;
        }
        param = new tagElement("param");
        param.setAttribute("name", "vlanID");
        param.setAttribute("value", vlanID);
        rowParams.appendChild(param);
        
        var portType = deleteRowArray[colindex][1];
        param = new tagElement("param");
        param.setAttribute("name", "portType");
        param.setAttribute("value", portType);
        rowParams.appendChild(param);
        var portID = deleteRowArray[colindex][2];
        param = new tagElement("param");
        param.setAttribute("name", "portID");
        param.setAttribute("value", portID);
        rowParams.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "quickLeaveEnableState");
        param.setAttribute("value", DISABLED);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portFullName");
        param.setAttribute("value", deleteRowArray[colindex][3]);
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
    
    if (!bussinessNode.childNodes.length) 
    {
        return null;
    }
    
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

function convertMsg(res, obj, key)
{

    if ("function" == (typeof obj)) 
    {
        return obj(key);
    }
    else //       
     {
        if (null == obj) 
        {
            return key;
        }
        var resValue = obj[key];
        if (null == resValue) 
        {
            resValue = "/";
        }
        return resValue;
    }
}

function addRow()
{
    if (0 == uniPortArray.length && 0 == nniPortArray.length) 
    {
        queryAvailablePortRes();
    }
    
    var serviceID = protocalTable.getCellCurrentValue(selectedRowID, "serviceID", "serviceID");
    
    var rowData = new Array(serviceID, "1", "1", "", "");
    constructRow(portTable, window.tableconf[2], rowData);
    
    handlePortTable();
    $("applyBtn").disabled = !btnRightArr.applyBtn.right;
    
    if (!portTable.element.colsArray.selectedId) 
    {
        portTable.element.colsArray.selectedId = "serviceID";
        portTable.element.colsArray.imgflag = 1;
    }
    
    var td = portTable.element.headRow.element.cols[portTable.element.colsArray.selectedId].element;
    portTable.sortRows(td, portTable.element.colsArray.imgflag);

	var needResize = parseInt(portTable.bodyPack.offsetWidth)
				- parseInt(portTable.bodyPack.clientWidth) >0;
				
	if(!hasResized && needResize)
	{
		adjustTableLayout(portTable, portTableConf, 0);
		hasResized=true;
	}
	

	


}

function handlePortTable()
{
    var lastRwoID = portTable.getDataRowLength() - 1;
    var macMode = protocalTable.getCellCurrentValue(selectedRowID, "macMode", "macMode");
    
    var cell = portTable.getCellElement(lastRwoID, "vlanID");
    if (MACMODE_SVL == macMode) 
    {
        cell.showElement.setValue("-");
        portTable.setCellValue(portTable.getCell(lastRwoID, "vlanID"), "vlanID", "-");
        protocalTable.setCellIsEdit(cell, 0);
    }
    else 
    {
        textCheck(cell.editElement.element, MIN_VLAN, MAX_VLAN);
    }
    
    cell = portTable.getCellElement(lastRwoID, "portType");
    cell.editElement.element["onchange"] = changePortType;
    
    var portidCell = portTable.getCellEdit(lastRwoID, "portID");
    var portArray;
    portidCell.length = 0;
    var len = uniPortArray.length
    for (var i = 0; i < len; i++) 
    {
        portArray = uniPortArray[i].split(":");
        portidCell.addOption(portArray[0], portArray[1]);
    }
    if (0 < len) 
    {
        portArray = uniPortArray[0].split(":");
        portTable.getCellShow(lastRwoID, "portID").setValue(portArray[0]);
        portTable.setCellValue(portTable.getCell(lastRwoID, "portID"), "portID", portArray[1]);
    }
}

function changePortType()
{
    var rowid = this.parentNode.parentNode.rowIndex;
    var cell = portTable.getCellEdit(rowid, "portID");
    var portArray;
    if (UNI == this.value) 
    {
        cell.clearOptions();
        var len = uniPortArray.length
        for (var i = 0; i < len; i++) 
        {
            portArray = uniPortArray[i].split(":");
            cell.addOption(portArray[0], portArray[1]);
        }
        if (0 < len) 
        {
            portArray = uniPortArray[0].split(":");
            portTable.getCellShow(rowid, "portID").setValue(portArray[0]);
            portTable.setCellValue(portTable.getCell(rowid, "portID"), "portID", portArray[1]);
        }
        else 
        {
            portTable.getCellShow(rowid, "portID").setValue("");
            portTable.setCellValue(portTable.getCell(rowid, "portID"), "portID", "");
        }
    }
    else 
    {
        cell.clearOptions();
        var len = nniPortArray.length
        for (var i = 0; i < len; i++) 
        {
            portArray = nniPortArray[i].split(":");
            cell.addOption(portArray[0], portArray[1]);
        }
        if (0 < len) 
        {
            portArray = nniPortArray[0].split(":");
            portTable.getCellShow(rowid, "portID").setValue(portArray[0]);
            portTable.setCellValue(portTable.getCell(rowid, "portID"), "portID", portArray[1]);
        }
        else 
        {
            portTable.getCellShow(rowid, "portID").setValue("");
            portTable.setCellValue(portTable.getCell(rowid, "portID"), "portID", "");
        }
    }
}

function queryAvailablePortRes()
{
    var xmlInfo = createQueryAvailableResXmlInfo();
    var url = "../../../../neExlorerServlet?sfid=" + QUERY_AVAILABLERES_CMD + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, queryAvailablePortResHandler, null, "inputdata=" + xmlInfo);
}

function createQueryAvailableResXmlInfo()
{
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    var rowParams = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", winobj["neid"]);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "servType");
    param.setAttribute("value", "2");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "servIndex");
    param.setAttribute("value", protocalTable.getCellCurrentValue(selectedRowID, PROTOCALTABLE_COLIDOBJ.indexID, "indexID"));
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vuniId");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vnniId");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

function queryAvailablePortResHandler(doc)
{
    var datainterface = EncapsulateData(doc);
    for (var i = 0, rCount = datainterface.getDataRowLength(); i < rCount; ++i) 
    {
        var interfaceName = "";
        var interfaceID = datainterface.getDataRowParam(i, "infID");
        if (UNI == datainterface.getDataRowParam(i, "infType")) 
        {
            interfaceName = datainterface.getDataRowParam(i, "slotid") + "-" +
            datainterface.getDataRowParam(i, "boardTypeName") +
            "-";
            
            var subslotid = datainterface.getDataRowParam(i, "subslotid");
            if (INVALID_SUBSLOTID != subslotid) 
            {
                interfaceName += subslotid + "-" +
                datainterface.getDataRowParam(i, "subBoardTypeName") +
                "-";
            }
            
            interfaceName += datainterface.getDataRowParam(i, "portName") +
            datainterface.getDataRowParam(i, "tagIds") +
            ":" +
            interfaceID;
            
            uniPortArray.push(interfaceName);
        }
        else 
        {
            interfaceID = datainterface.getDataRowParam(i, "vnniId");
            if (PW == datainterface.getDataRowParam(i, "carrierType")) 
            {
                interfaceName = "PW-" + datainterface.getDataRowParam(i, "pwID") +
                ":" +
                interfaceID;
            }
            else if (QINQ == datainterface.getDataRowParam(i, "carrierType")) 
            {
                interfaceName = "QinQ-" + datainterface.getDataRowParam(i, "portID") +
                ":" +
                interfaceID;
            }
            else 
            {
                interfaceName = datainterface.getDataRowParam(i, "slotid") + "-" +
                datainterface.getDataRowParam(i, "boardTypeName") +
                "-";
                
                
                var subslotid = datainterface.getDataRowParam(i, "subslotid");
                if (INVALID_SUBSLOTID != subslotid) 
                {
                    interfaceName += subslotid + "-" +
                    datainterface.getDataRowParam(i, "subBoardTypeName") +
                    "-";
                }
                
                interfaceName += datainterface.getDataRowParam(i, "portName") +
                ":" +
                interfaceID;
            }
            
            nniPortArray.push(interfaceName);
        }
    }
}

function constructRow(st, tc, defaultVal)
{
    if (st.element.isAppendEmptyTr) 
    {
        var tBody = st.bodyPack.firstChild.lastChild;
        tBody.removeChild(tBody.firstChild);
        st.element.isAppendEmptyTr = false;
    }
    var row = st.createRow();
    var colnum = tc.colArray.length;
    var val;
    
    if (st.editdom == null) 
    {
        st.editdom = new Array();
    }
    
    for (var j = 0; j < colnum; j++) 
    {
        var colid = tc.getColId(j);
        var coledit = tc.getIsEdit(j);
        var cellwidth = tc.getColWidth(j);
        cell = st.createCell(cellwidth);
        if (cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%") 
        {
            cell.element.style.display = "none";
        }
        atom = st.createAtom("span");
        
        var conv = tc.getColKeyArray(j)[0].getConvert();
        if (conv) 
        {
            val = convertMsg(RESOURCE, eval(conv), defaultVal[j]);
            st.setCellValue(cell, colid, defaultVal[j]);
        }
        else 
        {
            val = defaultVal[j];
            st.setCellValue(cell, colid, val);
        }
        
        atom.setValue(val);
        
        st.setCellIsEdit(cell, coledit);
        st.addCellShow(cell, atom);
        st.addCell(row, colid, cell);
        
        if (coledit == 1) 
        {
            var editType = tc.getColEditType(j);
            atom = st.createAtom(editType);
            atom.element.onblur = cellonblur;
            
            if (editType == "select") 
            {
                var ops = tc.getColEditOptions(j);
                if (ops.length > 0) 
                {
                    for (var k = 0; k < ops.length; k++) 
                    {
                        atom.addOption(ops[k].getName(), ops[k].getValue());
                    }
                }
            }
            
            st.addCellEdit(cell, atom);
            st.addCell(row, colid, cell);
            
            var dom = st.editdom;
            dom[colid] = atom;
        }
    }
    
    st.addRow(row);
    
    return row.element.rowIndex;
}

function deleteRow()
{
    for (var len = portTable.getDataRowLength() - 1; len >= 0; len--) 
    {
        if (portTable.getRowSelFlag(len)) 
        {
            if (0 == portTable.getCellElement(len, "portID").isEdit) 
            {
                var rowData = new Array();
                rowData[0] = portTable.getCellStoreValue(len, "vlanID", "vlanID");
                rowData[1] = portTable.getCellStoreValue(len, "portType", "portType");
                rowData[2] = portTable.getCellStoreValue(len, "port", "port");
                rowData[3] = portTable.getCellStoreValue(len, "portID", "portID");
                
                deleteRowArray.push(rowData);
            }
            portTable.deleteRow(len);
            $("applyBtn").disabled = !btnRightArr.applyBtn.right;
        }
    }
    portTable.adjustDataRows();
    $("deleteRowBtn").disabled = true;
}
