var winobj = getNeProperty(parent)
var CMD_OBJ = new Object();
CMD_OBJ.QUERY_CMD = TECMDCODE_QUERY_IGMP_TABLE;
CMD_OBJ.DELETE_CMD = TECMDCODE_IP_STATICIGMP_DELETE;
CMD_OBJ.CREATE_CMD = TECMDCODE_IP_STATICIGMP_CREATE;
CMD_OBJ.QUERY_ROUTE_CMD = TECMDCODE_IP_STATICIGMP_QUERY;
var upTable = null;
var upTableConfig = null;
CMD_OBJ.QUERY_AVAILABLERES_CMD = TECMDCODE_IP_STATICIGMP_GET_VALIDRESOURCE;

var downTable = null;
var downTableConfig = null;
var btnRightObj = new Object();
var availablePortArray = [];
var availablePortObj;
var PARTSUCC = 1;
var FAIL = 2;
var UNI = "1";
var NNI = "2";
var PW = "1";
var QINQ = "4";
var EMPTYRESULT = "42617";
var EMPTY_RESULT = "38662";
var NO_DATA = "42612";
var INVALID_SUBSLOTID = 255;
var SVL_VLAN = "65534";
var selectedRowid;
var NORESOURCE = true;

loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/snooping/snooping_" + SYSTEMCONF.getLanguage() + ".xml");

loadXMLdoc("../../conf/snooping/snoopingmeminfmgruptable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);
loadXMLdoc("../../conf/snooping/snoopingmeminfmgrdowntable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);


function initPage()
{
    initUpTable();
    initDownTable();
    initButton();
    
    doQuery();
    
    $("totalrow").innerHTML = RESOURCE["totalrow"];
    $("selrow").innerHTML = RESOURCE["selectedrow"];
}

function tabSelectHandler()
{
    if(btnRightObj.queryBtn.right)
	  {
		    doQuery();
	  } 
}

function initUpTable()
{
    upTable = new SortTable();
    upTable.head.setAttribute("id", "htmlTable_STHead_meminfmgr");
    upTable.body.setAttribute("id", "htmlTable_STBody_meminfmgr");
    upTable.setImage("../../../../images/");
    upTable.setOnRowSelectHandler(upTableRowSelected);
    upTableConfig = window.tableconf[0];
    
    createTableHead(upTable, upTableConfig);
    
    document.getElementById("upTableComponent").appendChild(upTable.getTable());
    
    upTable.setBodyHeight(getComponetHeight($("upTableComponent"), 120) * 0.80 + "px");
    window.onresize = function()
    {
        upTable.setBodyHeight(getComponetHeight($("upTableComponent"), 70) + "px");
    };
    
    $("totalrownum").innerHTML = upTable.getDataRowLength();
    $("selrownum").innerHTML = 0;
}

function initDownTable()
{
    downTable = new SortTable();
    downTable.head.setAttribute("id", "htmlTable_STHead_meminfmgr1");
    downTable.body.setAttribute("id", "htmlTable_STBody_meminfmgr1");
    downTable.setImage("../../../../images/");
    downTable.setOnRowSelectHandler(downTableRowSelected);
    downTableConfig = window.tableconf[1];
    
    createTableHead(downTable, downTableConfig);
    
    document.getElementById("downTableComponent").appendChild(downTable.getTable());
    
    downTable.setBodyHeight("130px");
}

function initButton()
{
    $("queryBtn").value = RESOURCE["querybutton"];
    $("deleteBtn").value = RESOURCE["deletebutton"];
    $("createBtn").value = RESOURCE["newbutton"];
    
    btnRightObj.queryBtn = new BtnRightObj("queryBtn", CMD_OBJ.QUERY_CMD);
    btnRightObj.deleteBtn = new BtnRightObj("deleteBtn", CMD_OBJ.DELETE_CMD);
    btnRightObj.createBtn = new BtnRightObj("createBtn", CMD_OBJ.CREATE_CMD);
    
    checkRights();
}

function checkRights()
{
    var xmlData = createCheckRightXmlData();
    var checkUrl = "../../../../securityServlet?neID=" + winobj["neid"] + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(checkUrl, "POST", false, checkRightsHandler, null, "inputdata=" + xmlData);
}

function checkRightsHandler(doc)
{
    var data = EncapsulateData(doc);
    var right = null;
    for (var i = 0, rowLength = data.getDataRowLength(); i < rowLength; ++i) 
    {
        right = ("1" == data.getDataRowParam(i, 'right'));
        
        btnRightObj[data.getDataRowParam(i, 'btnId')].right = right;
    }
    
    updataButtonState();
}

function updataButtonState()
{
    $("queryBtn").disabled = !btnRightObj.queryBtn.right;
    $("createBtn").disabled = !btnRightObj.createBtn.right;
}

function createCheckRightXmlData()
{
    var root = new inputxml('datainterface');
    
    var bussinessNode = new tagElement('bussiness-params');
    var rowParams = null;
    var param = null;
    
    for (var oneRight in btnRightObj) 
    {
        rowParams = new tagElement('row-params');
        param = new tagElement('param');
        param.setAttribute('name', 'btnId');
        param.setAttribute('value', btnRightObj[oneRight].btnId);
        rowParams.appendChild(param);
        
        param = new tagElement('param');
        param.setAttribute('name', 'sfid');
        param.setAttribute('value', btnRightObj[oneRight].sfid);
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
    
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

function doQuery()
{
    if (!btnRightObj.queryBtn.right) 
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("deleteBtn").disabled = true;
    $("createBtn").disabled = true;
    
    var xmlData = createQueryUpXmlData();
    var url = "../../../../neExlorerServlet?sfid=" + CMD_OBJ.QUERY_CMD + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, queryUpHandler, null, "inputdata=" + xmlData);
}

function createQueryUpXmlData()
{
    var root = new inputxml('datainterface');
    var bussinessNode = new tagElement('bussiness-params');
    var rowParams = null;
    var param = null;
    
    rowParams = new tagElement("row-params");
    param = new tagElement('param');
    param.setAttribute('name', 'neID');
    param.setAttribute('value', winobj['neid']);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute('name', 'indexID');
    param.setAttribute('value', '0');
    rowParams.appendChild(param);
    
    param = new tagElement('param');
    param.setAttribute('name', 'vlanID');
    param.setAttribute('value', '65535');
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
    
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

function queryUpHandler(doc)
{
    var data = EncapsulateData(doc);
    var errCode = data.getSErrorCode();
    if (0 != errCode) 
    {
        var len = data.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (EMPTY_RESULT == data.errObj.rowErrors[i].error.code) 
            {
                data.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (PARTSUCC == errCode || FAIL == errCode)) 
        {
            data.errObj.s_error.code = 0;
        }
        else 
        {
            for (var i = 0; i < len; i++) 
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["querybutton"] + RESOURCE["meminfmgr"];
            }
            
            var errArr = [];
            errArr[0] = "operateObj";
            openErrPage("../../../../page/", data.getError(), errArr);
        }
    }
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        for (var i = 0; i < data.getDataRowLength(); i++) 
        {
            var row = data.rows[i];
            
            if (SVL_VLAN == row["vlanID"].value) 
            {
                row["vlanID"].value = "-";
            }
        }
        upTable.clearTableData();
        downTable.clearTableData();
        
        createTableBody(upTable, upTableConfig, data, RESOURCE);
        
        if (!upTable.element.colsArray.selectedId) 
        {
            upTable.element.colsArray.selectedId = "indexID";
            upTable.element.colsArray.imgflag = 1;
        }
        
        if (0 != upTable.getDataRowLength()) 
        {
			upTable.setRowSelect(0);
            upTableRowSelected(upTable.getSelectedRows());
        }
        else
        {
            $("totalrownum").innerHTML = 0;
            $("selrownum").innerHTML = 0;
        }
    }
    $("queryBtn").disabled = false;
    $("createBtn").disabled = !btnRightObj.createBtn.right;
}

function upTableRowSelected(selRows)
{
    $("deleteBtn").disabled = true;
    downTable.clearTableData();
    if (selRows.length <= 0) 
    {
        return;
    }
    
    $("totalrownum").innerHTML = upTable.getDataRowLength();
    $("selrownum").innerHTML = selRows.length;
    
    $("queryBtn").disabled = true;
    $("createBtn").disabled = true;
    selectedRowid = selRows[0];
    var xmlData = createQueryDownXmlInfo(selectedRowid);
    var url = "../../../../neExlorerServlet?sfid=" + CMD_OBJ.QUERY_ROUTE_CMD + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, queryDownHandler, null, "inputdata=" + xmlData);
}

function downTableRowSelected(selRows)
{
    if (selRows && 0 != selRows.length) 
    {
        $("deleteBtn").disabled = !btnRightObj.deleteBtn.right;
    }
    else 
    {
        $("deleteBtn").disabled = true;
    }
}

function createQueryDownXmlInfo(row)
{
    var indexid = upTable.getCellStoreValue(row, "indexID", "indexID");
    var vlanID = upTable.getCellStoreValue(row, "vlanID", "vlanID");
    if ("-" == vlanID) 
    {
        vlanID = SVL_VLAN;
    }
    
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    var rowParams = new tagElement("row-params");
    var param = null;
    
    param = new tagElement('param');
    param.setAttribute('name', 'neID');
    param.setAttribute('value', winobj['neid']);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "indexID");
    param.setAttribute("value", indexid);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vlanID");
    param.setAttribute("value", vlanID);
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

function queryDownHandler(doc)
{
    downTable.clearTableData();
    var data = EncapsulateData(doc);
    
    var errCode = data.getSErrorCode();
    if (0 != errCode) 
    {
        var len = data.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (EMPTYRESULT == data.errObj.rowErrors[i].error.code || EMPTY_RESULT == data.errObj.rowErrors[i].error.code) 
            {
                data.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (PARTSUCC == errCode || FAIL == errCode)) 
        {
            data.errObj.s_error.code = 0;
        }
        else 
        {
            for (var i = 0; i < len; i++) 
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["querybutton"] + RESOURCE["interfaceInfo"];
            }
            
            var errArr = [];
            errArr[0] = "operateObj";
            openErrPage("../../../../page/", data.getError(), errArr);
        }
    }
    if (data.getSErrorCode() == 0 || data.getSErrorCode == 1) 
    {
        var servicID = upTable.getCellCurrentValue(selectedRowid, "serviceID", "serviceID");
        for (var len = data.getDataRowLength() - 1; len >= 0; len--) 
        {
            var row = data.rows[len];
            
            if (upTable.getCellStoreValue(selectedRowid, "macAdd", "macAdd") != row["macAdd"].value) 
            {
                data.rows.removeAt(len);
                continue;
            }
            
            if (SVL_VLAN == row["vlanID"].value) 
            {
                row["vlanID"].value = "-";
            }
            
            var ptag = new ParamTag();
            ptag.value = servicID;
            row["serviceID"] = ptag;
        }
        createTableBody(downTable, window.tableconf[1], data, RESOURCE);
    }
    $("queryBtn").disabled = false;
    $("createBtn").disabled = !btnRightObj.createBtn.right;
    
    var td = downTable.element.headRow.element.cols["indexID"].element;
    downTable.sortRows(td, upTable.element.colsArray.imgflag);
}

function doDelete()
{
    $("deleteBtn").disabled = true;
    if (!confirm(RESOURCE["Delete_Hint"])) 
    {
        $("deleteBtn").disabled = false;
        return;
    }
    var xmlData = createDeleteRouteXmlInfo();
    if (!xmlData) 
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
    var url = "../../../../neExlorerServlet?sfid=" + CMD_OBJ.DELETE_CMD + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", true, deleteRouteHandler, null, "inputdata=" + xmlData);
}

function deleteRouteHandler(doc)
{
    var data = EncapsulateData(doc);
    
    var errCode = data.getSErrorCode();
 	var upTableSelectRow = upTable.getSelectedRows();
	var serviceID = upTable.getCellStoreValue(upTableSelectRow[0], "serviceID", "serviceID");
    if (0 != errCode) 
    {
        var len = data.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (NO_DATA == data.errObj.rowErrors[i].error.code) 
            {
                data.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (PARTSUCC == errCode || FAIL == errCode)) 
        {
            data.errObj.s_error.code = 0;
        }
        else 
        {
  	  	  for(var i = 0, len = data.getBErrLength();i < len;i++)
	        {
	        	  var tempObj = data.getError().rowErrors[i].errorObj;
          		tempObj["operateObj"] = RESOURCE["indexID"] + serviceID;
          		if(tempObj["vlanID"] != SVL_VLAN)
          		{
          		    tempObj["operateObj"] += " " + RESOURCE["vlanID"] + tempObj["vlanID"];
          		}
          		var macAddress = tempObj["macAdd"];
          		macAddress = macAddress.substring(0,2) + "-" 
            	           + macAddress.substring(2,4) + "-"
            	           + macAddress.substring(4,6) + "-"
            	           + macAddress.substring(6,8) + "-"
            	           + macAddress.substring(8,10) + "-"
            	           + macAddress.substring(10,12);
          		tempObj["operateObj"] += " " + RESOURCE["macAdd"] + macAddress;
	        }		
            var errArr = [];
            errArr[0] = "operateObj";
            openErrPage("../../../../page/", data.getError(), errArr);
        }
    }
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        var failedList = [];
        for (var i = 0, len = data.getBErrLength(); i < len; i++) 
        {
            var obj = {};
            obj["indexID"] = data.getBErrParam(i, "indexID");
            failedList[failedList.length++] = obj;
            obj["vlanID"] = data.getBErrParam(i, "vlanID");
        }
        
        for (var rowCount = upTable.getDataRowLength(), row = rowCount - 1; row >= 0; row--) 
        {
            var indexid = upTable.getCellStoreValue(row, "indexID", "indexID");
            var vlanid = upTable.getCellStoreValue(row, "vlanID", "vlanID");
            
            for (var j = 0; j < failedList.length; ++j) 
            {
                var tmpObj = failedList[j];
                if (tmpObj["indexID"] == indexid && tmpObj["vlanID"] == vlanid) 
                {
                    upTable.deleteRow(row);
                }
            }
        }
        upTable.adjustDataRows();
        doQuery();
    }
}


function createDeleteRouteXmlInfo()
{
    var upTableSelectRow = upTable.getSelectedRows();
    if (!upTableSelectRow || !upTableSelectRow.length) 
    {
        return null;
    }
    
    var indexID = upTable.getCellStoreValue(upTableSelectRow[0], "indexID", "indexID");
    var vlanID = upTable.getCellStoreValue(upTableSelectRow[0], "vlanID", "vlanID");
    if ("-" == vlanID) 
    {
        vlanID = SVL_VLAN;
    }
    var macAddress = upTable.getCellStoreValue(upTableSelectRow[0], "macAdd", "macAdd");
    var macAddressArray = macAddress.split("-");
    macAddress = "";
    for (var j = 0, len = macAddressArray.length; j < len; j++) 
    {
        macAddress += macAddressArray[j];
    }
    
    var selRows = downTable.getSelectedRows();
    if (!selRows || !selRows.length) 
    {
        return null;
    }
    
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    var rowParams = null;
    var param = null;
    
    for (var i = 0; i < selRows.length; i++) 
    {
        var row = selRows[i];
        
        rowParams = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "neID");
        param.setAttribute("value", winobj["neid"]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "indexID");
        param.setAttribute("value", indexID);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "vlanID");
        param.setAttribute("value", vlanID);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "macAdd");
        param.setAttribute("value", macAddress);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portNum");
        param.setAttribute("value", 1);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portType");
        param.setAttribute("value", downTable.getCellStoreValue(row, "portType", "portType"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portID");
        param.setAttribute("value", downTable.getCellStoreValue(row, "interfaceIndex", "interfaceIndex"));
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
    
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}


function doCreate()
{
    NORESOURCE = true;
    queryAvailablePortRes();
    if (NORESOURCE) 
    {
        alert(RESOURCE["noresource"]);
        return;
    }
    var dialogHeight = 440;
    var dialogWidth = 700;
    
    xshowModalDialog("addmemportpage.html", RESOURCE["createMemPortTitle"], dialogWidth, dialogHeight, "../../../../images/");
}

function createQueryAvailableResXmlInfo()
{
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    var rowParams = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", winobj["neid"]);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "servType");
    param.setAttribute("value", "2");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "servIndex");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vuniId");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vnniId");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

function queryAvailablePortRes()
{
    availablePortArray.length = 0;
    var xmlInfo = createQueryAvailableResXmlInfo();
    var url = "../../../../neExlorerServlet?sfid=" + CMD_OBJ.QUERY_AVAILABLERES_CMD + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, queryAvailablePortResHandler, null, "inputdata=" + xmlInfo);
}

function queryAvailablePortResHandler(doc)
{
    var datainterface = EncapsulateData(doc);
    availablePortObj = new Object();
    for (var i = 0, rCount = datainterface.getDataRowLength(); i < rCount; ++i) 
    {
        var serviceIndex = datainterface.getDataRowParam(i, "indexID");
        if (null == availablePortObj[serviceIndex]) 
        {
            availablePortObj[serviceIndex] = new Array();
        }
        
        var interfaceName = "";
        var interfaceID = datainterface.getDataRowParam(i, "infID");
        if (UNI == datainterface.getDataRowParam(i, "infType")) 
        {
            interfaceName = datainterface.getDataRowParam(i, "slotid") + "-" +
            datainterface.getDataRowParam(i, "boardTypeName") +
            "-";
            
            var subslotid = datainterface.getDataRowParam(i, "subslotid");
            if (INVALID_SUBSLOTID != subslotid) 
            {
                interfaceName += subslotid + "-" +
                datainterface.getDataRowParam(i, "subBoardTypeName") +
                "-";
            }
            
            interfaceName += datainterface.getDataRowParam(i, "portName") +
            datainterface.getDataRowParam(i, "tagIds") +
            ":" +
            interfaceID +
            "-" +
            UNI;
            NORESOURCE = false;
        }
        else 
        {
            interfaceID = datainterface.getDataRowParam(i, "vnniId");
            if (PW == datainterface.getDataRowParam(i, "carrierType")) 
            {
                interfaceName = "PW-" + datainterface.getDataRowParam(i, "pwID") +
                ":" +
                interfaceID +
                "-" +
                NNI;
            }
            else if (QINQ == datainterface.getDataRowParam(i, "carrierType")) 
            {
                interfaceName = "QinQ-" + datainterface.getDataRowParam(i, "portID") +
                ":" +
                interfaceID +
                "-" +
                NNI;
            }
            else 
            {
                interfaceName = datainterface.getDataRowParam(i, "slotid") + "-" +
                datainterface.getDataRowParam(i, "boardTypeName") +
                "-";
                
                
                var subslotid = datainterface.getDataRowParam(i, "subslotid");
                if (INVALID_SUBSLOTID != subslotid) 
                {
                    interfaceName += subslotid + "-" +
                    datainterface.getDataRowParam(i, "subBoardTypeName") +
                    "-";
                }
                
                interfaceName += datainterface.getDataRowParam(i, "portName") +
                ":" +
                interfaceID +
                "-" +
                NNI;
            }
            NORESOURCE = false;
        }
        availablePortObj[serviceIndex].push(interfaceName);
    }
}

function convertResToInfStruct(obj)
{
    var tmpPort = new TEEInfStruct();
    tmpPort.indexID = obj["indexID"].value;
    tmpPort.infType = obj["infType"].value;
    tmpPort.infID = obj["infID"].value;
    tmpPort.slotID = obj["slotID"] ? obj["slotID"].value : null;
    tmpPort.subSlotID = obj["subSlotID"] ? obj["subSlotID"].value : null;
    tmpPort.portID = obj["portID"] ? obj["portID"].value : null;
    tmpPort.portID = obj["portID"] ? obj["portID"].value : null;
    tmpPort.tagID = obj["tagID"] ? obj["tagID"].value : null;
    tmpPort.neID = obj["neID"] ? obj["neID"].value : null;
    tmpPort.neName = obj["neName"] ? obj["neName"].value : null;
    tmpPort.boardTypeName = obj["boardTypeName"] ? obj["boardTypeName"].value : null;
    tmpPort.subBoardTypeName = obj["subBoardTypeName"] ? obj["subBoardTypeName"].value : null;
    tmpPort.portName = obj["portName"] ? obj["portName"].value : null;
    tmpPort.loaderType = obj["loaderType"] ? obj["loaderType"].value : null;
    tmpPort.loaderParam1 = obj["loaderParam1"] ? obj["loaderParam1"].value : null;
    tmpPort.loaderParam2 = obj["loaderParam2"] ? obj["loaderParam2"].value : null;
    tmpPort.loaderParam3 = obj["loaderParam3"] ? obj["loaderParam3"].value : null;
    
    return tmpPort;
}

function convertMsg(res, obj, key)
{

    if ("function" == (typeof obj)) 
    {
        return obj(key);
    }
    else //       
     {
        if (null == obj) 
        {
            return key;
        }
        var resValue = obj[key];
        if (null == resValue) 
        {
            resValue = "/";
        }
        return resValue;
    }
}
