document.title = RESOURCE["createsnmptrap"];
var winurlobj = getParentWindow();
var neid = winurlobj.winobj["neid"];

var OPRSUCC = 0;

var okFlag = false;

var ct;

var trapver =new Object();
trapver[0] = "snmpv1_str";
trapver[1] = "snmpv2c_str";

var logString = "";

var community_type_rowindex = 0;
function initpage()
{  
    initTable();   
    initButtonText();
}


function initTable()
{
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    var atom = new Atom("text");   
    atom.element.setAttribute("id", "htmlText_snmp_nmip"); 
    atom.element["onfocus"] = function()
    {
	     changeVale(this);
    }
    atom.setValue("0.0.0.0");
    validateIp(atom.element);
    ct.addAttrRow("nmip", RESOURCE["nmip_str"], atom);
    
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_snmp_readwrite");
    atom.addOption(RESOURCE["r"],1);    
    atom.addOption(RESOURCE["rw"],2);
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    ct.addAttrRow("rwctrl",RESOURCE["rwctrl"],atom); 
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_snmp_trapreport_sdhflag");
    atom.addOption(RESOURCE["no"],2);
    atom.addOption(RESOURCE["yes"],1);
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    ct.addAttrRow("sdhflag",RESOURCE["sdhflag"],atom); 
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_snmp_trapreport_perfflag");
    atom.addOption(RESOURCE["no"],2);
    atom.addOption(RESOURCE["yes"],1);
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    ct.addAttrRow("perfflag",RESOURCE["perfflag"],atom); 
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_snmp_trapreport_alarmflag");
    atom.addOption(RESOURCE["no"],2);
    atom.addOption(RESOURCE["yes"],1);
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    ct.addAttrRow("alarmflag",RESOURCE["alarmflag"],atom); 
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_snmp_port");
    atom.element.text = "162";
    checkText(atom.element, 1, 0xFFFF);
    atom.setValue("162");
    ct.addAttrRow("trapport", RESOURCE["port_str"], atom); 
    
    atom = new Atom("password");
    atom.element.setAttribute("id", "htmlText_snmp_inputcommunity");
    atom.element.maxLength = 16;

    checkInputData(atom.element, 16);
    ct.addAttrRow("inputcommunity", RESOURCE["inputcommunity_str"], atom);  
    atom.element.style.imeMode = "disabled";
    atom.element.readOnly = true;
    atom.element["onkeypress"] = function()
    {	     
        changeVale(this);
    }	
    atom.element["onfocus"] = function()
    {
        community_type_rowindex = 6;
        setPassword();
    }
    atom.element["onclick"] = function()
    {
    	  community_type_rowindex = 6;
    }
    
    atom = new Atom("password");
    atom.element.setAttribute("id", "htmlText_snmp_writecommunity");
    atom.element.maxLength = 16;
    checkInputData(atom.element, 16);
    ct.addAttrRow("writecommunity", RESOURCE["writecommunity_str"], atom);  
    atom.element.style.imeMode = "disabled";
    atom.element.readOnly = true;
    atom.element["onkeypress"] = function()
    {	     
        changeVale(this);
    }	
    atom.element["onfocus"] = function()
    {
    	  community_type_rowindex = 7;
        setPassword();
    }
    atom.element["onclick"] = function()
    {
    	  community_type_rowindex = 7;
    }
    
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_snmp_trapver");
    atom.addOption(RESOURCE["snmpv1_str"],0);
    atom.addOption(RESOURCE["snmpv2c_str"],1);
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    ct.addAttrRow("trapver",RESOURCE["trapver_str"],atom); 
    
    
    $("tablecomponent").appendChild(ct.getTable());
}

function setPassword()
{	
	showSetPwdPage(RESOURCE["set_community"],"../../../../",false,16,null,false,false,0);
}

function setpwdpageHandler(value)
{
	  if (community_type_rowindex == 6)
	  {
        ct.setAttrValue("inputcommunity", value);
    }
    else if (community_type_rowindex == 7)
    {
        ct.setAttrValue("writecommunity", value);
    }
}

/*
 *   
 */
function changeVale(atom)
{
    if ($("applybtn").disabled)
    {
        $("applybtn").disabled=false;
    }
}

function initButtonText()
{     
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"]; 
    $("applybtn").value = RESOURCE["applybtn"]; 
    $("applybtn").disabled = true;
}

function doCreate(buttonFlag)
{
    okFlag = buttonFlag;
    
    if (!checkDataValid())
    {
        return;
    }
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    $("cancelbtn").disabled = true;
  
    var xmlstr = createXML();
    
    var urlreq ="../../../../neExlorerServlet?sfid="+PTN_CMD_ADD_SNMPTRAP+""+"&nmUser="+winurlobj.winobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackCreate,null,"inputdata="+xmlstr);
}

function checkDataValid()
{
	var ip = ct.getAttrValue("nmip");
	if(ip == "0.0.0.0")
	{
		alert(RESOURCE["inputip"]);
		return false;
	}
    if (!check_IPaddr(ct.getAttrValue("nmip")))
    {
        return false;
    }
    
    return true;
}

function createXML()
{
	
	logString = "";
	
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj.winobj.neid);
    row.appendChild(param);

    param = new tagElement("param");    
    param.setAttribute("name","nmip");
    param.setAttribute("value",hexToTen(convertIpaddrToHexcode(ct.getAttrValue("nmip"))));
    row.appendChild(param);
    
    stuffLog(RESOURCE["nmip_str"], ct.getAttrValue("nmip"));
    
    param = new tagElement("param");
    param.setAttribute("name", "rwctrl");
    param.setAttribute("value", ct.getAttrValue("rwctrl"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "sdhflag");
    param.setAttribute("value", ct.getAttrValue("sdhflag"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "perfflag");
    param.setAttribute("value", ct.getAttrValue("perfflag"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "alarmflag");
    param.setAttribute("value", ct.getAttrValue("alarmflag"));
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","trapport");
    param.setAttribute("value",ct.getAttrValue("trapport"));
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","inputcommunity");
    param.setAttribute("isPassword",true);
    param.setAttribute("value",EncryptUtils.encrypt(ct.getAttrValue("inputcommunity")));
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","writecommunity");
    param.setAttribute("isPassword",true);
    param.setAttribute("value",EncryptUtils.encrypt(ct.getAttrValue("writecommunity")));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "trapver");
    param.setAttribute("value", ct.getAttrValue("trapver"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "opDesc");
    param.setAttribute("value", logString);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc)
{
    $("okbtn").disabled=false;
    $("applybtn").disabled=false;
    $("cancelbtn").disabled=false;
    
    var data = EncapsulateData(doc);    
    if(OPRSUCC == data.getSErrorCode()) 
    {       
        winurlobj.querySnmpTrap();        
        if (okFlag)
	    {
		    ct.setAttrValue("inputcommunity", "");
        	ct.setAttrValue("writecommunity", "");
	        xcloseDialog();
	    }
    } 
    else
    {   
        var errArr = [];
        errArr[0] = "createsnmptrap";
        openErrPage("../../../../page/", data.getError(), errArr);
    }   
}

function checkInputData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);
    }
   
}


function stuffLog(key, value)
{
	if(logString != "")	 
	{
		logString += "," ;
	}
	logString += key + ":" + value;
}
