var winurlobj = getNeProperty(self);

var btnRightArr = new Object();

var OPRSUCC = 0;
var PARTSUCC = 1;

var VIRTUAL_PORT_MIN = 0x2800;
var VIRTUAL_PORT_MAX = 0x2FFF;

var RESULT_NULL = "38662";
var INVALID_SOLTID = "65535";
var INVALID_SUBSOLTID = "255";
var TIMEOUT = 131080;

var st;

var MIN_PCBS = "64";  
var MAX_PCBS = "65535";

var MIN_BANDWIDTH = 128;
var MAX_BANDWIDTH = 10000000;

var shapingModel = new Array();
shapingModel[1] = "ipg";
shapingModel[2] = "noipg";

var bandwidth = new Array();
bandwidth[0] = "nolimit"

var bandwidthAttr = new Array();
bandwidthAttr[0] = "cir";
bandwidthAttr[1] = "pir";


window.onresize=function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"),70)+"px");
}

function initpage()
{	
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_SortTableHead_vlansharping");
    st.body.setAttribute("id", "htmlTable_SortTableBody_vlansharping");
    st.setImage("../../../../images/");    
    tc = window.tableconf[0];    
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, tc);    
    st.setBodyHeight(getComponetHeight($("tablecomponent"),70)+"px");    
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    $("tablecomponent").appendChild(st.getTable());
    
    $("queryBtn").value=RESOURCE["querybutton"];
    $("applyBtn").value=RESOURCE["applybutton"];
    
    btnRightArr.queryBtn = new BtnRightObj("queryBtn",TECMDCODE_GET_VLANSUBIF_BDWIDTH);//TODO               
    btnRightArr.applyBtn = new BtnRightObj("applyBtn",TECMDCODE_SET_VLANSUBIF_BDWIDTH);//TODO               
    
    getRightInfo(winurlobj,btnRightArr);
    
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    if(btnRightArr.queryBtn.right)
    {
        query();
    }   
}

function cellEditHandler(param)
{	
	var maxLength = (param.colid == "cbs" || param.colid == "pbs") ? 5 :10;
	if ((bandwidthAttr.contains(param.colid)) && (param.stage == TABLE_CONSTANT.BEFOREEDIT)) 
    {
        var opsary = getCIRPIRDataArr();
        var dm = st.getCellEdit(param.rowindex, param.colid).element.parent;
        dm.selview.options.length = 0;
        dm.selview.onclick= clickHandler;
        dm.initComboBox(opsary, "dm", 0, true);
        var textview = dm.txtview;
        textview.onkeypress = keypressHandlerPCIR;
        textview.onkeyup = keyupHandlerPCIR;
        textview.onblur = onblurHandlerPCIR;
        textview.style.imeMode = "disabled";
        textview.onpaste = function()
        {
            return false;
        };
        textview.maxLength = maxLength;
    }
    else if( (param.colid == "cbs" || param.colid == "pbs") && (param.stage == TABLE_CONSTANT.BEFOREEDIT) )
    {
        var opsary = getCBSPBSDataArr();
        var dm = st.getCellEdit(param.rowindex, param.colid).element.parent;
        dm.selview.options.length = 0;
        dm.selview.onclick= clickHandler;
        dm.initComboBox(opsary, "dm", 0, true);
        var textview = dm.txtview;
        textview.onkeypress = keypressHandlerPCBS;
        textview.onkeyup = keyupHandlerPCBS;
        textview.onblur = onblurHandlerPCBS;
        textview.style.imeMode = "disabled";
        textview.onpaste = function()
        {
            return false;
        };
        textview.maxLength = maxLength;
    }
	
    $("applybtn").disabled = !btnRightArr.applyBtn.right; 
}

function query()
{
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
  
    var xmlstr = createQueryXML();
    
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_GET_VLANSUBIF_BDWIDTH+""+"&nmUser="+winurlobj["nmUser"]+"&flag=1";        
    loadXMLdoc(urlreq, "POST",true,handleBackQuery,null,"inputdata="+xmlstr);   
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj["neid"]);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","slotid");
    param.setAttribute("value",INVALID_SOLTID);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","subslotid");
    param.setAttribute("value",INVALID_SUBSOLTID);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","port");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{
    st.clearTableData();
    
    $("queryBtn").disabled = false;
    
    data = EncapsulateData(doc); 
    if(data.getError().rowErrors[0])
    {   
        var size = data.getBErrLength();
        for(var i = 0;i < size;i++)
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["queryLDPPort"];
        }
    }   
    var errArr = [];
    errArr[0] = "operateObj";
    
    if (OPRSUCC != data.getError().getGlobleECode()) 
    { 
        var flag = true;
        var len = data.errObj.rowErrors.length
        for (var i = 0; i < len; i++)
        {
            if (RESULT_NULL != data.errObj.rowErrors[i].error.code)
            {
                flag = false;
                break;
            }
        }
        if (flag && TIMEOUT != data.errObj.s_error.code)
        {
            data.errObj.s_error.code = OPRSUCC;
        }
    }
    
    openErrPage("../../../../page/", data.getError(), errArr);
    
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
        for(var i=0;i<data.getDataRowLength();i++)
        {
          
            var row = data.rows[i];
          
            if (INVALID_SUBSOLTID == row["subslotid"].value)
            {
                row["subslotid"].value = "";
            }      
            if (VIRTUAL_PORT_MIN <= row["port"].value && row["port"].value <= VIRTUAL_PORT_MAX)
            {
                row["slotid"].value = "";
                row["subslotid"].value = "";
                row["boardname"].value = "";
                row["subboardname"].value = "";
                                
            }
        }
        
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        
    } 
}

function addCellEvent()
{
	
    var cell = null;
    for(var rowindex = 0,len = st.getDataRowLength();rowindex<len;rowindex++)
    {            
        cell = st.getCellEdit(rowindex, "cir").element;
    	cell.onchange = function ()
        {
        	 document.getElementById("applybtn").disabled = !btnRightArr["applybtn"].right;
        }
        cell = st.getCellEdit(rowindex, "cbs").element;
    	cell.onchange = function ()
        {
        	 document.getElementById("applybtn").disabled = !btnRightArr["applybtn"].right;
        }
        cell = st.getCellEdit(rowindex, "pir").element;
    	cell.onchange = function ()
        {
        	 document.getElementById("applybtn").disabled = !btnRightArr["applybtn"].right;
        }
        cell = st.getCellEdit(rowindex, "pbs").element;
    	cell.onchange = function ()
        {
        	 document.getElementById("applybtn").disabled = !btnRightArr["applybtn"].right;
        }
        textCheck(st.getCellEdit(rowindex, "cir").element.firstChild,MIN_BANDWIDTH,MAX_BANDWIDTH);
		textCheck(st.getCellEdit(rowindex, "pir").element.firstChild,MIN_BANDWIDTH,MAX_BANDWIDTH);
		textCheck(st.getCellEdit(rowindex, "cbs").element.firstChild,MIN_PCBS,MAX_PCBS);
		textCheck(st.getCellEdit(rowindex, "pbs").element.firstChild,MIN_PCBS,MAX_PCBS);       
    }
}

function apply()
{
    var xml = createApplyXML();
    if (null == xml)
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_SET_VLANSUBIF_BDWIDTH+""+"&nmUser="+winurlobj["nmUser"]+"&flag=1";
    loadXMLdoc(urlreq, "POST",true,handleBackApply,null,"inputdata="+xml);
}

/*
 * 
 */
function createApplyXML()
{
	
    di = new inputxml("datainterface");
    bussiness = new tagElement("bussiness-params");
    var row;
    var param;
    var logString = "";//         
    for(var i=0,length = st.getDataRowLength();i<length;i++)
    {
        if(!st.getModify(i))
        {
          continue;
        }
        
        
        
        var cir = st.getCellShow(i, "cir").getValue();
        var pir = st.getCellShow(i, "pir").getValue();
        if (Number(cir) > Number(pir))
		{
			alert(RESOURCE["INPUT_INVALID_PIR"]);
			return null;
		}
        
        row = new tagElement("row-params");   
            
        param = new tagElement("param");
        param.setAttribute("name","neid");
        param.setAttribute("value",winurlobj["neid"]);
        row.appendChild(param); 
        
        param = new tagElement("param");    
        param.setAttribute("name","slotid");
        var slotid = st.getCellStoreValue(i,"port","slotid");
        if (undefined == slotid)
        {
            slotid = INVALID_SOLTID;
        }
        param.setAttribute("value",INVALID_SOLTID);
        row.appendChild(param);
        
        param = new tagElement("param");    
        param.setAttribute("name","subslotid");
        var subslotid = st.getCellStoreValue(i,"port","subslotid");
        if (undefined == subslotid)
        {
            subslotid = INVALID_SUBSOLTID;
        }
        param.setAttribute("value",INVALID_SUBSOLTID);
        row.appendChild(param);
        
        param = new tagElement("param");    
        param.setAttribute("name","port");
        param.setAttribute("value",st.getCellStoreValue(i,"port","port"));
        row.appendChild(param);        
        logString += RESOURCE["port"] + RESOURCE["colon"] + st.getCellStoreValue(i,"portname","portname") + RESOURCE["comma"];
        
        
        param = new tagElement("param");    
        param.setAttribute("name","shapingModel");
        param.setAttribute("value",st.getCellStoreValue(i,"shapingModel","shapingModel"));
        row.appendChild(param);
        logString += RESOURCE["shapingModel"] + RESOURCE["colon"] + RESOURCE[shapingModel[st.getCellStoreValue(i,"shapingModel","shapingModel")]] + RESOURCE["comma"];
        
                
        param = new tagElement("param");
        param.setAttribute("name","cir");
        cir = (cir == RESOURCE["nolimit"] ? 0 : cir);
        param.setAttribute("value",cir);
        row.appendChild(param);
        logString += RESOURCE["cir"] + RESOURCE["colon"] + cir + RESOURCE["comma"];
        
        var cbs = st.getCellShow(i, "cbs").getValue();        
        param = new tagElement("param");
        param.setAttribute("name","cbs");
        cbs = (cbs == RESOURCE["nolimit"] ? 0 : cbs);
        param.setAttribute("value",cbs);
        row.appendChild(param);
        logString += RESOURCE["cbs"] + RESOURCE["colon"] + cbs + RESOURCE["comma"];
        
                
        param = new tagElement("param");
        param.setAttribute("name","pir");
        pir = (pir == RESOURCE["nolimit"] ? 0 : pir);
        param.setAttribute("value",pir);        
        row.appendChild(param);
        logString += RESOURCE["pir"] + RESOURCE["colon"] + pir + RESOURCE["comma"];
        
        var pbs = st.getCellShow(i, "pbs").getValue();        
        param = new tagElement("param");
        param.setAttribute("name","pbs");
        pbs = (pbs == RESOURCE["nolimit"] ? 0 : pbs);
        param.setAttribute("value",pbs);
        row.appendChild(param);
        logString += RESOURCE["pbs"] + RESOURCE["colon"] + pbs;
        
        param = new tagElement("param");
        param.setAttribute("name", "opDesc");
        param.setAttribute("value", logString);
        row.appendChild(param);
        
        logString = "";
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    
    return di.toString(); 
}

function handleBackApply(doc)
{
    $("queryBtn").disabled = false;

    var data = EncapsulateData(doc);
    
    if (OPRSUCC != data.getError().getGlobleECode())
    {
        if(data.getError().rowErrors[0])
        {   
            var size = data.getBErrLength();
            for(var i = 0;i < size;i++)
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                var portid = parseInt(tempObj["port"], 10);   
                
                if (VIRTUAL_PORT_MIN <= portid)
                {
                    portid = (portid - VIRTUAL_PORT_MIN);
                    tempObj["slotid"] = "";
                    tempObj["boardname"] = "";
                    tempObj["portname"] = portid + "(VEther-" + portid + ")";
                }                    
            }
        }   
        var errArr = [];
        errArr[0] = "slotid";
        errArr[1] = "boardname"; 
        errArr[2] = "portname"; 
        openErrPage("../../../../page/", data.getError(), errArr);
        
        $("applyBtn").disabled = false;
    }

    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode())
    {
        refreshTableState(st,tc,data);
    }
}

/**
 * cir pir
 */
function getCIRPIRDataArr()
{
    var opsary = new Array();
    opsary[0] = new Option(RESOURCE["nolimit"], RESOURCE["nolimit"]);
	opsary[1] = new Option("500Kbit/s", 500);
	opsary[2] = new Option("1Mbit/s", 1000);
	opsary[3] = new Option("2Mbit/s", 2000);
	opsary[4] = new Option("3Mbit/s", 3000);
	opsary[5] = new Option("4Mbit/s", 4000);
	opsary[6] = new Option("5Mbit/s", 5000);
	opsary[7] = new Option("6Mbit/s", 6000);
	opsary[8] = new Option("7Mbit/s", 7000);
	opsary[9] = new Option("8Mbit/s", 8000);
	opsary[10] = new Option("9Mbit/s", 9000);
	opsary[11] = new Option("10Mbit/s", 10000);
	opsary[12] = new Option("20Mbit/s", 20000);
	opsary[13] = new Option("30Mbit/s", 30000);
	opsary[14] = new Option("40Mbit/s", 40000);
	opsary[15] = new Option("50Mbit/s", 50000);
	opsary[16] = new Option("100Mbit/s", 100000);
	opsary[17] = new Option("1000Mbit/s", 1000000);    
    return opsary;
}

/**
 * cbs pbs
 */
function getCBSPBSDataArr()
{
    var opsary = new Array();
    opsary[0] = new Option(RESOURCE["nolimit"], RESOURCE["nolimit"]);
	opsary[1] = new Option("64 byte", 64);
	opsary[2] = new Option("128 byte", 128);
	opsary[3] = new Option("512 byte", 512);
	opsary[4] = new Option("1K byte", 1024);
	opsary[5] = new Option("4K byte", 4096);
	opsary[6] = new Option("16K byte", 16384);
	opsary[7] = new Option("64K byte", 65535);	    
    return opsary;
}

function onblurHandlerPCIR(event)
{
	
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value == "") 
    {
        numobj.value = MIN_BANDWIDTH;
        return;
    }
    else if ((isNaN(numobj.value) && numobj.value != RESOURCE["nolimit"]) || parseInt(numobj.value) < MIN_BANDWIDTH) 
    {
        alert(RESOURCE["wrong1"] + MIN_BANDWIDTH + RESOURCE["wrong2"] + MAX_BANDWIDTH + RESOURCE["wrong3"]);
        numobj.value = MIN_BANDWIDTH;
        return;
    }
}

function onblurHandlerPCBS(event)
{
	
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value == "") 
    {
        numobj.value = MIN_PCBS;
        return;
    }
    else if ((isNaN(numobj.value) && numobj.value != RESOURCE["nolimit"]) || parseInt(numobj.value) < MIN_PCBS) 
    {    	
        alert(RESOURCE["wrong1"] + MIN_PCBS + RESOURCE["wrong2"] + MAX_PCBS + RESOURCE["wrong3"]);
        numobj.value = MIN_PCBS;
        return;
    }
}

function keyupHandlerPCIR(event)
{
	
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (parseInt(numobj.value) > MAX_BANDWIDTH) 
    {    	
        alert(RESOURCE["wrong1"] + MIN_BANDWIDTH + RESOURCE["wrong2"] + MAX_BANDWIDTH + RESOURCE["wrong3"]);
        numobj.value = MAX_BANDWIDTH;
        return;
    }
}

function keyupHandlerPCBS(event)
{
	
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (parseInt(numobj.value) > MAX_PCBS) 
    {    	
        alert(RESOURCE["wrong1"] + MIN_PCBS + RESOURCE["wrong2"] + MAX_PCBS + RESOURCE["wrong3"]);
        numobj.value = MAX_PCBS;
        return;
    }
}

function keypressHandlerPCIR(event)
{
	
    var key, keychar;
    if (!event) 
    {
        event = window.event;
        key = window.event.keyCode;
    }
    var numobj = event.target ? event.target : event.srcElement;
    
    var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
    
    if (event.keyCode == 13) 
    {
        if (numobj.value == "") 
        {
            alert(RESOURCE["wrong1"] + MIN_BANDWIDTH + RESOURCE["wrong2"] + MAX_BANDWIDTH + RESOURCE["wrong3"]);
            return false;
        }
        event.srcElement.blur();
        return true;
    }
    
    if (code == 8 || code == 46 || code == 37 || code == 39) 
    {
        return true;
    }
    
    if (code < 48 || code > 57) 
    {
        return false;
    }
    window.status = "code:" + code + "; value:" + numobj.value;
    var position = digitalTag_getPos(numobj);
    if (position == 0 && numobj.value.length > 0 && (code == 48 || code == 96)) 
    {
        return false;
    }
    
    if (numobj.value == '0' && position > 0) 
    {
        return false;
    }
    
}

function keypressHandlerPCBS(event)
{
    var key, keychar;
    if (!event) 
    {
        event = window.event;
        key = window.event.keyCode;
    }
    var numobj = event.target ? event.target : event.srcElement;
    
    var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
    
    if (event.keyCode == 13) 
    {
        if (numobj.value == "") 
        {
            alert(RESOURCE["wrong1"] + MIN_PCBS + RESOURCE["wrong2"] + MAX_PCBS + RESOURCE["wrong3"]);
            return false;
        }
        event.srcElement.blur();
        return true;
    }
    
    if (code == 8 || code == 46 || code == 37 || code == 39) 
    {
        return true;
    }
    
    if (code < 48 || code > 57) 
    {
        return false;
    }
    window.status = "code:" + code + "; value:" + numobj.value;
    var position = digitalTag_getPos(numobj);
    if (position == 0 && numobj.value.length > 0 && (code == 48 || code == 96)) 
    {
        return false;
    }
    
    if (numobj.value == '0' && position > 0) 
    {
        return false;
    }
    
}

function createTablePopupMenu(elem, evt)
{
	if (elem != null)
	{
		handleCellEdit(elem, TABLE_CONSTANT.BEFOREEDIT);
	}
	if (elem.editElement.type == "select")
	{
		removejsDOMmenu();
		var selectElem = elem.editElement;
		var cursorMenu1 = new jsDOMenu(150);
		var options = elem.editElement.element.options;
		var len = options.length;
		for ( var i = 0; i < len; i++)
		{
			cursorMenu1.addMenuItem(new menuItem(options[i].text, "",
					setOptionValue,
					[ options[i].text, options[i].value, elem ], true,
					"jsdomenuitem jsdomenuitemnowrap",
					"jsdomenuitemover jsdomenuitemnowrap"));
		}
		setPopUpMenu(cursorMenu1);
		showMenu(evt);
	}
	else if (elem.editElement.type == "text")
	{
		hideMenu();
		elem.appendChild(elem.editElement.element);
		editor = elem.editElement.element;
		if (elem.showElement.getValue() == " ")
		{
			elem.editElement.setValue("");
		}
		else
		{
			elem.editElement.setValue(elem.showElement.getValue());
		}
		if (isIE)
		{
			editor.style.position = "absolute";
		}
		else
		{
			elem.showElement.element.style.display = "none";
		}

		editor.style.border = "2px solid red";

		editor.style.width = elem.offsetWidth < 120 ? elem.offsetWidth : 120;
		if (!isIE)
		{
			editor.style.width = elem.offsetWidth < 120 ? elem.offsetWidth - 5
					: 120;
		}
		if (isIE)
		{
			editor.style.left = getEditorLeftPos(parseInt(editor.style.width),
					elem, evt)
					+ elem.parent.bodyPack.scrollLeft;
		}
		else
		{
			editor.style.left = getEditorLeftPos(parseInt(editor.style.width),
					elem, evt);
			editor.style.top = getEditorTopPos(elem, evt);
		}

		if ($("tablecomponent"))
		{
			editor.style.left = parseInt(editor.style.left)
					+ $("tablecomponent").scrollLeft;
		}

		editor.style.display = "";
		editor.style.zIndex = "200";
		editor.focus();
	}
	else if (elem.editElement.type == "combobox")
	{
		removejsDOMmenu();
		var selectElem = elem.editElement;
		var cursorMenu1 = new jsDOMenu(150);
		var options = elem.editElement.element.parent.selview.options;
		var len = options.length;
		for ( var i = 0; i < len; i++)
		{
			cursorMenu1.addMenuItem(new menuItem(options[i].text, "",
					setOptionValue,
					[ options[i].value, options[i].value, elem ], true,
					"jsdomenuitem jsdomenuitemnowrap",
					"jsdomenuitemover jsdomenuitemnowrap"));
		}
		setPopUpMenu(cursorMenu1);
		showMenu(evt);
	}
}
