var winurlobj = getNeProperty(self);

var ids = null;
var hasApplyRight = true;

var hlStation = [];
hlStation[0] = RESOURCE["high"];
hlStation[1] = RESOURCE["low"];

var loopBack = [];
loopBack[0] = RESOURCE["notLoopBack"];
loopBack[1] = RESOURCE["inLoopBack"];
loopBack[2] = RESOURCE["outLoopBack"];

var workStatus = [];
workStatus[0] = RESOURCE["notWork"];
workStatus[1] = RESOURCE["Work"];

var quipType = [];
quipType[5] = RESOURCE["sdh"];
quipType[10] = RESOURCE["pdh"];

var hlStation = [];
hlStation[5] = RESOURCE["lStation"];
hlStation[10] = RESOURCE["hStation"];

var switchStatus = [];
switchStatus[0] = RESOURCE["closed"];
switchStatus[1] = RESOURCE["opened"];

var powerGrade = [];
    powerGrade[5] = RESOURCE["Standard"];
    powerGrade[10] = RESOURCE["High"];

var BDTpye = [];
    BDTpye[0] = RESOURCE["fixed"];
    BDTpye[1] = RESOURCE["max"];


function initpage()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTableOduPageSbyfunTHead");
    st.body.setAttribute("id", "htmlTableOduPageSbyfunTBody");
    newtc = new TableConf();
    st.setImage("../../../../images/");
    st.setBodyHeight("290px");
    tc = window.tableconf[0];
    var selectedItem = winurlobj["selectedItem"];
    ids = getIDs();
    initTableHead();

    createTableHead(st, newtc);
    
     if(isIE)
    {
    	$("tablecomponent").style.width = "100%";
    	$("buttons").style.width = "100%";
    }
    else
    {
    	$("tablecomponent").style.width = "98%";
    	$("buttons").style.width = "98%";
    }
    
    document.getElementById("tablecomponent").appendChild(st.getTable());
    st.setOnCellEditHandler(cellEditHandler);//         
    st.setBodyHeight(getTableHeight($("tablecomponent"),st)+"px");
    $("tablecomponent").oncontextmenu=popupMenuHandler; 
 	  $("querybtn").value=RESOURCE["querybutton"];
	  $("applybtn").value=RESOURCE["applybutton"];
    sendRightInfo();
    
    if(!$("querybtn").disabled)
    {
    	sendQueryInfo();
    }
}

function changeTableHead(selectAttr)
{
	  st.deleteHeadRow();
	  st.element.colsArray.length = 0;
	  newtc.colArray.length = 0;
    
      initTableHead(selectAttr);
      createTableHead(st, newtc);
    
      st.clearTableData();
      sendQueryInfo();
}

function initTableHead(selectAttr)
{
   
    var flag = false;

	var selectedItem;

    if(null == selectAttr)
    {
    	selectedItem = winurlobj["selectedItem"];
    }
    else
    {
    	selectedItem = selectAttr;
    }
    
    for(var i=0;i<window.tableconf.length;i++)
    {
        for(var j=0;j<window.tableconf[i].colArray.length;j++)
	    {   
	    	if(window.tableconf[i].colArray[j].id != selectedItem)
	    	{
	    		continue;
	    	}
	    	
    		newtc.colArray[0]=window.tableconf[i].colArray[0];
    		switch(selectedItem)
    		{
    			case "W32BRD_ATTR_TRANSMITFRE":
    			newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_TRINTERVAL":
    			newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_WORKSTATUS":
    			newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_ACTTRINTERVAL":
    			newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_ACTTRANSMITFRE":
    			newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_ACTTRECEIVEFRE":
    			newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_WORKRANGE":
    			    newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    		    case "W32BRD_ATTR_TRANSMITPOWER":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    		    case "W32BRD_ATTR_MAXTRANSMITPOWER":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    		    case "W32BRD_ATTR_TXTHRESHOLDHIGH":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    		    case "W32BRD_ATTR_TXTHRESHOLDLOW":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    		    case "W32BRD_ATTR_RXTHRESHOLDHIGH":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    		    case "W32BRD_ATTR_RXTHRESHOLDLOW":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_ACTTRANSMITPOWER":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_ACTRECEIVEPOWER":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_ACTRANGEOFPOWER":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_FREQUENCY":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_QUIPTYPE":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_TRINTERVALP":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_INTERFREBANDWIDTH":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_HLSTATION":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_POWEROUTPUT":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_FACTORYCODE":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_PRODUCETIME":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break;
    			
    			case "W32BRD_ATTR_PRODUCESN":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break
    			
    			case "W32BRD_ATTR_RFLOOPBACK":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break
    			   			
    			case "W32BRD_ATTR_FACTORYINFO":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break
    			   			
    			case "W32BRD_ATTR_SWITCHSTATUS":
    			   newtc.colArray[1] = window.tableconf[i].colArray[j];
    			break
    			 			
    			default:
    			newtc.colArray[1]=window.tableconf[i].colArray[j];
    			break;
    		}
    		flag = true;
    		break;
       }
       if(flag)
       {
       	break;
       }
    }
    newtc.colArray[1].width = "10%";
}

/**
 * key       
 * i  i   
 * j      j 
 */
function addHiddenCol(key,i,j)
{
	index = window.tableconf[i].getIndexByid(key);
	newtc.colArray[j]=window.tableconf[i].colArray[index];
	newtc.colArray[j].width = 0;
}

function sendQueryInfo()
{
	  $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var neid = winurlobj["neid"];
    var slotid = winurlobj["slotid"];
    
    var xmlstr = createQueryXML(neid,slotid,newtc);

    urlreq ="../../../../neExlorerServlet?sfid="+QUERY_ODU_INTERFACE+"&nmUser="+winurlobj["nmUser"];

    loadXMLdoc(urlreq, "POST",true,queryCallBack,null,"inputdata="+xmlstr);
}

function sendSetInfo()
{
	
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;

	var colid = newtc.getColId(1);
	if("W32BRD_ATTR_TRANSMITFRE" == colid)
    {
        for (var i=0,size = st.getDataRowLength();i<size; i++)
	    {
	    	if (!event)
	        {
	    		event = window.event;
	        }	
	    }
    }
    
    if("W32BRD_ATTR_TRANSMITFRE" == colid||"W32BRD_ATTR_TRINTERVAL" == colid)
    {
    	var cell = st.getCell(0,colid);
    	var storeValue = st.getCell(0,colid).element.showElement.getValue();
    	st.setCellValue(cell,colid,storeValue.replace(".", ""));
    }
    
	var neid = winurlobj.neid;
	var xmlStr = createSetXML(neid,st,newtc);
	if(null == xmlStr)
	{
		$("querybtn").disabled = false;
    	$("applybtn").disabled = false;   
        return;
	}
	urlreq ="../../../../neExlorerServlet?sfid="+SET_ODU_INTERFACE+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(urlreq, "POST",true,setCallBack,null,"inputdata="+xmlStr);
}

    
function setCallBack(doc)
{
    $("querybtn").disabled = false;
    var data = EncapsulateData(doc);
    if(data.getSErrorCode() != 0)
    {
    	showErrorDialog(newtc,data);
    	$("applybtn").disabled = false;
    	return;
    }
    
    refreshTableState(st,newtc,data);
}

function createSetXML(neid,st,tc)
{  
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var colid = null;
    var key = null;
    var colkeyarray = null;
    var cellModifyFlag = false;
    var portid = null;
    var index = 0;
    for(var rowindex = 0,rowlen = st.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(!st.getModify(rowindex))
    	{
    		continue;
    	}
    	row = new tagElement("row-params");
    	param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",neid); 
	    row.appendChild(param);	
    	for(var colindex = 0,collen = st.getColumnCount();colindex<collen;colindex++)
    	{
    		colid = tc.getColId(colindex);
    		cellModifyFlag = st.getCellModify(rowindex,colid);
    		colkeyarray = tc.getColKeyArray(colindex);
    		for(var keyindex = 0,keylen = colkeyarray.length;keyindex<keylen;keyindex++)
    		{
    			param = new tagElement("param");
    			
    			key = colkeyarray[keyindex].name;
    			
    			if("neid" == key)
    			{
    				continue;
    			}
    			    			
    		  if("W32BRD_ATTR_TRANSMITPOWER"==key || "W32BRD_ATTR_MAXTRANSMITPOWER"==key)
    			{   
    			    param.setAttribute("name",key);
    				  param.setAttribute("value",(st.getCellStoreValue(rowindex,colid,key)*10));
    			}
    			else
    			{
    		    param.setAttribute("name",key);
    		    param.setAttribute("value",st.getCellStoreValue(rowindex,colid,key));
    			}

    			param.setAttribute("modifyFlag",cellModifyFlag); 
    			row.appendChild(param);		
    			 
    		}    		
    	}
    	bussiness.appendChild(row);
    } 
    if(0 == bussiness.childNodes.length)
    {
    	alert(RESOURCE["nochange"]);
    	return;
    }  
     di.getRoot().appendChild(bussiness);
     return di.toString();
}


function queryCallBack(doc)
{
	$("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    if(data.getSErrorCode() != 0)
    {
    	showErrorDialog(newtc,data);
    	return;
    }
    
    for(var i = 0; i <  data.getDataRowLength(); i++)
    {
        diobj = data.rows[i];
        
        if(null != diobj["LOWFRE"] && "/" != diobj["LOWFRE"].value)
        {
        	var value = diobj["LOWFRE"].value;
	        if("-1" != value && "/" != value)
		    {			   
			    value = "[" + value + ","+ diobj["W32BRD_ATTR_WORKRANGE"].value + "]";				
			}
			diobj["LOWFRE"].value = value;
        }
        
        if(null != diobj["LOWPOWER"] && "/" != diobj["LOWPOWER"].value)
        {
        	var value = diobj["LOWPOWER"].value;
	        if("-1" != value && "/" != value)
		      {			                                   
				     var hightrfe =diobj["W32BRD_ATTR_ACTRANGEOFPOWER"].value;                                
				     value = "[" + value + ","+ hightrfe + "]";				
			    }
			    diobj["LOWPOWER"].value = value;
        }

    }
    
    st.editdom = null;
    createGenCfgTableBody(st, newtc, data, RESOURCE);
    
    if(!st.element.colsArray.selectedId)
    {
  	   st.element.colsArray.selectedId = "board";
  	   st.element.colsArray.imgflag = 1;
    }
    var td=st.element.headRow.element.cols[st.element.colsArray.selectedId].element; 
    st.sortRows(td,st.element.colsArray.imgflag);
    
    addListener();
    
    if(data.getSErrorCode() == 0)
    {
    	return;
    }
    
    showErrorDialog(newtc,data);
}

function addListener()
{
	var colid = newtc.getColId(1);
	var cellEdit = st.getCellEdit(0,colid);
	
	switch(colid)
	{
		case "W32BRD_ATTR_TRANSMITFRE"://    
		textCheck(cellEdit.element,"0","4294967.295", 3);
   	break;
		
		case "W32BRD_ATTR_TRINTERVAL"://T/R  
		textCheck(cellEdit.element,"0","4294967.295", 3);
		break;
		
		case "W32BRD_ATTR_TRANSMITPOWER"://    
		textCheck(cellEdit.element,"-10.0","35.0");
		break;
		
		case "W32BRD_ATTR_MAXTRANSMITPOWER"://      
		textCheck(cellEdit.element,"-10.0","35.0");
		break;
		
		case "W32BRD_ATTR_TXTHRESHOLDHIGH"://       
		textCheck(cellEdit.element,"-10.0","35.0");
		break;
		
		case "W32BRD_ATTR_TXTHRESHOLDLOW"://       
		textCheck(cellEdit.element,"-10.0","35.0");
		break;
		
		case "W32BRD_ATTR_RXTHRESHOLDHIGH"://       
		textCheck(cellEdit.element,"-90.0","-20.0");
		break;
		
		case "W32BRD_ATTR_RXTHRESHOLDLOW"://       
		textCheck(cellEdit.element,"-90.0","-20.0");
		break;
		
		case "W32BRD_ATTR_RFLOOPBACK"://    
	    var rfLoopback = st.getCellEdit(0,"W32BRD_ATTR_RFLOOPBACK");
		var rfLoopbackValue = st.getCellStoreValue(0,"W32BRD_ATTR_RFLOOPBACK","W32BRD_ATTR_RFLOOPBACK");
		var rfLoopbackShow = st.getCellShow(0,"W32BRD_ATTR_RFLOOPBACK");
		
		if("/" == rfLoopbackValue || null == rfLoopbackValue || "-" == rfLoopbackValue)
		{
			cell = st.getCell(i,"W32BRD_ATTR_RFLOOPBACK");
		    st.setCellIsEdit(cell,0);
	        cell.element.style.backgroundColor = "";
	        cell.element.ondblclick = null;	
		}
		break;
		
		default:
		    break;
		
	}
} 

function getIDs()
{
	var ids = new Array();
	for(var i=0,len=tc.getColsLength();i<len;i++)
	{
		ids[ids.length] = tc.getColId(i);
	}
	return ids;
}

/**
 *               
 * @param  
 * @return  
 */
function cellEditHandler()
{ 
	if(hasApplyRight)
	{
		$("applybtn").disabled = false; 
	}
} 
  
function showErrorDialog(tc,data)
{ 
    var errArr = [];
    var errorObj = null;
    for(var i = 0, len = data.getBErrLength(); i < len; i++)
	{	
		errorObj = data.getError().rowErrors[i].errorObj;
		
		if(errorObj["attrId"] == "W32PORT_ATTR_NAME")
		{
			errorObj["attrId"] = getAttrName(tc,data.getError().getRowKey(i,"attrId"));
		}
		else
		{
			errorObj["attrId"] = getAttrName(tc,tc.colArray[1].name);
		}
		
		if(errorObj["port"] == "0"||errorObj["port"] == null)
		{
			
			errorObj["operationObj"] = errorObj["nename"]+"-"+errorObj["slotid"]+"-"+errorObj["boardname"]+"-"+errorObj["attrId"];
		}
		else
		{
			if(errorObj["path"] == "0"||errorObj["path"] == null)
			{
				errorObj["operationObj"] = errorObj["nename"]+"-"+errorObj["slotid"]+"-"+errorObj["boardname"]+"-"+
				                           "-"+errorObj["portname"]+"-"+errorObj["attrId"];
			}
			else
			{
				errorObj["operationObj"] = errorObj["nename"]+"-"+errorObj["slotid"]+"-"+errorObj["boardname"]+
		                           "-"+errorObj["portname"]+"-"+errorObj["path"]+errorObj["attrId"];
			}
			
		}

	}
	
    errArr[0] = "operationObj";
    openErrPage("../../../../page/", data.getError(), errArr);
    errArr = null;
}

/**
 *       
 * @param  
 * @return  
 */ 
function sendRightInfo()
{
	var url = "../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML());
}

/**
 *           XML
 * @param  
 * @return  
 */ 
function createRightXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","querybtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",QUERY_ODU_INTERFACE);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","applybtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",SET_ODU_INTERFACE);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
		
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

/**
 *           
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
    
	for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
    	var right = data.getDataRowParam(i,"right");
    	
    	if(0 == right)
    	{
    		$(data.getDataRowParam(i,"btnID")).disabled = true;
    	} 
    	else
    	{
    		$(data.getDataRowParam(i,"btnID")).disabled = false;
    	}        
    }   
}

/**
 *      
 */
window.onresize=function()
{
	 st.setBodyHeight(getTableHeight($("tablecomponent"),st)+"px");
}

function lowpowerConvert(value)
{
	if("-1" == value || "/" == value)
	{
		value = null;
	}
	else
	{   
		var tmpvalue = (parseInt(value) - 65536)/10;
		value = "[" + tmpvalue + ",";
	}
	return value;
}

function higpowerConvert(value)
{   
	if("-1" == value || "/" == value)
	{
		value = null;
	}
	else
	{
		var tmpvalue = parseInt(value)/10;
		value = tmpvalue + "]";
	}
	return value;
}

function lowfreConvert(value)
{
	if("-1" == value || "/" == value)
	{
		value = null;
	}
	else
	{
		var tmpvalue = parseInt(value)/10;
		value = "[" + tmpvalue + ",";
	}
	return value;
}

function higfreConvert(value)
{   
	if("-1" == value || "/" == value)
	{
		value = null;
	}
	else
	{
		var tmpvalue = parseInt(value)/10;
		value = tmpvalue +"]";
	}
	return value;
}
