var winurlobj = getNeProperty(self);

var ids = null;

var hasApplyRight = true;

var loopBack = [];
    loopBack[0] = RESOURCE["notLoopBack"];
    loopBack[1] = RESOURCE["inLoopBack"];
    loopBack[2] = RESOURCE["outLoopBack"];

var workStatus = [];
    workStatus[0] = RESOURCE["notWork"];
    workStatus[1] = RESOURCE["Work"];

var switchStatus = [];
    switchStatus[0] = RESOURCE["closed"];
    switchStatus[1] = RESOURCE["opened"];

var quipType = [];
    quipType[5] = RESOURCE["sdh"];
    quipType[10] = RESOURCE["pdh"];
var hlStation = [];
    hlStation[5] = RESOURCE["lStation"];
    hlStation[10] = RESOURCE["hStation"];
    
var powerGrade = [];
    powerGrade[5] = RESOURCE["Standard"];
    powerGrade[10] = RESOURCE["High"];

var BDTpye = [];
    BDTpye[0] = RESOURCE["fixed"];
    BDTpye[1] = RESOURCE["max"];

/**
 * TAB         
 * @param   
 * @return  
 */
function tabSelectHandler()
{
  st.setBodyHeight(getComponetHeight($("tablecomponent"),100)+"px");  
  if(!$("querybtn").disabled)
  {
      sendQueryInfo();
  }    
}    

function initpage()
{   
    st = new SortTable();
    st.head.setAttribute("id", "htmlTableOduinterfaceAttriTHead");
    st.body.setAttribute("id", "htmlTableOduinterfaceAttriTBody");
    st.setImage("../../../../images/");
    
    tc = window.tableconf[0];
    var attrArr = getNeProperty(self)["supportAttr"].split(",");
    
    filterAttrCol(tc,attrArr);
    ids = getIDs();
    
    if(ids.contains("W32BRD_ATTR_PRODUCETIME"))
    {
    	$("applybtn").style.display = "none";  
    }
    createTableHead(st, tc);
      
    st.setOnCellEditHandler(cellEditHandler);//         
    
     if(isIE)
    {
    	$("tablecomponent").style.width = "100%";
    	$("buttons").style.width = "100%";
    }
    else
    {
    	$("tablecomponent").style.width = "98%";
    	$("buttons").style.width = "98%";
    }
    
    document.getElementById("tablecomponent").appendChild(st.getTable());

    window.onresize=function()
    {
	   st.setBodyHeight(getTableHeight($("tablecomponent"),st)+"px");
    }
    $("tablecomponent").oncontextmenu=popupMenuHandler; 
		
    $("querybtn").value=RESOURCE["querybutton"];
	$("applybtn").value=RESOURCE["applybutton"];
    sendRightInfo();
}

function sendQueryInfo()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	
    var neid = winurlobj.neid;
    var slotid = winurlobj.slotid;
    var xmlstr = createQueryXML(neid,slotid,tc);
    
    urlreq ="../../../../neExlorerServlet?sfid="+QUERY_ODU_INTERFACE+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,queryCallBack,null,"inputdata="+xmlstr);
}

function queryCallBack(doc)
{   
	$("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    if(data.getSErrorCode() == 2)
    {
    	showErrorDialog(data);
    	return;
    }
    for(var i = 0; i <  data.getDataRowLength(); i++)
    {
    	
        var diobj = data.rows[i];
        
        if(null != diobj["LOWFRE"] && "/" != diobj["LOWFRE"].value)
        {
        	var value = diobj["LOWFRE"].value;
	        if("-1" != value && "/" != value)
		      {			   				   
			     value = "[" + value + ","+ diobj["W32BRD_ATTR_WORKRANGE"].value + "]";				
			  }
			  diobj["LOWFRE"].value = value;
        }
        
        if(null != diobj["LOWPOWER"] && "/" != diobj["LOWPOWER"].value)
        {
        	var value = diobj["LOWPOWER"].value;
	        if("-1" != value && "/" != value)
		      {			                                   
				     var hightrfe =diobj["W32BRD_ATTR_ACTRANGEOFPOWER"].value;                                
				     value = "[" + value + ","+ hightrfe + "]";				
			    }
			    diobj["LOWPOWER"].value = value;
        }
        
        if(null != diobj["W32BRD_ATTR_TRINTERVALP"])
        {
        	var value = diobj["W32BRD_ATTR_TRINTERVALP"].value;
        	diobj["W32BRD_ATTR_TRINTERVALP"].value = value/1000;
        }
    
    }
 
    createGenCfgTableBody(st, tc, data, RESOURCE);
    
    addListener();
    
    if(data.getSErrorCode() == 0)
    {
    	return;
    }
    
    showErrorDialog(data);
}

function addListener()
{
	var cell;
	var cellEdit;
	for(var i = 0,len = st.getDataRowLength(); i < len; i++)
	{
		if(ids.contains("W32BRD_ATTR_TRANSMITFRE"))
		{
			var radioLinkid = st.getCellEdit(i,"W32BRD_ATTR_TRANSMITFRE"); 
			textCheck(radioLinkid.element,"0","4294967.295", 3);
		}
		if(ids.contains("W32BRD_ATTR_TRINTERVAL"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_TRINTERVAL");
			textCheck(trinterval.element,"0","4294967.295", 3);
		}
		if(ids.contains("W32BRD_ATTR_TRANSMITPOWER"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_TRANSMITPOWER");
			var cellShow = st.getCellShow(i,"W32BRD_ATTR_TRANSMITPOWER");
			if(trinterval.value == "/")
			{
				trinterval.element.ondblclick = function()
				{
					cellShow.setValue("0");
	        		st.setCellValue(trinterval,"W32PORT_ATTR_WAYSIDEINPUT","0");
				}
			}
			textCheck(trinterval.element,"-10.0","35.0");
		}
		
		if(ids.contains("W32BRD_ATTR_MAXTRANSMITPOWER"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_MAXTRANSMITPOWER");
			var cellShow = st.getCellShow(i,"W32BRD_ATTR_MAXTRANSMITPOWER");
			if(trinterval.value == "/")
			{
				trinterval.element.ondblclick = function()
				{
					cellShow.setValue("0");
	        		st.setCellValue(trinterval,"W32BRD_ATTR_MAXTRANSMITPOWER","0");
				}
			}
			textCheck(trinterval.element,"-10.0","35.0");
		}
		
		if(ids.contains("W32BRD_ATTR_TXTHRESHOLDHIGH"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_TXTHRESHOLDHIGH");
			var cellShow = st.getCellShow(i,"W32BRD_ATTR_TXTHRESHOLDHIGH");
			if(trinterval.value == "/")
			{
				trinterval.element.ondblclick = function()
				{
					cellShow.setValue("0");
	        		st.setCellValue(trinterval,"W32PORT_ATTR_WAYSIDEINPUT","0");
				}
			}
			textCheck(trinterval.element,"-10.0","35.0");
		}
		
		if(ids.contains("W32BRD_ATTR_TXTHRESHOLDLOW"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_TXTHRESHOLDLOW");
			var cellShow = st.getCellShow(i,"W32BRD_ATTR_TXTHRESHOLDLOW");
			if(trinterval.value == "/")
			{
				trinterval.element.ondblclick = function()
				{
					cellShow.setValue("0");
	        		st.setCellValue(trinterval,"W32PORT_ATTR_WAYSIDEINPUT","0");
				}
			}
			textCheck(trinterval.element,"-10.0","35.0");
		}
		
		if(ids.contains("W32BRD_ATTR_RXTHRESHOLDHIGH"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_RXTHRESHOLDHIGH");
			var cellShow = st.getCellShow(i,"W32BRD_ATTR_RXTHRESHOLDHIGH");
			if(trinterval.value == "/")
			{
				trinterval.element.ondblclick = function()
				{
					cellShow.setValue("0");
	        		st.setCellValue(trinterval,"W32PORT_ATTR_WAYSIDEINPUT","0");
				}
			}
			textCheck(trinterval.element,"-90.0","-20.0");
		}
		
		if(ids.contains("W32BRD_ATTR_RXTHRESHOLDLOW"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_RXTHRESHOLDLOW");
			var cellShow = st.getCellShow(i,"W32BRD_ATTR_RXTHRESHOLDLOW");
			if(trinterval.value == "/")
			{
				trinterval.element.ondblclick = function()
				{
					cellShow.setValue("0");
	        		st.setCellValue(trinterval,"W32PORT_ATTR_WAYSIDEINPUT","0");
				}
			}
			textCheck(trinterval.element,"-90.0","-20.0");
		}
		
		if(ids.contains("W32BRD_ATTR_ACTRECEIVEPOWER"))
		{
			initautoquery(winurlobj.slotid);
		}
		
		if(ids.contains("W32BRD_ATTR_RFLOOPBACK"))
		{
			var rfLoopback = st.getCellEdit(i,"W32BRD_ATTR_RFLOOPBACK");
			var rfLoopbackValue = st.getCellStoreValue(i,"W32BRD_ATTR_RFLOOPBACK","W32BRD_ATTR_RFLOOPBACK");
			var rfLoopbackShow = st.getCellShow(i,"W32BRD_ATTR_RFLOOPBACK");
			
			if("/" == rfLoopbackValue || null == rfLoopbackValue || "-" == rfLoopbackValue)
			{
				cell = st.getCell(i,"W32BRD_ATTR_RFLOOPBACK");
			    st.setCellIsEdit(cell,0);
		        cell.element.style.backgroundColor = "";
		        cell.element.ondblclick = null;	
			}
		}
	}
}

/**
 *         
 */
function updataPower(power)
{
	var receivePowerCellShow = st.getCellShow(0,"W32BRD_ATTR_ACTRECEIVEPOWER");
	receivePowerCellShow.setValue(power);
}

function sendSetInfo()
{
	
	
	var ids = getIDs();
	if(ids.contains("W32BRD_ATTR_TRANSMITPOWER") && ids.contains("W32BRD_ATTR_MAXTRANSMITPOWER"))
	{
		var tranPower = st.getCell(0,"W32BRD_ATTR_TRANSMITPOWER").element.showElement.getValue();
		var maxTranPower = st.getCell(0,"W32BRD_ATTR_MAXTRANSMITPOWER").element.showElement.getValue();
		if(parseFloat(tranPower) > parseFloat(maxTranPower))
		{
			alert(RESOURCE["tranpowervalid"]);
			return;
		}
	}
	
	$("querybtn").disabled = true;
    $("applybtn").disabled = true;
	
	if(ids.contains("W32BRD_ATTR_TRANSMITPOWER"))
    {
    	var cell = st.getCell(0,"W32BRD_ATTR_TRANSMITPOWER");
    	var storeValue = st.getCell(0,"W32BRD_ATTR_TRANSMITPOWER").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_TRANSMITPOWER",storeValue.replace(".", ""));
    }
    
	if(ids.contains("W32BRD_ATTR_MAXTRANSMITPOWER"))
    {
    	var cell = st.getCell(0,"W32BRD_ATTR_MAXTRANSMITPOWER");
    	var storeValue = st.getCell(0,"W32BRD_ATTR_MAXTRANSMITPOWER").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_MAXTRANSMITPOWER",storeValue.replace(".", ""));
    }
    
    if(ids.contains("W32BRD_ATTR_TXTHRESHOLDHIGH") || ids.contains("W32BRD_ATTR_TXTHRESHOLDLOW"))
    {
    	var cell = st.getCell(0,"W32BRD_ATTR_TXTHRESHOLDHIGH");
    	var storeValue = st.getCell(0,"W32BRD_ATTR_TXTHRESHOLDHIGH").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_TXTHRESHOLDHIGH",storeValue.replace(".", ""));
    	
    	cell = st.getCell(0,"W32BRD_ATTR_TXTHRESHOLDLOW");
      storeValue = st.getCell(0,"W32BRD_ATTR_TXTHRESHOLDLOW").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_TXTHRESHOLDLOW",storeValue.replace(".", ""));
    }    
    
    if(ids.contains("W32BRD_ATTR_RXTHRESHOLDHIGH") || ids.contains("W32BRD_ATTR_RXTHRESHOLDLOW"))
    {
    	var cell = st.getCell(0,"W32BRD_ATTR_RXTHRESHOLDHIGH");
    	var storeValue = st.getCell(0,"W32BRD_ATTR_RXTHRESHOLDHIGH").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_RXTHRESHOLDHIGH",storeValue.replace(".", ""));
    	
    	cell = st.getCell(0,"W32BRD_ATTR_RXTHRESHOLDLOW");
    	storeValue = st.getCell(0,"W32BRD_ATTR_RXTHRESHOLDLOW").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_RXTHRESHOLDLOW",storeValue.replace(".", ""));
    }

    if(ids.contains("W32BRD_ATTR_TRANSMITFRE"))
    {
    	var cell = st.getCell(0,"W32BRD_ATTR_TRANSMITFRE");
    	var storeValue = st.getCell(0,"W32BRD_ATTR_TRANSMITFRE").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_TRANSMITFRE",storeValue.replace(".", ""));
    }
    
    if(ids.contains("W32BRD_ATTR_TRINTERVAL"))
    {
    	var cell = st.getCell(0,"W32BRD_ATTR_TRINTERVAL");
    	var storeValue = st.getCell(0,"W32BRD_ATTR_TRINTERVAL").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_TRINTERVAL",storeValue.replace(".", ""));
    }
    
    if(ids.contains("W32BRD_ATTR_TRANSMITFRE"))
    {
      for (var i=0,size = st.getDataRowLength();i<size; i++)
	  {
	   	if (!event)
	    {
	  	 	event = window.event;
	    }	
      }
    }
	
	var neid = winurlobj.neid;
	var xmlStr = createSetXML(neid,st,tc);
	if(null == xmlStr)
	{
		$("querybtn").disabled = false;
   		$("applybtn").disabled = false;
        return;
	}
	
	urlreq ="../../../../neExlorerServlet?sfid="+SET_ODU_INTERFACE+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(urlreq, "POST",true,setCallBack,null,"inputdata="+xmlStr);
}

function setCallBack(doc)
{
	var data = EncapsulateData(doc);
	$("querybtn").disabled = false;
    if(data.getSErrorCode() != 0)
    {
    	showErrorDialog(data);
	    $("applybtn").disabled = false;
    }
    refreshTableState(st,tc,data);
}

function getIDs()
{
	var ids = new Array();
	for(var i=0,len=tc.getColsLength();i<len;i++)
	{
		ids[ids.length] = tc.getColId(i);
	}
	return ids;
}


function showErrorDialog(data)
{
    var errArr = [];
    var errorObj = null;
    for(var i = data.getBErrLength()-1; i >= 0; i--)
    {	
		    errorObj = data.getError().rowErrors[i].errorObj;
	      if(errorObj["attrId"] == "W32BRD_ATTR_WORKRANGE")
	      {
	       errorObj["attrId"] = RESOURCE["W32BRD_ATTR_WORKRANGE"];
	      }
	      else if(errorObj["attrId"] == "W32BRD_ATTR_ACTRANGEOFPOWER")
	      {
	          errorObj["attrId"] = RESOURCE["W32BRD_ATTR_ACTRANGEOFPOWER"];
	      }
	      else if((errorObj["attrId"] == "port") || (errorObj["attrId"] == "sendpower"))
	      {	
	    	    data.getError().rowErrors.removeAt(i);	
	    	    continue;	
	      }			 
	      else
	      {
	   		    errorObj["attrId"] = getAttrName(tc,data.getError().getRowKey(i,"attrId"));
		    }

		    errorObj["operationObj"] = errorObj["nename"]+"-"+errorObj["slotid"]+"-"+errorObj["boardname"]+
		                          "-"+errorObj["attrId"];		
    }
    	
    errArr[0] = "operationObj";
    openErrPage("../../../../page/", data.getError(), errArr);
    errArr = null;
}

/**
 *               
 * @param  
 * @return  
 */
function cellEditHandler()
{
	if(hasApplyRight)
	{
		$("applybtn").disabled = false; 
	}
}


function lowpowerConvert(value)
{
	if("-1" == value || "/" == value)
	{
		value = null;
	}
	else
	{   
		var tmpvalue = (parseInt(value) - 65536)/10;
		value = "[" + tmpvalue + ",";
	}
	return value;
}

function higpowerConvert(value)
{   
	if("-1" == value || "/" == value)
	{
		value = null;
	}
	else
	{
		var tmpvalue = parseInt(value)/10;
		value = tmpvalue + "]";
	}
	return value;
}

function lowfreConvert(value)
{
	if("-1" == value || "/" == value)
	{
		value = null;
	}
	else
	{
		var tmpvalue = parseInt(value)/10;
		value = "[" + tmpvalue + ",";
	}
	return value;
}

function higfreConvert(value)
{   
	if("-1" == value || "/" == value)
	{
		value = null;
	}
	else
	{
		var tmpvalue = parseInt(value)/10;
		value = tmpvalue +"]";
	}
	return value;
}

/**
 *       
 * @param  
 * @return  
 */ 
function sendRightInfo()
{
	var url = "../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML());
}

/**
 *           XML
 * @param  
 * @return  
 */ 
function createRightXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","querybtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",QUERY_ODU_INTERFACE);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","applybtn");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",SET_ODU_INTERFACE);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
		
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

/**
 *           
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
    
	for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
    	var right = data.getDataRowParam(i,"right");
    	
    	if(0 == right)
    	{
    		$(data.getDataRowParam(i,"btnID")).disabled = true;
    	} 
    	else
    	{
    		$(data.getDataRowParam(i,"btnID")).disabled = false;
    	}        
    }   
}
