
var winobj = getNeProperty(self);
var parentWin = getParentWindow();
var linePGTable; //         
var newLineMspDataXML; //        XML  
var availablePortList = []; //          
var workUnitList = []; //            
var protectUnitList = []; //            

var groupID = 1;
var incomplete = "39486";

var availableChannelList = []; //            


loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);

getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/logicsys/linemsp_" + SYSTEMCONF.getLanguage() + ".xml");
document.title = RESOURCE["createMCPGTitle"];

/**
 *      logString              
 */
var logString = "";

/**
 *      
 * @param  
 * @return  
 */
function initBody(){
    $("boardMapTableTitle").appendChild(document.createTextNode(RESOURCE["boardMapTitle"]));
    $("selectMapDirectTitle").appendChild(document.createTextNode(RESOURCE["mcselectMapDirectTitle"]));
    $("selectMapBoardTitle").appendChild(document.createTextNode(RESOURCE["selectMapBoardTitle"]));
    $("selectedMapBoardTitle").appendChild(document.createTextNode(RESOURCE["selectedMapBoardTitle"]));
    
    $("okBtn").value = RESOURCE["okbutton"];
    $("cancleBtn").value = RESOURCE["cancelbutton"];
    $("applyBtn").value = RESOURCE["applybutton"];
    
    $("selectMapDirect").options[0] = new Option(RESOURCE["westWorkUnit"], WEST_WORK_UNIT);
    $("selectMapDirect").options[1] = new Option(RESOURCE["westProtectUnit"], WEST_PROTECT_UNIT);
    $("selectMapDirect").disabled = true;
    initTable();
    initBoardMap();
    getAvailableChannels();
}

/**
 *          
 * @param  
 * @return  
 */
function initTable(){
    linePGTable = new CTable();
    
    linePGTable.addHead(RESOURCE["attrCol"], RESOURCE["valueCol"]);
    
    var cTableAtom = null;
    var cTableAtomEle = null;
    var cTableAtompg = new Atom("text");
    cTableAtompg.element.setAttribute("id", "htmlSelect_protectgroupid");
    linePGTable.addAttrRow("protectgroupid", RESOURCE["protectgroupid"], cTableAtompg);
    var groupIDList = null;
    var min = 1;
    var max = 255;
    
    groupIDList = getRangeNumber(parentWin.usedPGID, min, max, 1);
    groupID = groupIDList[0];
	
    var cTableAtompeerid = new Atom("text");
    cTableAtompeerid.element.setAttribute("id", "htmlSelect_peerprotectgroupid");
    linePGTable.addAttrRow("peerprotectgroupid", RESOURCE["peerprotectgroupid"], cTableAtompeerid);
    checkText(cTableAtompg.element, min, max);
    checkText(cTableAtompeerid.element, min, max);
    cTableAtom = new Atom("select");
    cTableAtom.element.setAttribute("id", "htmlSelect_prochannelid");
    cTableAtomEle = cTableAtom.element;
    linePGTable.addAttrRow("protocalchannelid", RESOURCE["protocalchannelid"], cTableAtom);
	
    cTableAtom = new Atom("select");
    cTableAtom.element.setAttribute("id", "htmlSelect_netype");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["work"], NETYPE_WORK);
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["protect"], NETYPE_PROTECT);
    cTableAtomEle.onchange = changeUnit;
    linePGTable.addAttrRow("netype", RESOURCE["netype"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtom.element.setAttribute("id", "htmlSelect_protectionTypeLinemspcrt");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["oneplusone"], 0);
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["oneToMore"], 1);
    cTableAtomEle.onchange = protectTypeListener;
    linePGTable.addAttrRow("protectionType", RESOURCE["protectionType"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtom.element.setAttribute("id", "htmlSelect_switchModeLinemspcrt");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["singleSwitch"], 0);
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["bothSwitch"], 1);
    cTableAtomEle.onchange = setApplyEnabled;
    linePGTable.addAttrRow("switchMode", RESOURCE["switchMode"], cTableAtom);
    cTableAtomEle.options[1].selected = true;
	
    cTableAtom = new Atom("select");
    cTableAtom.element.setAttribute("id", "htmlSelect_revertiveModeLinemspcrt");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["Non-Revertive"], 0);
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["Revertive"], 1);
    cTableAtomEle.onchange = revertiveModeListener;
    linePGTable.addAttrRow("revertiveMode", RESOURCE["revertiveMode"], cTableAtom);
    linePGTable.setAttrValue("revertiveMode", REVERTIVE);
	
    cTableAtom = new Atom("text");
    cTableAtom.element.setAttribute("id", "htmlText_revertiveTimeLinemspcrt");
    cTableAtomEle = cTableAtom.element;
    cTableAtom.setValue(DEFAULT_DELAYTIME);
    checkText(cTableAtomEle, MIN_DELAYTIME, MAX_DELAYTIME);
    cTableAtomEle.style.imeMode = "disabled";
    
    linePGTable.addAttrRow("revertiveTime", RESOURCE["revertiveTime"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtom.element.setAttribute("id", "htmlSelect_sdEnableLinemspcrt");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["Disabled"], 0);
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["Enabled"], 1);
    cTableAtomEle.options[1].selected = true; //    
    cTableAtomEle.onchange = setApplyEnabled;
    linePGTable.addAttrRow("sdEnable", RESOURCE["sdEnable"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtom.element.setAttribute("id", "htmlSelect_protocolTypeLinemspcrt");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["NewProtocol"], 1);
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["OldProtocol"], 2);
    cTableAtomEle.onchange = setApplyEnabled;
    linePGTable.addAttrRow("protocolType", RESOURCE["protocolType"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtom.element.setAttribute("id", "htmlSelect_switchTagLinemspcrt");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["Hight-Priority"], 0);
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["Low-Priority"], 1);
    cTableAtomEle.onchange = setApplyEnabled;
    linePGTable.addAttrRow("switchTag", RESOURCE["switchTag"], cTableAtom);
    
    cTableAtom = new Atom("select");
    cTableAtom.element.setAttribute("id", "htmlSelect_switchIndicationLinemspcrt");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["No-Indication"], 0);
    cTableAtomEle.options[cTableAtomEle.options.length] = new Option(RESOURCE["Indication"], 1);
    cTableAtomEle.onchange = setApplyEnabled;
    linePGTable.addAttrRow("switchIndication", RESOURCE["switchIndication"], cTableAtom);
    
    $("textField_active").innerText = RESOURCE["active"];
	
    $("linePGTableArea").appendChild(linePGTable.getTable());
	
    changeUnit(false);
}

/**
 * handle NE Type change
 */
function changeUnit(isAdjust){
    var neType = linePGTable.getAttrValue("netype");
    var displayIndicate = "none";
    if (neType != NETYPE_WORK) {
        displayIndicate = isIE ? "block" : "";
    }
    linePGTable.attrArray["switchMode"].element.parentNode.parentNode.style.display = displayIndicate;
    linePGTable.attrArray["revertiveMode"].element.parentNode.parentNode.style.display = displayIndicate;
    linePGTable.attrArray["revertiveTime"].element.parentNode.parentNode.style.display = displayIndicate;
    linePGTable.attrArray["switchIndication"].element.parentNode.parentNode.style.display = displayIndicate;
    linePGTable.attrArray["switchTag"].element.parentNode.parentNode.style.display = displayIndicate;
    linePGTable.attrArray["protocolType"].element.parentNode.parentNode.style.display = displayIndicate;
    linePGTable.attrArray["sdEnable"].element.parentNode.parentNode.style.display = displayIndicate;
	
    $("active").style.display = displayIndicate;	
    $("textField_active").style.display = displayIndicate;	
    $("selectMapDirect").selectedIndex = linePGTable.getAttrValue("netype");
	
    initBoardMap();
    
    if(isAdjust == null || isAdjust)
    {
        adjustDialog();	
    }
}
	


/**
 *           
 * @param  
 * @return  
 */
function initBoardMap(){
    clearSelectOptions($("availableport"));
    clearSelectOptions($("selectedport"));
    workUnitList = []; //            
    protectUnitList = []; //            
    var availableportObj = $("availableport");
    for (var i = 0; i < parentWin.aviablePort.length; i++) {
        var tmpPort = parentWin.aviablePort[i]
        insertSelectOption(availableportObj, tmpPort.slotid + ":" + tmpPort.port + ":" + tmpPort.boardname + ":" + tmpPort.portname + ":" + tmpPort.subslotid + ":" + tmpPort.subboardname, tmpPort.toString());
    }
}


/**
 * Adjust dialog according the ne type
 */
function adjustDialog() 
{
	var neType = linePGTable.getAttrValue("netype");
	var dialogHeight;
	var screenWidth = window.screen.width;
	var screenHeight = window.screen.height;
	var dialogTop = 0;
	var dialogLeft = 0;
     if (neType == NETYPE_WORK)
     {
        dialogHeight = "560px";
        if (SYSTEMCONF.getLanguage() != "zh") 
        {
            dialogHeight = "500px";
        }
        dialogLeft= screenWidth / 2 - 275;
        dialogTop= screenHeight /2 - 260;
    
     }
     else
     {
        dialogHeight = "780px";
        if (SYSTEMCONF.getLanguage() != "zh")
        {
            dialogHeight = "700px";
        }
        dialogLeft = screenWidth / 2 - 275;
        dialogTop = screenHeight /2 - 340;
     }
	window.dialogTop =  dialogTop + "px";
	window.dialogLeft =  dialogLeft + "px";
	window.dialogHeight = dialogHeight;
}


/**
 *                  
 * @param  
 * @return  
 */
function protectTypeListener(){
    setApplyEnabled();
    linePGTable.setAttrValue("sdEnable", 1);
    linePGTable.setAttrValue("protocolType", 1);
    linePGTable.setAttrValue("switchTag", 0);
    linePGTable.setAttrValue("switchIndication", 1);
    var revertMode = linePGTable.getAtom("revertiveMode");
    var switchMode = linePGTable.getAtom("switchMode");
    var reverTime = linePGTable.getAtom("revertiveTime");
    if (this.value == 0) //1+1  
    {
        linePGTable.setAttrValue("switchTag", 0);
    	linePGTable.setAttrValue("switchIndication", 0);
    	linePGTable.setAttrValue("revertiveMode", 1);
    	linePGTable.setAttrValue("switchMode", 1);    	
    	revertMode.element.disabled = false;
    	switchMode.element.disabled = false;
    	reverTime.element.disabled = false;
    	linePGTable.setAttrValue("revertiveTime", "600");
    }
    else //1:N  
    {
        alert(RESOURCE["MSP_CREATE_WARN"]);
        linePGTable.setAttrValue("switchTag", 0);
    	linePGTable.setAttrValue("switchIndication", 1);
        linePGTable.setAttrValue("revertiveMode", 1);
    	linePGTable.setAttrValue("switchMode", 1);
    	revertMode.element.disabled = true;
    	switchMode.element.disabled = true;
    	reverTime.element.disabled = false;
    	linePGTable.setAttrValue("revertiveTime", "600");
    }
    
    initBoardMap();
}

/**
 *         
 * @param  
 * @return  
 */
function revertiveModeListener(){
	
    setApplyEnabled();
    
    if (this.value == 0) {
        linePGTable.getAtom("revertiveTime").element.disabled = true;
        linePGTable.setAttrValue("revertiveTime", NONE_DELAYTIME);
    }
    else //    
    {
        linePGTable.getAtom("revertiveTime").element.disabled = false;
        linePGTable.setAttrValue("revertiveTime", DEFAULT_DELAYTIME);
    }
}

/**
 *            
 * @param
 * @return
 */
function doCreateLineMsp(isApply){
    if ($("applyBtn").disabled) {
        xcloseDialog();
    }
    var netype = linePGTable.getAttrValue("netype");
	
    if (netype == NETYPE_WORK && workUnitList.length == 0) {
        alert(RESOURCE["INFO_WEST_WORK_NOT_SELECTED"]);
        return;
    }
	
    if (netype == NETYPE_PROTECT && protectUnitList.length == 0) {
        alert(RESOURCE["INFO_WEST_PROTECT_NOT_SELECTED"]);
        return;
    }
    var xmlData = createCreateLineMspXMLInfo();
    if (null == xmlData) {
        return;
    }
    $("okBtn").disabled = true;
    $("cancleBtn").disabled = true;
    $("applyBtn").disabled = true;
    
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_CREATE_MCLINEMSP + "&nmUser=" + parentWin.winobj["nmUser"];
    
    loadXMLdoc(url, "POST", true, callbackCreateLineMsp, isApply, "inputdata=" + xmlData);
    
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createCreateLineMspXMLInfo(){
	logString = "";
    newLineMspDataXML = new inputxml("datainterface");
	
    var _neType = linePGTable.getAttrValue("netype");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", parentWin.winobj["neid"]);
    row.appendChild(param);
    
	groupID = linePGTable.getAttrValue("protectgroupid");
	if(groupID == null || groupID == "") 
	{
		alert(RESOURCE["promptinput"] + " " + RESOURCE["protectgroupid"]);
		linePGTable.getAtom("protectgroupid").element.focus();
		return null;
	}
    param = new tagElement("param");
    param.setAttribute("name", "groupID");
    param.setAttribute("value", linePGTable.getAttrValue("protectgroupid"));
    row.appendChild(param);
    stuffLog(RESOURCE["protectgroupid"], linePGTable.getAttrValue("protectgroupid"));
	
	var peerpgid = linePGTable.getAttrValue("peerprotectgroupid");
	if(peerpgid == null || peerpgid == "") 
	{
		alert(RESOURCE["promptinput"] + " " + RESOURCE["peerprotectgroupid"]);
		linePGTable.getAtom("peerprotectgroupid").element.focus();
		return null;
	}
    param = new tagElement("param");
    param.setAttribute("name", "peergroupID");
    param.setAttribute("value", peerpgid);
    row.appendChild(param);    
	stuffLog(RESOURCE["peerprotectgroupid"], peerpgid);
	
    var prochannel = linePGTable.getAttrValue("protocalchannelid");
    if (prochannel == null || prochannel == "") {
        alert(RESOURCE["promptinput"] + RESOURCE["protocalchannelid"]);
		linePGTable.getAtom("protocalchannelid").element.focus();
        return null;
    }
    param = new tagElement("param");
    param.setAttribute("name", "protocalchannelid");
    param.setAttribute("value", linePGTable.getAttrValue("protocalchannelid"));
    row.appendChild(param);    
	
	stuffLog(RESOURCE["protocalchannelid"], linePGTable.getAttrValue("protocalchannelid"));
    param = new tagElement("param");
    param.setAttribute("name", "netype");
    param.setAttribute("value", _neType);
    row.appendChild(param);    
    stuffLog(RESOURCE["netype"], netype[_neType]);
    param = new tagElement("param");
    param.setAttribute("name", "protectionType");
    param.setAttribute("value", linePGTable.getAttrValue("protectionType"));
    row.appendChild(param);
	
    stuffLog(RESOURCE["protectionType"], protectionType[linePGTable.getAttrValue("protectionType")]);
	
    param = new tagElement("param");
    param.setAttribute("name", "wChannelCount");
    param.setAttribute("value", "1");
    row.appendChild(param);
	
    if (_neType == NETYPE_PROTECT) {
        param = new tagElement("param");
        param.setAttribute("name", "switchMode");
        param.setAttribute("value", linePGTable.getAttrValue("switchMode"));
        row.appendChild(param);
        stuffLog(RESOURCE["switchMode"], switchMode[linePGTable.getAttrValue("switchMode")]);
        param = new tagElement("param");
        param.setAttribute("name", "revertiveMode");
        param.setAttribute("value", linePGTable.getAttrValue("revertiveMode"));
        row.appendChild(param);
        stuffLog(RESOURCE["revertiveMode"], revertiveMode[linePGTable.getAttrValue("revertiveMode")]);
        param = new tagElement("param");
        param.setAttribute("name", "revertiveTime");
        if (linePGTable.getAttrValue("revertiveMode") == 1) {
            param.setAttribute("value", linePGTable.getAttrValue("revertiveTime"));
			stuffLog(RESOURCE["revertiveTime"], linePGTable.getAttrValue("revertiveTime"));
        }
        else //            0
        {
            param.setAttribute("value", "0");
        }
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "sdEnable");
        param.setAttribute("value", linePGTable.getAttrValue("sdEnable"));
        row.appendChild(param);
        stuffLog(RESOURCE["sdEnable"], sdEnable[linePGTable.getAttrValue("sdEnable")]);
        param = new tagElement("param");
        param.setAttribute("name", "protocolType");
        param.setAttribute("value", linePGTable.getAttrValue("protocolType"));
        row.appendChild(param);
        stuffLog(RESOURCE["protocolType"], protocolType[linePGTable.getAttrValue("protocolType")]);
        param = new tagElement("param");
        param.setAttribute("name", "protocolStatus");
        param.setAttribute("value", "254");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "switchTag");
        param.setAttribute("value", linePGTable.getAttrValue("switchTag"));
        row.appendChild(param);
        stuffLog(RESOURCE["switchTag"], switchTag[linePGTable.getAttrValue("switchTag")]);
        param = new tagElement("param");
        param.setAttribute("name", "switchIndication");
        param.setAttribute("value", linePGTable.getAttrValue("switchIndication"));
        row.appendChild(param);
		stuffLog(RESOURCE["switchIndication"], switchIndication[linePGTable.getAttrValue("switchIndication")]);
        param = new tagElement("param");
        param.setAttribute("name", "activationStatus");
        if ($("active").checked) {
            if (confirm(RESOURCE["activeSwitchApply"])) {
                param.setAttribute("value", "1");
				stuffLog( RESOURCE["active"], activationStatus[1]);
            }
            else {
                return null;
            }
        }
        else {
            param.setAttribute("value", "0");
			stuffLog(RESOURCE["isActive"], activationStatus[0]);
        }
		
    	row.appendChild(param);
    } 
    if (linePGTable.getAttrValue("netype") == NETYPE_WORK) {
        param = new tagElement("param");
        param.setAttribute("name", "protectUnit");
        param.setAttribute("value", 1);
        row.appendChild(param);
        
        var workUnit = workUnitList[0].split(":");
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", workUnit[0]);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Wslotid");
        param.setAttribute("value", workUnit[0]);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Wboardname");
        param.setAttribute("value", workUnit[2]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", workUnit[1]);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Wport");
        param.setAttribute("value", workUnit[1]);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Wportname");
        param.setAttribute("value", workUnit[3]);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        param.setAttribute("value", workUnit[4] == 0 ? 255 : workUnit[4]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "Wsubslotid");
        param.setAttribute("value", workUnit[4] == 0 ? 255 : workUnit[4]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "Wsubboardname");
        param.setAttribute("value", workUnit[4] == 0 ? "" : workUnit[5]);
        row.appendChild(param);
		logString += "," + $("selectedport").options[0].innerText;
    }
    else {
        param = new tagElement("param");
        param.setAttribute("name", "protectUnit");
        param.setAttribute("value", 0);
        row.appendChild(param);
        
        var _protectUnit = protectUnitList[0].split(":");
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", _protectUnit[0]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "Pboardname");
        param.setAttribute("value", _protectUnit[2]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", _protectUnit[1]);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "Pportname");
        param.setAttribute("value", _protectUnit[3]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        param.setAttribute("value", _protectUnit[4] == 0 ? 255 : _protectUnit[4]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "Psubboardname");
        param.setAttribute("value", _protectUnit[4] == 0 ? "" : _protectUnit[5]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "PswitchStatue");
        param.setAttribute("value", "0");
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "PendIndication");
        param.setAttribute("value", "");
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "PprotectedUnit");
        param.setAttribute("value", "255");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "WswitchStatue");
        param.setAttribute("value", "0");
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "WendIndication");
        param.setAttribute("value", "");
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "WprotectedUnit");
        param.setAttribute("value", "255");
        row.appendChild(param);
		logString += "," + $("selectedport").options[0].innerText;
    }
    
	var param = new tagElement("param");    
	param.setAttribute("name","opDesc");
    param.setAttribute("value",logString);
    row.appendChild(param);		
			
    bussiness.appendChild(row);
    newLineMspDataXML.getRoot().appendChild(bussiness);
    return newLineMspDataXML.toString();
}

/**
 *               
 * @param doc:          
 * @return  
 */
function callbackCreateLineMsp(doc, isApply){
	$("okBtn").disabled = false;
    $("cancleBtn").disabled = false;
    
    var data = EncapsulateData(doc);
    var errorCode = data.getSErrorCode();
    if (OPERATION_SUCCESS == errorCode) {
        var newLineMspData;
        parentWin.queryPG();
        
        if (!isApply) //               
        {
            xcloseDialog();
        }
        initBoardMap();
    }
    else 
    {
    	var errArr = [];//           
    	for (var i = 0, len = data.getBErrLength(); i < len; i++) {
	        var tempObj = data.getError().rowErrors[i].errorObj;
	        tempObj["groupID"] = RESOURCE["protectgroupid"] + ":" + groupID;
	        errArr[0] = "groupID";//           
    	}
    	openErrPage("../../../../page/", data.getError(), errArr);
        $("applyBtn").disabled = false;
    }
}

/**
 *                  
 * @param   
 * @return   
 */
function removeSelectListData(rightFlag){
    $("applyBtn").disabled = false;
    
    var srcObj;
    var sinkObj;
    
    if (rightFlag) {
        srcObj = $("availableport");
        sinkObj = $("selectedport");
    }
    else {
        srcObj = $("selectedport");
        sinkObj = $("availableport");
    }
    
    if (srcObj.selectedIndex == -1) {
        alert(RESOURCE["ID_SELECT"]);
        return;
    }
    
    var option = null;
    
    for (var i = 0; i < srcObj.options.length; i++) {
        var showText = srcObj.options[i].innerText;
        if (srcObj.options[i].selected) {
            if (rightFlag) {
                if ($("selectMapDirect").value == WEST_WORK_UNIT) {
                    if (workUnitList.length == 1) {
                        if (linePGTable.getAttrValue("protectionType") == parentWin.PROTECT_TYPE1) {
                            alert(RESOURCE["INFO_1TO1_ONE"]);
                        }
                        else {
                            alert(RESOURCE["INFO_1PLUS1_ONE"]);
                        }
                        break;
                    }
                    showText = RESOURCE["westWorkUnit"] + ":" + showText;
                    workUnitList.push(srcObj.options[i].value);
                }
                else {
                    if (protectUnitList.length == 1) {
                        alert(RESOURCE["INFO_PROTECT_UNIT_ONE"]);
                        break;
                    }
                    showText = RESOURCE["westProtectUnit"] + ":" + showText;
                    protectUnitList.push(srcObj.options[i].value);
                }
            }
            else {
                var workUnit = showText.substring(0, showText.indexOf(":"));
                showText = showText.substring(showText.indexOf(":") + 1);
                if (workUnit == RESOURCE["westWorkUnit"]) {
                    workUnitList.remove(srcObj.options[i].value);
                }
                else {
                    protectUnitList.remove(srcObj.options[i].value);
                }
            }
            
            insertSelectOption(sinkObj, srcObj.options[i].value, showText);
            
            srcObj.remove(i);
            i--;
        }
    }
}

/**
 *             option        
 * @param selectObj  Select     insertValue    insertText        
 * @return   
 */
function insertSelectOption(selectObj, insertValue, insertText){

    var option = new Option(insertText, getInsertIndex(selectObj, insertValue));
    addOptionToSelect(selectObj, option);
    if (null == insertText) {
        insertText = insertValue;
    }
    option.innerText = insertText;
    option.value = insertValue;
}

/**
 *              
 * @param selectObj  Select     insertValue  
 * @return int:              
 */
function getInsertIndex(selectObj, insertValue){
    var optionObjArr = insertValue.split(":");
    var slotid = parseInt(optionObjArr[0]);
    var port = parseInt(optionObjArr[1]);
    
    var otherOptionObjArr
    var otherSlotid;
    var otherPort;
    for (var i = 0; i < selectObj.options.length; i++) {
        otherOptionObjArr = selectObj.options[i].value.split(":");
        otherSlotid = parseInt(otherOptionObjArr[0]);
        otherPort = parseInt(otherOptionObjArr[1]);
        if (slotid < otherSlotid) {
            return i;
        }
        else 
            if (slotid == otherSlotid && port <= otherPort) {
                return i;
            }
    }
    return selectObj.options.length;
}

/**
 *      option              
 * @param selectObj  Select    
 * @return   
 */
function clearSelectOptions(selectObj){
    for (var i = selectObj.options.length; i >= 0; i--) {
        selectObj.remove(selectObj.options[i]);
    }
}

function setApplyEnabled(){
    $("applyBtn").disabled = false;
}

/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showOperResult(data){
    var errArr = [];//           
    for (var i = 0, len = data.getBErrLength(); i < len; i++) {
        var tempObj = data.getError().rowErrors[i].errorObj;
        if (tempObj["slotid"]) {
            errArr[0] = "slotid";
            errArr[1] = "boardname";
            
            if ("255" == tempObj["subslotid"]) {
                errArr[2] = "portname";
            }
            else {
                errArr[2] = "subslotid";
                errArr[3] = "subboardname";
                errArr[4] = "portname";
            }
        }
        else {
            tempObj["groupID"] = RESOURCE["Line_MSP_ID"] + groupID;
            errArr[0] = "groupID";//           
        }
        
    }
    openErrPage("../../../../page/", data.getError(), errArr);
}

function EncapsulateDatas(doc){
    var dinterface = new DataInterface();
    var allerror = new AllError();
    var filterErrorCode = [];
    
    var rows = doc.getElementsByTagName("row-params");
    for (var i = 0; i < rows.length; i++) {
        var params = rows[i].getElementsByTagName("param");
        var obj = new Object();
        if (params.length > 0) {
            for (var j = 0; j < params.length; j++) {
                var ptag = new ParamTag();
                ptag.value = params[j].getAttribute("value");
                if (params[j].getElementsByTagName("option").length > 0) {
                    var ops = new Array();
                    for (var k = 0; k < params[j].getElementsByTagName("option").length; k++) {
                        ops[k] = params[j].getElementsByTagName("option")[k].getAttribute("value");
                    }
                    ptag.options = ops;
                }
                obj[params[j].getAttribute("name")] = ptag;
            }
            dinterface.rows[dinterface.rows.length] = obj;
        }
    }
    var page = doc.getElementsByTagName("page-params")[0];
    if (page) {
        var params = page.getElementsByTagName("param");
        for (var i = 0; i < params.length; i++) {
            var ptag = new ParamTag();
            dinterface.page[params[i].getAttribute("name")] = ptag;
            ptag.value = params[i].getAttribute("value");
        }
    }
    return dinterface;
}

/**
 * Query available protocal channels
 */
function getAvailableChannels()
{
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_PROTOCAL_CHANNEL + "&nmUser=" + parentWin.winobj["nmUser"];
    
    loadXMLdoc(url, "POST", false, callbackQueryChlRes, null, "inputdata=" + createQueryChannelResXMLInfo());
}

/**
 *            XML  
 * @param  
 * @return  
 */
function createQueryChannelResXMLInfo(){
    var root = new inputxml("datainterface");
    
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", parentWin.winobj["neid"]);
    row.appendChild(param);
	
    param = new tagElement("param");
    param.setAttribute("name", "channelid");
    param.setAttribute("value", "0");
    row.appendChild(param);
	
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackQueryChlRes(doc){
    var data = EncapsulateData(doc);
    var errorCode = data.getSErrorCode();
    if (0 != errorCode) {
		alert(RESOURCE["promptNoChannel"]);
        return;
    }
	var protocalchannelidElm = linePGTable.getAtom("protocalchannelid").element;
    for (var i = 0, len = data.getDataRowLength(); i < len; i++)
    {
        var protocalChanID = data.getDataRowParam(i, "channelid");
        var channeltype = data.getDataRowParam(i, "channeltype");
        var ip = convertNumToIpaddr(data.getDataRowParam(i, "ip"));
        var appendIP = ":" + ip;
        if(ip == "0.0.0.0")
        {
        	appendIP = "";
        }
        availableChannelList.append(protocalChanID);
        protocalchannelidElm.options[protocalchannelidElm.options.length] = new Option(protocalChanID + "(" + RESOURCE["channeltype" + channeltype] + appendIP + ")", protocalChanID);
    }
}

function stuffLog(key, value)
{
	if(logString != "")	 
	{
		logString += "," ;
	}
	logString += key + ":" + value
}
