var ct = null;
var win = getParentWindow();
var winurlobj = getNeProperty(win); 
var neId_Self = winurlobj.neid;

var LOCAL_INDICATION = 0;
var END_INDICATION = 1;

var TIMEOUT_2S = 0;
var TIMEOUT_10S = 1;

var START_IPPING = "1";
var STOP_IPPING = "2";
var REFRESH_IPPING = "3";
var ping_intervalID = null;

function init()
{
	initTable();
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);

    atom = new Atom("text");
    ct.addAttrRow("targetIP", RESOURCE["destipaddress"], atom);
    ct.setAttrValue("id", "targetIP");
    atom.setValue(win.getCurTestTargetIP());
    validateIp(atom.element);
    
    atom = new Atom("select"); //select,span
    ct.addAttrRow("direction", RESOURCE["direction"], atom);
    ct.setAttrValue("id", "direction");
    atom.addOption(RESOURCE["Local-Indication"], LOCAL_INDICATION);
    atom.addOption(RESOURCE["End-Indication"], END_INDICATION);
    
    atom = new Atom("span");
    ct.addAttrRow("board", RESOURCE["board"], atom);
    ct.setAttrValue("id", "board");
    atom.setValue(win.getCurTestIPPingBoard());
    
    atom = new Atom("span");
    ct.addAttrRow("port", RESOURCE["port"], atom);
    ct.setAttrValue("id", "port");
    atom.setValue(win.getCurTestIPPingPort());
    
    atom = new Atom("text");
    ct.addAttrRow("icmprequestnum", RESOURCE["icmprequestnum"], atom);
    ct.setAttrValue("id", "icmprequestnum");
    atom.setValue("3");
    validateNum(atom.element,1,65535,5);
    
    atom = new Atom("text");
    ct.addAttrRow("msglength", RESOURCE["msglength"], atom);
    ct.setAttrValue("id", "msglength");
    atom.setValue("64");
    validateNum(atom.element,64,1400,4);

    atom = new Atom("select");
    ct.addAttrRow("timeout", RESOURCE["timeout"], atom);
    ct.setAttrValue("id", "timeout");
    atom.addOption(RESOURCE["timeout_0"], TIMEOUT_2S);
    atom.addOption(RESOURCE["timeout_1"], TIMEOUT_10S);
    
    atom = new Atom("text");
    ct.addAttrRow("tos", RESOURCE["tos"], atom);
    ct.setAttrValue("id", "tos");
    atom.setValue("0");
    validateNum(atom.element,0,255,3);
    
    $("tbdiv").appendChild(ct.getTable());
    
    $("starttest").value = RESOURCE["start"];
    $("stoptest").value = RESOURCE["stop"];
    $("stoptest").disabled = true;
    $("testResultShow").innerHTML = RESOURCE["ID_TEST_RESULT"];
}

function doStartTest()
{
	$("starttest").disabled = true;
	var xml = createStartTestXml();
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_PTN_START_IPPING+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, startTestCallback, null, "inputdata="+xml );
}

function createStartTestXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;

    row = new tagElement("row-params");
        
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neId_Self);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "targetIP");
    param.setAttribute("value", convertIPStrToLong(ct.getAttrValue("targetIP")));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "curTargetIP");
    param.setAttribute("value", ct.getAttrValue("targetIP"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "direction");
    param.setAttribute("value", ct.getAttrValue("direction"));
    row.appendChild(param);

    var pingBoardSlot = win.getCurTestIPPingBoardSlotID();
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", pingBoardSlot);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "subslotid");
    param.setAttribute("value", 255);
    row.appendChild(param);

    var pingBoardPortID = win.getCurTestIPPingPortID();
    param = new tagElement("param");
    param.setAttribute("name", "port");
    param.setAttribute("value", pingBoardPortID);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "tos");
    param.setAttribute("value", ct.getAttrValue("tos"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "timeout");
    param.setAttribute("value", ct.getAttrValue("timeout"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "icmprequestnum");
    param.setAttribute("value", ct.getAttrValue("icmprequestnum"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "msglength");
    param.setAttribute("value", ct.getAttrValue("msglength"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "configKey");
    param.setAttribute("value", START_IPPING);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);

    return root.toString();
}

function startTestCallback(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (OPERATION_SUCCESS == data.getSErrorCode()) 
    {
    	$("testresult").value = "";
        $("stoptest").disabled = false;
        ping_intervalID = setInterval(refreshPingResult, 3000);
    }
    else 
    {
    	$("starttest").disabled = false;
        $("stoptest").disabled = true;
    }
}

function refreshPingResult()
{
    var xml = createRereshPingXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_IPPING_NOTIFY + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", true, refreshPingBackHandler, null, "inputdata=" + xml);
}

function createRereshPingXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neId_Self);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "curTargetIP");
    param.setAttribute("value", ct.getAttrValue("targetIP"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "configKey");
    param.setAttribute("value", REFRESH_IPPING);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function refreshPingBackHandler(doc)
{
    var data = EncapsulateData(doc);

    if (OPERATION_SUCCESS == data.getSErrorCode()) 
    {
        if (data.getDataRowParam(0, "endFlg") == "1") 
        {
            clearInterval(ping_intervalID);
            ping_intervalID = null;
        	$("starttest").disabled = false;
            $("stoptest").disabled = true;
        }
        
        var tempStr = data.getDataRowParam(0, "content");
        if ("" != tempStr) 
        {
            $("testresult").value = tempStr;
            document.getElementById("testresult").scrollTop = document.getElementById("testresult").scrollHeight;
        }
    }
}

function doStopTest()
{
	$("stoptest").disabled = true;              
	var xml = createStopTestXml();
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_PTN_STOP_IPPING+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, stopTestCallback, null, "inputdata="+xml );
}

function createStopTestXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;

    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neId_Self);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "curTargetIP");
    param.setAttribute("value", ct.getAttrValue("targetIP"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "configKey");
    param.setAttribute("value", STOP_IPPING);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);

    return root.toString();
}

function stopTestCallback(doc)
{		
	var data = EncapsulateData(doc);

	if (OPERATION_SUCCESS != data.getSErrorCode()) 
	{
		$("stoptest").disabled = false;
	    showErrorDialog(data);
	    return;
	}
	  
	$("starttest").disabled = false;
	$("stoptest").disabled = true;

    if (ping_intervalID) 
    {
        refreshPingResult();
    	clearInterval(ping_intervalID);
    	ping_intervalID = null;
    }
}

function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	errArr[3] = "portId";
	errArr[4] = "portname";
    openErrPage("../../../../page/", data.getError(), errArr);
    errArr = null;
}

window.onunload = function()
{
    if (ping_intervalID) 
    {
    	clearInterval(ping_intervalID);
    	ping_intervalID = null;
            doStopTest();
    }
}
