var ippingst;
var arpipst;

var winobj = getNeProperty(self);
var neid = winobj["neid"];
var btnRightArr = new Object();

var STATUS_DISABLED = "0";
var enableFlag = [];
enableFlag["0"] = RESOURCE["disabled"];
enableFlag["1"] = RESOURCE["enabled"];


var INVALID_IP = "255.255.255.255";
var INVALID_IP_ZERO = "0.0.0.0";

var INVALID_VLANID = "65535";

/**
 *      
 * @param  
 * @return  
 */
function init()
{
	initButton();
	initTable();
	if(btnRightArr.queryIpBtn.right)
	{
		queryIPPing();
	}
}

/**
 *          
 * @param  
 * @return  
 */
function initButton()
{
	$("arpipTableTitle").appendChild(document.createTextNode(RESOURCE["arpiptitle"]));
	$("pingTestBtn").value = RESOURCE["pingTest"];
	$("queryIpBtn").value = RESOURCE["querybutton"];
	$("applyIpBtn").value = RESOURCE["applybutton"];
	$("queryArpBtn").value = RESOURCE["querybutton"];

	btnRightArr.pingTestBtn = new BtnRightObj("pingTestBtn",TECMDCODE_PTN_START_IPPING);
	btnRightArr.queryIpBtn = new BtnRightObj("queryIpBtn",TECMDCODE_QUERY_PTN_IPPING_PARAMS);
    btnRightArr.applyIpBtn = new BtnRightObj("applyIpBtn",TECMDCODE_SET_PTN_IPPING_PARAMS);
    btnRightArr.queryArpBtn = new BtnRightObj("queryArpBtn",TECMDCODE_PTN_GET_ARPTABLE_BYPORT);

    getRightInfo(winobj, btnRightArr);
    $("pingTestBtn").disabled = true;
    $("queryIpBtn").disabled = !btnRightArr.queryIpBtn.right;
	$("applyIpBtn").disabled = true;
    $("queryArpBtn").disabled = true;
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
	ippingst = new SortTable();
	ippingst.setImage("../../../../../images/");
	ippingst.isUsedForSelectList = true;
	createTableHead(ippingst, window.tableconf[0]);
	ippingst.setOnCellEditHandler(ipPingCellEditHandler);
	ippingst.setOnRowSelectHandler(ipPingRowSelectHandler);
	$("ippingcontainer").appendChild(ippingst.getTable());
	$("ippingcontainer").oncontextmenu=popupMenuHandler;	  

	arpipst = new SortTable();
	arpipst.setImage("../../../../../images/");
	arpipst.isUsedForSelectList = true;
	createTableHead(arpipst, window.tableconf[1]);
	$("arpipcontainer").appendChild(arpipst.getTable());

	var totalHeight = getComponetHeight($("tablecomponent"), 330);
	ippingst.setBodyHeight(totalHeight + "px");
	arpipst.setBodyHeight(totalHeight * 0.2 + "px");
}

/**
 * IPPing         
 * @param param
 */
function ipPingCellEditHandler(/*Object*/param)
{
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applyIpBtn").disabled = !btnRightArr.applyIpBtn.right;
	}
}
/**
 * IPPing         ,       
 * @param param
 */
function ipPingRowSelectHandler(/*Array*/param)
{
	if(param.length > 0)
	{
		$("pingTestBtn").disabled = !btnRightArr.pingTestBtn.right;
	    $("queryArpBtn").disabled = !btnRightArr.queryArpBtn.right;
		queryArp(param[0]);
	}
}

/**
 *       
 * @param  
 * @return  
 */
function queryIPPing()
{
    $("pingTestBtn").disabled = true;
    $("queryIpBtn").disabled = true;
	$("applyIpBtn").disabled = true;
    $("queryArpBtn").disabled = true	
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTN_IPPING_PARAMS + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, queryIPPingcallback,null, "inputdata=" + createQueryIPPingXML());
}

/**
 *       IPPigg XML  
 * @param  
 * @return  
 */
function createQueryIPPingXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *             
 * @param doc:          
 * @return  
 */
function queryIPPingcallback(doc)
{
	var data = EncapsulateData(doc);
	var lastSelected = [];
	for(var i = 0,len = ippingst.getDataRowLength();i < len;i++)
	{
		if (ippingst.getRowSelFlag(i))
		{
			lastSelected[lastSelected.length] = ippingst.getCellStoreValue(i, "port","slotid") + "-" + ippingst.getCellStoreValue(i, "port","port");
		}
	}
	ippingst.clearTableData();
	createTableBody(ippingst, window.tableconf[0], data, RESOURCE);
	for(var i = 0; i < ippingst.getDataRowLength(); i++)
	{
	  	var storevalue = ippingst.getCellStoreValue(i, "port","slotid") + "-" + ippingst.getCellStoreValue(i, "port","port");
	  	var status = ippingst.getCellStoreValue(i, "status","status");
	  	if(status == STATUS_DISABLED)
	  	{
	  		refreshStatusDisabled(i);
	  	}
	  	else
	  	{
	  		var vlanid = ippingst.getCellStoreValue(i,"vlanid","vlanid");
	  		if(vlanid == INVALID_VLANID)
	  		{
	  			ippingst.getCellShow(i,"vlanid").setValue("/");
	  		}
			ippingst.setCellIsEdit(ippingst.getCell(i,"ip"),0);
			ippingst.setCellIsEdit(ippingst.getCell(i,"mask"),0);
			ippingst.setCellIsEdit(ippingst.getCell(i,"nextip"),0);
			ippingst.setCellIsEdit(ippingst.getCell(i,"nextmask"),0);
	  	}
	  	if(lastSelected.contains(storevalue))
	  	{
	  		singleClick(ippingst.getRow(i).element, true);
	  	}
	}
	
	ippingst.getCellEdit(0,"status").element.onchange = statusOnchange;
	
	validateIpForU2000Style(ippingst.getCellEdit(0,"ip").element,ippingst);
	validateIpForU2000Style(ippingst.getCellEdit(0,"mask").element,ippingst);
	validateIpForU2000Style(ippingst.getCellEdit(0,"nextip").element,ippingst);
	validateIpForU2000Style(ippingst.getCellEdit(0,"nextmask").element,ippingst);
	
	$("queryIpBtn").disabled = !btnRightArr.queryIpBtn.right;
	var selRows = ippingst.getSelectedRows();
	
	if(selRows.length > 0)
	{
		$("pingTestBtn").disabled = !btnRightArr.pingTestBtn.right;
	    $("queryArpBtn").disabled = !btnRightArr.queryArpBtn.right;
		queryArp(selRows[0]);
	}
	
	showErrorDialog(data);
}

/**
 *   IPPing        
 * @param rowIndex
 */
function refreshStatusDisabled(/*string*/rowIndex)
{
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"vlanid"),0);
	ippingst.getCellShow(rowIndex,"vlanid").setValue("-");
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"vlanpri"),0);
	ippingst.getCellShow(rowIndex,"vlanpri").setValue("-");
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"ip"),0);
	ippingst.getCellShow(rowIndex,"ip").setValue("-");
	ippingst.setCellValue(ippingst.getCell(rowIndex,"ip"),"ip",INVALID_IP);
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"mask"),0);
	ippingst.getCellShow(rowIndex,"mask").setValue("-");
	ippingst.setCellValue(ippingst.getCell(rowIndex,"mask"),"mask",INVALID_IP);
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"nextip"),0);
	ippingst.getCellShow(rowIndex,"nextip").setValue("-");
	ippingst.setCellValue(ippingst.getCell(rowIndex,"nextip"),"nextip",INVALID_IP);
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"nextmask"),0);
	ippingst.getCellShow(rowIndex,"nextmask").setValue("-");
	ippingst.setCellValue(ippingst.getCell(rowIndex,"nextmask"),"nextmask",INVALID_IP);
}

/**
 *   IPPing       
 * @param rowIndex
 */
function refreshStatusEnabled(/*String*/rowIndex)
{
	if(ippingst.getCellIsEdit(ippingst.getCell(rowIndex,"vlanid")) == "1")
	{
		return;
	}
	else
	{
		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"vlanid"),1);
		var vlanid = ippingst.getCellStoreValue(rowIndex,"vlanid","vlanid");
		if(vlanid == INVALID_VLANID)
		{
			vlanid = "/";
		}
		ippingst.getCellShow(rowIndex,"vlanid").setValue(vlanid);
		ippingst.setCellModify(rowIndex,"vlanid",true);
		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"vlanpri"),1);
		ippingst.getCellShow(rowIndex,"vlanpri").setValue(ippingst.getCellStoreValue(rowIndex,"vlanpri","vlanpri"));
		ippingst.setCellModify(rowIndex,"vlanpri",true);
		var ip = ippingst.getCellStoreValue(rowIndex,"ip","ip");
		ippingst.getCellShow(rowIndex,"ip").setValue(ip);
		if(ip == INVALID_IP)
		{
			ippingst.getCellShow(rowIndex,"ip").setValue(INVALID_IP_ZERO);
			ippingst.setCellValue(ippingst.getCell(rowIndex,"ip"),"ip",INVALID_IP_ZERO);
			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"ip"),1);
			ippingst.setCellModify(rowIndex,"ip",true);
		}
		var mask = ippingst.getCellStoreValue(rowIndex,"mask","mask");
		ippingst.getCellShow(rowIndex,"mask").setValue(mask);
		if(mask == INVALID_IP)
		{
			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"mask"),1);
			ippingst.setCellModify(rowIndex,"mask",true);
		}
		var nextip = ippingst.getCellStoreValue(rowIndex,"nextip","nextip");
		ippingst.getCellShow(rowIndex,"nextip").setValue(nextip);
		if(nextip == INVALID_IP)
		{
			ippingst.getCellShow(rowIndex,"nextip").setValue(INVALID_IP_ZERO);
			ippingst.setCellValue(ippingst.getCell(rowIndex,"nextip"),"nextip",INVALID_IP_ZERO);
			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"nextip"),1);
			ippingst.setCellModify(rowIndex,"nextip",true);
		}
		var nextmask = ippingst.getCellStoreValue(rowIndex,"nextmask","nextmask");
		ippingst.getCellShow(rowIndex,"nextmask").setValue(nextmask);
		if(nextmask == INVALID_IP)
		{
			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"nextmask"),1);
			ippingst.setCellModify(rowIndex,"nextmask",true);
		}
	}
}

/**
 *            
 */
function statusOnchange()
{
	var statusEdit = this;
	var rowIndex= statusEdit.parentNode.parentNode.rowIndex;
	var status = statusEdit.value;
	$("applyIpBtn").disabled = !btnRightArr.applyIpBtn.right;
	
	if(status == STATUS_DISABLED)
	{
		refreshStatusDisabled(rowIndex);
	}
	else
	{
		refreshStatusEnabled(rowIndex);
	}
}

/**
 *   IP Ping  
 */
function applyIPPing()
{
	var xml = createApplyIPPingXML();
	if(xml == null)
	{
		return;
	}

    $("pingTestBtn").disabled = true;
    $("queryIpBtn").disabled = true;
	$("applyIpBtn").disabled = true;
    $("queryArpBtn").disabled = true	
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTN_IPPING_PARAMS + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, applyIPPingcallback,null, "inputdata=" + xml);
}

/**
 *     IPPing   XML
 */
function createApplyIPPingXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	for(var rowindex = 0,rowlen = ippingst.getDataRowLength();rowindex<rowlen;rowindex++)
	{
    	if(!ippingst.getModify(rowindex))
    	{
    		continue;
    	}
    	row = new tagElement("row-params");
    	
    	appendSlotPortParam(row,rowindex);
    	
    	appendVlanParam(row,rowindex);
		
		var bResult = appendIPPingParam(row,rowindex);
		if(bResult == false)
		{
			return null;
		}

		bussiness.appendChild(row);
	}
	if(0 == bussiness.childNodes.length)
	{
		return null;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *           
 * @param row
 * @param rowindex
 */
function appendSlotPortParam(/*tagElement*/row,/*string*/rowindex)
{
	var param = new tagElement("param","neid",neid);
	row.appendChild(param);
	param = new tagElement("param","slotid",ippingst.getCellStoreValue(rowindex, "port", "slotid"));
	row.appendChild(param);
	param = new tagElement("param","port",ippingst.getCellStoreValue(rowindex, "port", "port"));
	row.appendChild(param);
	param = new tagElement("param","portlog",ippingst.getCellShow(rowindex, "port").getValue());
	row.appendChild(param);
}

/**
 *   VLAN    
 * @param row
 * @param rowindex
 */
function appendVlanParam(/*tagElement*/row,/*string*/rowindex)
{
	var vlanidModify = ippingst.getCellModify(rowindex,"vlanid");
	var vlanpriModify = ippingst.getCellModify(rowindex,"vlanpri");
	if(vlanidModify == true || vlanpriModify == true)
	{
		var vlanid = ippingst.getCellStoreValue(rowindex,"vlanid","vlanid");
		if(vlanid == "/")
		{
			vlanid = INVALID_VLANID;
		}
		var param = new tagElement("param","vlanid",vlanid);
		row.appendChild(param);
		param = new tagElement("param","vlanidlog",ippingst.getCellShow(rowindex,"vlanid").getValue());
		row.appendChild(param);
		param = new tagElement("param","vlanpri",ippingst.getCellStoreValue(rowindex,"vlanpri","vlanpri"));
		row.appendChild(param);
	}
}
/**
 *   IP    
 * @param row
 * @param rowindex
 */
function appendIPPingParam(/*tagElement*/row,/*string*/rowindex)
{
	var statusModify = ippingst.getCellModify(rowindex,"status");
	var ipModify = ippingst.getCellModify(rowindex,"ip");
	var maskModify = ippingst.getCellModify(rowindex,"mask");
	var nextipModify = ippingst.getCellModify(rowindex,"nextip");
	var nextmaskModify = ippingst.getCellModify(rowindex,"nextmask");
	if(statusModify == true || ipModify == true || maskModify == true || nextipModify == true || nextmaskModify == true )
	{
		var status = ippingst.getCellStoreValue(rowindex,"status","status");
		var ip = ippingst.getCellStoreValue(rowindex,"ip","ip");
		var mask = ippingst.getCellStoreValue(rowindex,"mask","mask");
		var nextip = ippingst.getCellStoreValue(rowindex,"nextip","nextip");
		var nextmask = ippingst.getCellStoreValue(rowindex,"nextmask","nextmask");
		if(status == STATUS_DISABLED)
		{
			ip = INVALID_IP;
			mask = INVALID_IP;
			nextip = INVALID_IP;
			nextmask = INVALID_IP;
		}
		else
		{
			if(isIPInvalid(ip) || isIPInvalid(mask) || isIPInvalid(nextip) || isIPInvalid(nextmask))
			{
				alert(RESOURCE["IDS_INVALUABLEIP"]);
				return false;
			}
		}
		param = new tagElement("param","status",status);
		row.appendChild(param);
		param = new tagElement("param","ip",ip);
		row.appendChild(param);
		param = new tagElement("param","mask",mask);
		row.appendChild(param);
		param = new tagElement("param","nextip",nextip);
		row.appendChild(param);
		param = new tagElement("param","nextmask",nextmask);
		row.appendChild(param);
	}
	return true;
}

/**
 *   IPPing       
 * @param doc
 */
function applyIPPingcallback(/*XMLDOM*/doc)
{
	var data = EncapsulateData(doc);
	
	if(OPERATION_SUCCESS != data.getSErrorCode() )
	{
		$("applyIpBtn").disabled = !btnRightArr.applyIpBtn.right;
		showErrorDialog(data);
	}
	else
	{
		refreshTableState(ippingst,window.tableconf[0],data);
		for(var i = 0; i < ippingst.getDataRowLength(); i++)
	  {
	  	var status = ippingst.getCellStoreValue(i, "status","status");
	  	if(ippingst.getCellModify(i,"status") == true)
	  	{
	  		continue;
	  	}
	  	if(status == STATUS_DISABLED)
	  	{
			refreshStatusDisabled(i);
	  	}
	  	else
	  	{
	  		ippingst.setCellIsEdit(ippingst.getCell(i,"ip"),0);
			ippingst.setCellIsEdit(ippingst.getCell(i,"mask"),0);
			ippingst.setCellIsEdit(ippingst.getCell(i,"nextip"),0);
			ippingst.setCellIsEdit(ippingst.getCell(i,"nextmask"),0);
	  	}
	  }
	}
	
	$("queryIpBtn").disabled = !btnRightArr.queryIpBtn.right;
	$("applyIpBtn").disabled = true;
	var selRows = ippingst.getSelectedRows();
	
	if(selRows.length > 0)
	{
	    $("pingTestBtn").disabled = !btnRightArr.pingTestBtn.right;
	    $("queryArpBtn").disabled = !btnRightArr.queryArpBtn.right;
	}
}

/**
 *   ARPIP
 * @param rowIndex
 * @return  
 */
function queryArp(/*string*/rowIndex)
{
	if (typeof(rowIndex) == "undefined")
    {
		rowIndex = ippingst.getSelectedRows()[0];
    }

	var xml = createQueryArpXML(rowIndex);
	if(xml == null)
	{
		return;
	}

	$("queryArpBtn").disabled = true;
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_GET_ARPTABLE_BYPORT + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, queryArpCallback, null, "inputdata="+ xml);
}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createQueryArpXML(/*string*/rowIndex)
{
	if(rowIndex < 0 || rowIndex > (ippingst.getDataRowLength() - 1))
	{
		return null;
	}
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param","neid",neid);
	row.appendChild(param);
	
	param = new tagElement("param","slotid",ippingst.getCellStoreValue(rowIndex, "port", "slotid"));
	row.appendChild(param);
	
	param = new tagElement("param","port",ippingst.getCellStoreValue(rowIndex, "port", "port"));
	row.appendChild(param);
	
	param = new tagElement("param","portlog",ippingst.getCellShow(rowIndex, "port").getValue());
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *   ARPIP       
 * @param doc
 */
function queryArpCallback(/*XMLDOM*/doc)
{
    $("queryArpBtn").disabled = !btnRightArr.queryArpBtn.right;
	var data = EncapsulateData(doc);
    if (OPERATION_SUCCESS == data.getError().getGlobleECode()) 
    {
  	    for(var i = 0, len = data.getDataRowLength(); i < len; i++)
        {
  	    	var macParam = new ParamTag();
  	    	var tempMacStr = data.getDataRowParam(i,"macAdd");
  	    	macParam.value = tempMacStr.substring(0,2) + "-" 
                            + tempMacStr.substring(2,4) + "-"
                            + tempMacStr.substring(4,6) + "-"
                            + tempMacStr.substring(6,8) + "-"
                            + tempMacStr.substring(8,10) + "-"
                            + tempMacStr.substring(10,12);
  	    	data.rows[i]["macAdd"] = macParam;
        }
  	    
    	arpipst.clearTableData();
    	createTableBody(arpipst, window.tableconf[1], data, RESOURCE);
    }
    else
    {
		showErrorDialog(data);
    }
}

/**
 *       
 *               
 */
function showErrorDialog(/*Object*/data)
{
	var errArr = [];
	errArr[0] = "slotid";
	errArr[1] = "boardname";
	errArr[2] = "portname";
	openErrPage("../../../../page/", data.getError(), errArr); 
}

/**
 *   IP      ,    true,    false
 * @param ip IP  
 */
function isIPInvalid(/*string*/ip)
{
	return (ip == "" || ip == INVALID_IP_ZERO || ip == INVALID_IP);
}

/**
 *   IP Ping    
 */
function showIPPingTestDialog()
{
	xshowModalDialog("ippingtest.html", RESOURCE["pingTestTitle"], 600, 600, "../../../../images/", false);
}

function getCurTestIPPingBoard()
{
	var curBoard;
	var selRows = ippingst.getSelectedRows();
	if(selRows.length > 0)
	{
		curBoard = ippingst.getCellStoreValue(selRows[0], "port", "slotid") + "-" + ippingst.getCellStoreValue(selRows[0], "port", "boardname");
	}
	return curBoard;
}

function getCurTestIPPingBoardSlotID()
{
	var curBoardSlot;
	var selRows = ippingst.getSelectedRows();
	if(selRows.length > 0)
	{
		curBoardSlot = ippingst.getCellStoreValue(selRows[0], "port", "slotid");
	}
	return curBoardSlot;
}

function getCurTestIPPingPort()
{
	var curPort;
	var selRows = ippingst.getSelectedRows();
	if(selRows.length > 0)
	{
		curPort = ippingst.getCellStoreValue(selRows[0], "port", "portname");
	}
	return curPort;
}

function getCurTestIPPingPortID()
{
	var curPortID;
	var selRows = ippingst.getSelectedRows();
	if(selRows.length > 0)
	{
		curPortID = ippingst.getCellStoreValue(selRows[0], "port", "port");
	}
	return curPortID;
}

function getCurTestTargetIP()
{
    var curIP;
	var selRows = ippingst.getSelectedRows();
	if(selRows.length > 0)
	{
		curIP = ippingst.getCellStoreValue(selRows[0], "nextip", "nextip");
	}
	return curIP;
}

